/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.prefix.service.tablist;

import eu.thesimplecloud.module.permission.PermissionPool;
import eu.thesimplecloud.module.permission.player.IPermissionPlayer;
import eu.thesimplecloud.module.prefix.config.Config;
import eu.thesimplecloud.module.prefix.config.TablistInformation;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/module/prefix/service/tablist/TablistHelper;", "", "()V", "getTablistInformationByPlayer", "Leu/thesimplecloud/module/prefix/config/TablistInformation;", "player", "Lorg/bukkit/entity/Player;", "getTablistInformationByUUID", "uuid", "Ljava/util/UUID;", "initScoreboard", "", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "load", "setPlayerInScoreboard", "updateScoreboardForAllPlayers", "updateScoreboardForPlayer", "simplecloud-module-chat-tab"})
public final class TablistHelper {
    @NotNull
    public static final TablistHelper INSTANCE = new TablistHelper();

    private TablistHelper() {
    }

    public final void load() {
        Object object;
        Scoreboard scoreboard;
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        Scoreboard scoreboard2 = scoreboard = scoreboardManager == null ? null : scoreboardManager.getMainScoreboard();
        if (scoreboard == null) {
            return;
        }
        Scoreboard scoreboard3 = object = scoreboard;
        this.initScoreboard(scoreboard3);
        object = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOnlinePlayers()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            INSTANCE.updateScoreboardForPlayer(it);
        }
    }

    private final void initScoreboard(Scoreboard scoreboard) {
        Iterable $this$forEach$iv = Config.Companion.getConfig().getInformationList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TablistInformation it = (TablistInformation)element$iv;
            boolean bl = false;
            Team team = scoreboard.getTeam(String.valueOf(it.getPriority()));
            Team team2 = team == null ? scoreboard.registerNewTeam(String.valueOf(it.getPriority())) : team;
            Intrinsics.checkNotNullExpressionValue((Object)team2, (String)"scoreboard.getTeam(it.pr\u2026m(it.priority.toString())");
            Team team3 = team2;
            ChatColor chatColor = ChatColor.valueOf((String)it.getColor());
            team3.setPrefix(Intrinsics.stringPlus((String)ChatColor.translateAlternateColorCodes((char)'&', (String)it.getPrefix()), (Object)chatColor));
            team3.setSuffix(ChatColor.translateAlternateColorCodes((char)'&', (String)it.getSuffix()));
            try {
                team3.setColor(chatColor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
        }
    }

    public final void updateScoreboardForAllPlayers() {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            INSTANCE.updateScoreboardForPlayer(it);
        }
    }

    public final void updateScoreboardForPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getScoreboard();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.scoreboard");
        Scoreboard scoreboard = object;
        this.initScoreboard(scoreboard);
        object = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOnlinePlayers()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            INSTANCE.setPlayerInScoreboard(it, scoreboard);
        }
    }

    private final void setPlayerInScoreboard(Player player, Scoreboard scoreboard) {
        Team team;
        Set set = scoreboard.getTeams();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"scoreboard.teams");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Team it = (Team)element$iv;
            boolean bl = false;
            it.removeEntry(player.getName());
        }
        TablistInformation $i$f$forEach22 = this.getTablistInformationByPlayer(player);
        if ($i$f$forEach22 == null) {
            return;
        }
        TablistInformation tablistInformation = $i$f$forEach22;
        String teamName = String.valueOf(tablistInformation.getPriority());
        Team team2 = scoreboard.getTeam(teamName);
        if (team2 == null) {
            return;
        }
        Team team3 = team = team2;
        team3.addEntry(player.getName());
    }

    @Nullable
    public final TablistInformation getTablistInformationByPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        return this.getTablistInformationByUUID(uUID);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TablistInformation getTablistInformationByUUID(@NotNull UUID uuid) {
        Object element$iv2;
        block2: {
            void $this$first$iv;
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            IPermissionPlayer iPermissionPlayer = PermissionPool.Companion.getInstance().getPermissionPlayerManager().getCachedPermissionPlayer(uuid);
            if (iPermissionPlayer == null) {
                return null;
            }
            IPermissionPlayer permissionPlayer = iPermissionPlayer;
            List<TablistInformation> informationList = Config.Companion.getConfig().getInformationList();
            Iterable $this$sortedBy$iv = informationList;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    TablistInformation it = (TablistInformation)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (TablistInformation)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getPriority();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                TablistInformation it = (TablistInformation)element$iv2;
                boolean bl2 = false;
                if (!permissionPlayer.hasPermissionGroup(it.getGroupName())) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        TablistInformation tablistInformation = (TablistInformation)element$iv2;
        return tablistInformation;
    }
}

