/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.notify;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.event.service.CloudServiceRegisteredEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.eventapi.CloudEventHandler;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.module.notify.NotifyModule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Leu/thesimplecloud/module/notify/CloudListener;", "Leu/thesimplecloud/api/eventapi/IListener;", "module", "Leu/thesimplecloud/module/notify/NotifyModule;", "(Leu/thesimplecloud/module/notify/NotifyModule;)V", "getModule", "()Leu/thesimplecloud/module/notify/NotifyModule;", "permission", "", "on", "", "event", "Leu/thesimplecloud/api/event/service/CloudServiceRegisteredEvent;", "Leu/thesimplecloud/api/event/service/CloudServiceStartedEvent;", "Leu/thesimplecloud/api/event/service/CloudServiceUnregisteredEvent;", "sendMessage", "service", "Leu/thesimplecloud/api/service/ICloudService;", "message", "addClick", "", "simplecloud-module-notify"})
public final class CloudListener
implements IListener {
    @NotNull
    private final NotifyModule module;
    @NotNull
    private final String permission;

    public CloudListener(@NotNull NotifyModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.permission = "cloud.module.notify.messages";
    }

    @NotNull
    public final NotifyModule getModule() {
        return this.module;
    }

    @CloudEventHandler
    public final void on(@NotNull CloudServiceRegisteredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.sendMessage(event.getCloudService(), this.module.getConfig().getServiceStartingMessage(), false);
    }

    @CloudEventHandler
    public final void on(@NotNull CloudServiceStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.sendMessage(event.getCloudService(), this.module.getConfig().getServiceStartedMessage(), true);
    }

    @CloudEventHandler
    public final void on(@NotNull CloudServiceUnregisteredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.sendMessage(event.getCloudService(), this.module.getConfig().getServiceStoppedMessage(), false);
    }

    private final void sendMessage(ICloudService service, String message, boolean addClick) {
        String serviceName = service.getName();
        String replacedMessage = StringsKt.replace$default((String)message, (String)"%SERVICE%", (String)serviceName, (boolean)false, (int)4, null);
        CloudText cloudText = new CloudText(replacedMessage);
        if (addClick) {
            cloudText.addHover(this.module.getConfig().getHoverMessage());
            cloudText.addClickEvent(CloudText.ClickEventType.RUN_COMMAND, Intrinsics.stringPlus((String)"/server ", (Object)service.getName()));
        }
        Iterable $this$forEach$iv = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudPlayer cloudPlayer = (ICloudPlayer)element$iv;
            boolean bl = false;
            cloudPlayer.hasPermission(this.permission).then((Function1)new Function1<Boolean, Unit>(cloudPlayer, cloudText){
                final /* synthetic */ ICloudPlayer $cloudPlayer;
                final /* synthetic */ CloudText $cloudText;
                {
                    this.$cloudPlayer = $cloudPlayer;
                    this.$cloudText = $cloudText;
                    super(1);
                }

                public final void invoke(boolean it) {
                    if (it) {
                        this.$cloudPlayer.sendMessage(this.$cloudText);
                    }
                }
            });
        }
    }
}

