/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.notify;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.notify.CloudListener;
import eu.thesimplecloud.module.notify.config.Config;
import eu.thesimplecloud.module.notify.config.DefaultConfig;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/module/notify/NotifyModule;", "Leu/thesimplecloud/api/external/ICloudModule;", "()V", "config", "Leu/thesimplecloud/module/notify/config/Config;", "getConfig", "()Leu/thesimplecloud/module/notify/config/Config;", "setConfig", "(Leu/thesimplecloud/module/notify/config/Config;)V", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "loadConfig", "", "onDisable", "onEnable", "saveConfig", "simplecloud-module-notify"})
public final class NotifyModule
implements ICloudModule {
    @NotNull
    private final File configFile = new File("modules/notify", "config.json");
    public Config config;

    @NotNull
    public final File getConfigFile() {
        return this.configFile;
    }

    @NotNull
    public final Config getConfig() {
        Config config = this.config;
        if (config != null) {
            return config;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        this.config = config;
    }

    public void onEnable() {
        this.loadConfig();
        CloudAPI.Companion.getInstance().getEventManager().registerListener((ICloudModule)this, (IListener)new CloudListener(this));
    }

    public void onDisable() {
    }

    public final void loadConfig() {
        Config config;
        if (!this.configFile.exists()) {
            config = DefaultConfig.Companion.get();
            this.saveConfig(config);
            this.setConfig(config);
        }
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)this.configFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib);
        config = (Config)jsonLib.getObject(Config.class);
        this.setConfig(config);
    }

    public final void saveConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JsonLib.Companion.fromObject((Object)config).saveAsFile(this.configFile);
    }

    public final void saveConfig() {
        this.saveConfig(this.getConfig());
    }

    public boolean isReloadable() {
        return ICloudModule.DefaultImpls.isReloadable((ICloudModule)this);
    }
}

