/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.proxy.manager;

import eu.thesimplecloud.api.event.group.CloudServiceGroupCreatedEvent;
import eu.thesimplecloud.api.eventapi.CloudEventHandler;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.module.proxy.config.Config;
import eu.thesimplecloud.module.proxy.config.DefaultConfig;
import eu.thesimplecloud.module.proxy.config.ProxyGroupConfiguration;
import eu.thesimplecloud.module.proxy.manager.ProxyModule;
import eu.thesimplecloud.module.proxy.service.ProxyHandler;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/module/proxy/manager/GroupCreateListener;", "Leu/thesimplecloud/api/eventapi/IListener;", "proxyModule", "Leu/thesimplecloud/module/proxy/manager/ProxyModule;", "(Leu/thesimplecloud/module/proxy/manager/ProxyModule;)V", "handle", "", "event", "Leu/thesimplecloud/api/event/group/CloudServiceGroupCreatedEvent;", "simplecloud-module-proxy"})
public final class GroupCreateListener
implements IListener {
    @NotNull
    private final ProxyModule proxyModule;

    public GroupCreateListener(@NotNull ProxyModule proxyModule) {
        Intrinsics.checkNotNullParameter((Object)proxyModule, (String)"proxyModule");
        this.proxyModule = proxyModule;
    }

    @CloudEventHandler
    public final void handle(@NotNull CloudServiceGroupCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Config currentConfig = (Config)ProxyHandler.INSTANCE.getConfigHolder().getValue();
        ICloudServiceGroup proxyGroup = event.getServiceGroup();
        if (proxyGroup.getServiceType() != ServiceType.PROXY) {
            return;
        }
        if (this.proxyModule.getProxyConfiguration(proxyGroup.getName()) != null) {
            return;
        }
        ProxyGroupConfiguration proxyGroupConfiguration = DefaultConfig.Companion.getDefaultProxyGroupConfiguration(proxyGroup.getName());
        Config newConfig = new Config(CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)currentConfig.getProxyGroupConfigurations(), (Iterable)CollectionsKt.listOf((Object)proxyGroupConfiguration))), currentConfig.getTablistConfigurations(), currentConfig.getMaintenanceKickMessage(), currentConfig.getFullProxyKickMessage());
        this.proxyModule.saveConfig(newConfig);
        this.proxyModule.loadConfig();
    }
}

