/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.proxy.manager;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.event.group.CloudServiceGroupUpdatedEvent;
import eu.thesimplecloud.api.eventapi.CloudEventHandler;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.module.proxy.config.Config;
import eu.thesimplecloud.module.proxy.config.ProxyGroupConfiguration;
import eu.thesimplecloud.module.proxy.extensions.ListExtensionKt;
import eu.thesimplecloud.module.proxy.service.ProxyHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Leu/thesimplecloud/module/proxy/manager/MaintenanceToggleListener;", "Leu/thesimplecloud/api/eventapi/IListener;", "()V", "configHolder", "Leu/thesimplecloud/api/property/IProperty;", "Leu/thesimplecloud/module/proxy/config/Config;", "getConfig", "getProxyConfigurations", "", "Leu/thesimplecloud/module/proxy/config/ProxyGroupConfiguration;", "isJoinPermissionGranted", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "player", "Leu/thesimplecloud/api/player/ICloudPlayer;", "isPlayerOnWhitelist", "serviceGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "kickIfPermissionNotGrantedAndNotOnWhitelist", "", "kickPlayerDueToMaintenance", "kickUnallowedPlayers", "on", "event", "Leu/thesimplecloud/api/event/group/CloudServiceGroupUpdatedEvent;", "simplecloud-module-proxy"})
public final class MaintenanceToggleListener
implements IListener {
    @NotNull
    private final IProperty<Config> configHolder = ProxyHandler.INSTANCE.getConfigHolder();

    @CloudEventHandler
    public final void on(@NotNull CloudServiceGroupUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ICloudServiceGroup serviceGroup = event.getServiceGroup();
        if (serviceGroup.isInMaintenance() && serviceGroup.getServiceType() == ServiceType.PROXY) {
            this.kickUnallowedPlayers(serviceGroup);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void kickUnallowedPlayers(ICloudServiceGroup serviceGroup) {
        void $this$filterTo$iv$iv;
        List allPlayers = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects();
        Iterable $this$filter$iv = allPlayers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudPlayer it = (ICloudPlayer)element$iv$iv;
            boolean bl = false;
            ICloudService iCloudService = it.getConnectedProxy();
            if (!Intrinsics.areEqual((Object)(iCloudService == null ? null : iCloudService.getServiceGroup()), (Object)serviceGroup)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playersOnline = (List)destination$iv$iv;
        Iterable $this$forEach$iv = playersOnline;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudPlayer it = (ICloudPlayer)element$iv;
            boolean bl = false;
            this.kickIfPermissionNotGrantedAndNotOnWhitelist(it, serviceGroup);
        }
    }

    private final void kickIfPermissionNotGrantedAndNotOnWhitelist(ICloudPlayer player, ICloudServiceGroup serviceGroup) {
        ICommunicationPromise<Boolean> hasPermissionPromise = this.isJoinPermissionGranted(player);
        hasPermissionPromise.then((Function1)new Function1<Boolean, Unit>(this, player, serviceGroup){
            final /* synthetic */ MaintenanceToggleListener this$0;
            final /* synthetic */ ICloudPlayer $player;
            final /* synthetic */ ICloudServiceGroup $serviceGroup;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$serviceGroup = $serviceGroup;
                super(1);
            }

            public final void invoke(boolean hasMaintenancePermission) {
                if (!hasMaintenancePermission && !MaintenanceToggleListener.access$isPlayerOnWhitelist(this.this$0, this.$player, this.$serviceGroup)) {
                    MaintenanceToggleListener.access$kickPlayerDueToMaintenance(this.this$0, this.$player);
                }
            }
        });
    }

    private final void kickPlayerDueToMaintenance(ICloudPlayer player) {
        Config config = this.getConfig();
        player.kick(config.getMaintenanceKickMessage());
    }

    private final boolean isPlayerOnWhitelist(ICloudPlayer player, ICloudServiceGroup serviceGroup) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.getProxyConfigurations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProxyGroupConfiguration it = (ProxyGroupConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProxyGroup(), (Object)serviceGroup.getName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Object object = v0;
        if (object == null) {
            return false;
        }
        ProxyGroupConfiguration proxyConfig = object;
        List<String> list = ListExtensionKt.mapToLowerCase(proxyConfig.getWhitelist());
        object = player.getName();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        return list.contains(string);
    }

    private final ICommunicationPromise<Boolean> isJoinPermissionGranted(ICloudPlayer player) {
        return player.hasPermission("cloud.maintenance.join");
    }

    private final List<ProxyGroupConfiguration> getProxyConfigurations() {
        return this.getConfig().getProxyGroupConfigurations();
    }

    private final Config getConfig() {
        return (Config)this.configHolder.getValue();
    }

    public static final /* synthetic */ boolean access$isPlayerOnWhitelist(MaintenanceToggleListener $this, ICloudPlayer player, ICloudServiceGroup serviceGroup) {
        return $this.isPlayerOnWhitelist(player, serviceGroup);
    }

    public static final /* synthetic */ void access$kickPlayerDueToMaintenance(MaintenanceToggleListener $this, ICloudPlayer player) {
        $this.kickPlayerDueToMaintenance(player);
    }
}

