/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.proxy.manager;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.Property;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.module.proxy.config.Config;
import eu.thesimplecloud.module.proxy.config.DefaultConfig;
import eu.thesimplecloud.module.proxy.config.ProxyGroupConfiguration;
import eu.thesimplecloud.module.proxy.manager.GroupCreateListener;
import eu.thesimplecloud.module.proxy.manager.MaintenanceToggleListener;
import eu.thesimplecloud.module.proxy.manager.commands.ProxyCommand;
import eu.thesimplecloud.module.proxy.service.ProxyHandler;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/module/proxy/manager/ProxyModule;", "Leu/thesimplecloud/api/external/ICloudModule;", "()V", "configFile", "Ljava/io/File;", "getConfig", "Leu/thesimplecloud/module/proxy/config/Config;", "getProxyConfiguration", "Leu/thesimplecloud/module/proxy/config/ProxyGroupConfiguration;", "serviceGroupName", "", "loadConfig", "", "onDisable", "onEnable", "saveConfig", "config", "simplecloud-module-proxy"})
public final class ProxyModule
implements ICloudModule {
    @NotNull
    private final File configFile = new File("modules/proxy", "config.json");

    public void onEnable() {
        this.loadConfig();
        Launcher.Companion.getInstance().getCommandManager().registerCommand((ICloudModule)this, (ICommandHandler)new ProxyCommand(this));
        CloudAPI.Companion.getInstance().getEventManager().registerListener((ICloudModule)this, (IListener)new GroupCreateListener(this));
        CloudAPI.Companion.getInstance().getEventManager().registerListener((ICloudModule)this, (IListener)new MaintenanceToggleListener());
    }

    public void onDisable() {
    }

    public final void loadConfig() {
        Config config;
        if (!this.configFile.exists()) {
            config = DefaultConfig.Companion.get();
            this.saveConfig(config);
        }
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)this.configFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib);
        config = (Config)jsonLib.getObject(Config.class);
        ProxyHandler.INSTANCE.setConfigHolder((IProperty<Config>)((IProperty)new Property((Object)config)));
        config.update();
    }

    public final void saveConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JsonLib.Companion.fromObject((Object)config).saveAsFile(this.configFile);
    }

    public final void saveConfig() {
        this.saveConfig(this.getConfig());
    }

    @Nullable
    public final ProxyGroupConfiguration getProxyConfiguration(@NotNull String serviceGroupName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)serviceGroupName, (String)"serviceGroupName");
            Iterable $this$firstOrNull$iv = this.getConfig().getProxyGroupConfigurations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProxyGroupConfiguration it = (ProxyGroupConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProxyGroup(), (Object)serviceGroupName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Config getConfig() {
        return (Config)ProxyHandler.INSTANCE.getConfigHolder().getValue();
    }

    public boolean isReloadable() {
        return ICloudModule.DefaultImpls.isReloadable((ICloudModule)this);
    }
}

