/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.proxy.manager.commands;

import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.module.proxy.config.ProxyGroupConfiguration;
import eu.thesimplecloud.module.proxy.extensions.ListExtensionKt;
import eu.thesimplecloud.module.proxy.manager.ProxyModule;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Command(name="proxy", commandType=CommandType.CONSOLE_AND_INGAME, permission="cloud.module.proxy")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J$\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\bH\u0007J$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\bH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/module/proxy/manager/commands/ProxyCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "module", "Leu/thesimplecloud/module/proxy/manager/ProxyModule;", "(Leu/thesimplecloud/module/proxy/manager/ProxyModule;)V", "getModule", "()Leu/thesimplecloud/module/proxy/manager/ProxyModule;", "propertyPrefix", "", "handleReload", "", "sender", "Leu/thesimplecloud/api/command/ICommandSender;", "handleWhitelistAdd", "proxyName", "playerName", "handleWhitelistRemove", "simplecloud-module-proxy"})
public final class ProxyCommand
implements ICommandHandler {
    @NotNull
    private final ProxyModule module;
    @NotNull
    private final String propertyPrefix;

    public ProxyCommand(@NotNull ProxyModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.propertyPrefix = "module.proxy.command.";
    }

    @NotNull
    public final ProxyModule getModule() {
        return this.module;
    }

    @CommandSubPath(path="reload", description="Reloads the proxy module")
    public final void handleReload(@NotNull ICommandSender sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        this.module.loadConfig();
        sender.sendProperty(Intrinsics.stringPlus((String)this.propertyPrefix, (Object)"reload"), new String[0]);
    }

    @CommandSubPath(path="<proxyName> whitelist add <playerName>", description="Adds a player to whitelist")
    public final void handleWhitelistAdd(@NotNull ICommandSender sender, @CommandArgument(name="proxyName") @NotNull String proxyName, @CommandArgument(name="playerName") @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)proxyName, (String)"proxyName");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        ProxyGroupConfiguration proxyConfiguration = this.module.getProxyConfiguration(proxyName);
        if (proxyConfiguration == null) {
            sender.sendProperty(Intrinsics.stringPlus((String)this.propertyPrefix, (Object)"whitelist.proxy-not-found"), new String[0]);
            return;
        }
        List<String> list = ListExtensionKt.mapToLowerCase(proxyConfiguration.getWhitelist());
        String[] stringArray = playerName;
        boolean bl = false;
        String string = stringArray.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        if (list.contains(string)) {
            sender.sendProperty(Intrinsics.stringPlus((String)this.propertyPrefix, (Object)"whitelist.already-whitelisted"), new String[0]);
            return;
        }
        proxyConfiguration.getWhitelist().add((String)playerName);
        this.module.getConfig().update();
        this.module.saveConfig();
        stringArray = new String[]{playerName};
        sender.sendProperty(Intrinsics.stringPlus((String)this.propertyPrefix, (Object)"whitelist.added"), stringArray);
    }

    @CommandSubPath(path="<proxyName> whitelist remove <playerName>", description="Removes a player from whitelist")
    public final void handleWhitelistRemove(@NotNull ICommandSender sender, @CommandArgument(name="proxyName") @NotNull String proxyName, @CommandArgument(name="playerName") @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)proxyName, (String)"proxyName");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        ProxyGroupConfiguration proxyConfiguration = this.module.getProxyConfiguration(proxyName);
        if (proxyConfiguration == null) {
            sender.sendProperty(Intrinsics.stringPlus((String)this.propertyPrefix, (Object)"whitelist.proxy-not-found"), new String[0]);
            return;
        }
        List<String> list = ListExtensionKt.mapToLowerCase(proxyConfiguration.getWhitelist());
        String[] stringArray = playerName;
        boolean bl = false;
        String string = stringArray.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        if (!list.contains(string)) {
            sender.sendProperty(Intrinsics.stringPlus((String)this.propertyPrefix, (Object)"whitelist.not-whitelisted"), new String[0]);
            return;
        }
        proxyConfiguration.getWhitelist().remove(playerName);
        this.module.getConfig().update();
        this.module.saveConfig();
        stringArray = new String[]{playerName};
        sender.sendProperty(Intrinsics.stringPlus((String)this.propertyPrefix, (Object)"whitelist.removed"), stringArray);
    }
}

