/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.auth;

import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.rest.auth.JwtProvider;
import eu.thesimplecloud.module.rest.auth.controller.LoginDto;
import eu.thesimplecloud.module.rest.auth.user.User;
import eu.thesimplecloud.module.rest.auth.user.permission.Permission;
import eu.thesimplecloud.module.rest.controller.IExceptionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\b\u0010\u001a\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Leu/thesimplecloud/module/rest/auth/AuthService;", "Leu/thesimplecloud/module/rest/controller/IExceptionHelper;", "()V", "users", "", "Leu/thesimplecloud/module/rest/auth/user/User;", "usersFile", "Ljava/io/File;", "cloneUser", "user", "doesUserExist", "", "userName", "", "getUserByName", "getUsers", "", "handleAddUser", "handleLogin", "login", "Leu/thesimplecloud/module/rest/auth/controller/LoginDto;", "handleUserDelete", "", "handleUserGet", "username", "handleUserUpdate", "saveUpdateToFile", "UserAlreadyExistException", "UserNotExistException", "simplecloud-module-rest"})
public final class AuthService
implements IExceptionHelper {
    @NotNull
    private final File usersFile = new File("modules/rest/users.json");
    @NotNull
    private final List<User> users;

    public AuthService() {
        if (!this.usersFile.exists()) {
            this.users = new ArrayList();
            String string = RandomStringUtils.randomAlphabetic((int)32);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomAlphabetic(32)");
            User standardUser = new User("admin", string);
            standardUser.addPermission(new Permission("*", true));
            this.users.add(standardUser);
            this.saveUpdateToFile();
        } else {
            JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)this.usersFile, null, (int)2, null);
            Intrinsics.checkNotNull((Object)jsonLib);
            this.users = ArraysKt.toMutableList((Object[])((Object[])jsonLib.getObject(User[].class)));
        }
    }

    @Nullable
    public final String handleLogin(@NotNull LoginDto login) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        User user = this.getUserByName(login.getUsername());
        if (user == null || !Intrinsics.areEqual((Object)user.getPassword(), (Object)login.getPassword())) {
            return null;
        }
        return JwtProvider.Companion.getInstance().getProvider().generateToken((Object)user);
    }

    @NotNull
    public final User handleAddUser(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (this.doesUserExist(user.getUsername())) {
            this.throwElementAlreadyExist();
            throw new KotlinNothingValueException();
        }
        User user2 = this.cloneUser(user);
        this.users.add(user2);
        this.saveUpdateToFile();
        return user2;
    }

    @NotNull
    public final User handleUserUpdate(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.doesUserExist(user.getUsername())) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        User user2 = this.cloneUser(user);
        this.users.removeIf(arg_0 -> AuthService.handleUserUpdate$lambda-0(user2, arg_0));
        this.users.add(user2);
        this.saveUpdateToFile();
        return user2;
    }

    public final void handleUserDelete(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.doesUserExist(user.getUsername())) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        this.users.removeIf(arg_0 -> AuthService.handleUserDelete$lambda-1(user, arg_0));
        this.saveUpdateToFile();
    }

    @Nullable
    public final User handleUserGet(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return this.getUserByName(username);
    }

    @Nullable
    public final User getUserByName(@NotNull String userName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
            Iterable $this$firstOrNull$iv = this.users;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                User it = (User)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUsername(), (Object)userName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean doesUserExist(@NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        return this.getUserByName(userName) != null;
    }

    @NotNull
    public final List<User> getUsers() {
        return this.users;
    }

    private final User cloneUser(User user) {
        return new User(user.getUsername(), user.getPassword());
    }

    private final void saveUpdateToFile() {
        JsonLib.Companion.fromObject(this.users).saveAsFile(this.usersFile);
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IExceptionHelper.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IExceptionHelper.DefaultImpls.throwNoSuchElement(this);
    }

    private static final boolean handleUserUpdate$lambda-0(User $user, User it) {
        Intrinsics.checkNotNullParameter((Object)$user, (String)"$user");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getUsername(), (Object)$user.getUsername());
    }

    private static final boolean handleUserDelete$lambda-1(User $user, User it) {
        Intrinsics.checkNotNullParameter((Object)$user, (String)"$user");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getUsername(), (Object)$user.getUsername());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Leu/thesimplecloud/module/rest/auth/AuthService$UserAlreadyExistException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "simplecloud-module-rest"})
    public static final class UserAlreadyExistException
    extends Exception {
        public UserAlreadyExistException() {
            super("The user does already exist");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Leu/thesimplecloud/module/rest/auth/AuthService$UserNotExistException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "simplecloud-module-rest"})
    public static final class UserNotExistException
    extends Exception {
        public UserNotExistException() {
            super("The user does not exist");
        }
    }
}

