/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.auth.user.permission;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0002J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Leu/thesimplecloud/module/rest/auth/user/permission/Permission;", "", "permissionString", "", "active", "", "(Ljava/lang/String;Z)V", "getActive", "()Z", "getPermissionString", "()Ljava/lang/String;", "areAllPermissionComponentsEqual", "checkPermissionComponents", "", "thisPermissionComponents", "component1", "component2", "copy", "equals", "other", "hashCode", "", "isPermissionToCheckEqualToThisPermission", "permission", "matches", "matchesPermission", "matchesWithStarAtTheEnd", "toString", "simplecloud-module-rest"})
public final class Permission {
    @NotNull
    private final String permissionString;
    private final boolean active;

    public Permission(@NotNull String permissionString, boolean active) {
        Intrinsics.checkNotNullParameter((Object)permissionString, (String)"permissionString");
        this.permissionString = permissionString;
        this.active = active;
    }

    @NotNull
    public final String getPermissionString() {
        return this.permissionString;
    }

    public final boolean getActive() {
        return this.active;
    }

    public final boolean matches(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return this.matchesPermission(permission);
    }

    private final boolean matchesPermission(String permission) {
        boolean endsWithStar = StringsKt.endsWith$default((String)this.permissionString, (String)".*", (boolean)false, (int)2, null);
        return endsWithStar ? this.matchesWithStarAtTheEnd(permission) : this.isPermissionToCheckEqualToThisPermission(permission);
    }

    private final boolean isPermissionToCheckEqualToThisPermission(String permission) {
        return Intrinsics.areEqual((Object)permission, (Object)this.permissionString);
    }

    private final boolean matchesWithStarAtTheEnd(String permission) {
        String[] stringArray = new String[]{"."};
        List checkPermissionComponents = StringsKt.split$default((CharSequence)permission, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"."};
        List thisPermissionComponents = StringsKt.split$default((CharSequence)this.permissionString, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        boolean isPermissionToCheckLongEnough = checkPermissionComponents.size() >= thisPermissionComponents.size();
        return isPermissionToCheckLongEnough ? this.areAllPermissionComponentsEqual(checkPermissionComponents, thisPermissionComponents) : false;
    }

    private final boolean areAllPermissionComponentsEqual(List<String> checkPermissionComponents, List<String> thisPermissionComponents) {
        List thisPermissionComponentsWithoutStar = CollectionsKt.dropLast(thisPermissionComponents, (int)1);
        List checkComponentsWithLimit = CollectionsKt.take((Iterable)checkPermissionComponents, (int)thisPermissionComponentsWithoutStar.size());
        return Intrinsics.areEqual((Object)checkComponentsWithLimit, (Object)thisPermissionComponentsWithoutStar);
    }

    @NotNull
    public final String component1() {
        return this.permissionString;
    }

    public final boolean component2() {
        return this.active;
    }

    @NotNull
    public final Permission copy(@NotNull String permissionString, boolean active) {
        Intrinsics.checkNotNullParameter((Object)permissionString, (String)"permissionString");
        return new Permission(permissionString, active);
    }

    public static /* synthetic */ Permission copy$default(Permission permission, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = permission.permissionString;
        }
        if ((n & 2) != 0) {
            bl = permission.active;
        }
        return permission.copy(string, bl);
    }

    @NotNull
    public String toString() {
        return "Permission(permissionString=" + this.permissionString + ", active=" + this.active + ')';
    }

    public int hashCode() {
        int result = this.permissionString.hashCode();
        int n = this.active ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Permission)) {
            return false;
        }
        Permission permission = (Permission)other;
        if (!Intrinsics.areEqual((Object)this.permissionString, (Object)permission.permissionString)) {
            return false;
        }
        return this.active == permission.active;
    }
}

