/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.defaultcontroller;

import eu.thesimplecloud.module.rest.annotation.RequestBody;
import eu.thesimplecloud.module.rest.annotation.RequestMapping;
import eu.thesimplecloud.module.rest.annotation.RequestPathParam;
import eu.thesimplecloud.module.rest.annotation.RequestType;
import eu.thesimplecloud.module.rest.annotation.RequestingUser;
import eu.thesimplecloud.module.rest.annotation.RestController;
import eu.thesimplecloud.module.rest.auth.AuthService;
import eu.thesimplecloud.module.rest.auth.user.User;
import eu.thesimplecloud.module.rest.controller.IController;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@RestController(path="user/")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007J\u0012\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007J\u0012\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007J\u0012\u0010\u000f\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/UserController;", "Leu/thesimplecloud/module/rest/controller/IController;", "authService", "Leu/thesimplecloud/module/rest/auth/AuthService;", "(Leu/thesimplecloud/module/rest/auth/AuthService;)V", "handleCreateUser", "Leu/thesimplecloud/module/rest/auth/user/User;", "user", "handleDeleteUser", "handleGetAllUsers", "", "handleGetOneUsers", "username", "", "handleGetSelfUser", "handleUpdateUser", "simplecloud-module-rest"})
public final class UserController
implements IController {
    @NotNull
    private final AuthService authService;

    public UserController(@NotNull AuthService authService) {
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        this.authService = authService;
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="", permission="web.user.get.all")
    @NotNull
    public final List<User> handleGetAllUsers() {
        return this.authService.getUsers();
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="self/", permission="web.user.get.self")
    @NotNull
    public final User handleGetSelfUser(@RequestingUser @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return user;
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="name/:name", permission="web.user.get.one")
    @NotNull
    public final User handleGetOneUsers(@RequestPathParam(parameterName="name") @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        User user = this.authService.handleUserGet(username);
        if (user == null) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        return user;
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="", permission="web.user.create")
    @NotNull
    public final User handleCreateUser(@RequestBody @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.authService.handleAddUser(user);
    }

    @RequestMapping(requestType=RequestType.PUT, additionalPath="", permission="web.user.update")
    @NotNull
    public final User handleUpdateUser(@RequestBody @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.authService.handleUserUpdate(user);
    }

    @RequestMapping(requestType=RequestType.DELETE, additionalPath="", permission="web.user.delete")
    @NotNull
    public final User handleDeleteUser(@RequestBody @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.authService.handleUserDelete(user);
        return user;
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IController.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IController.DefaultImpls.throwNoSuchElement(this);
    }
}

