/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.defaultcontroller.filemanager;

import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.module.rest.annotation.RequestMapping;
import eu.thesimplecloud.module.rest.annotation.RequestType;
import eu.thesimplecloud.module.rest.annotation.RestController;
import eu.thesimplecloud.module.rest.controller.IController;
import io.javalin.core.util.FileUtil;
import io.javalin.http.Context;
import io.javalin.http.UploadedFile;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@RestController(path="filemanager/")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/filemanager/FileManagerController;", "Leu/thesimplecloud/module/rest/controller/IController;", "()V", "checkForSuspiciousPath", "", "ctx", "Lio/javalin/http/Context;", "getFileFromRequest", "Ljava/io/File;", "handleCreate", "", "handleDelete", "handleRead", "", "Leu/thesimplecloud/module/rest/defaultcontroller/filemanager/FileManagerController$FileInfo;", "FileAlreadyExistsException", "FileInfo", "InvalidPathException", "simplecloud-module-rest"})
public final class FileManagerController
implements IController {
    /*
     * WARNING - void declaration
     */
    @RequestMapping(requestType=RequestType.GET, additionalPath="*", permission="web.filemanager.read")
    @NotNull
    public final Collection<FileInfo> handleRead(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.checkForSuspiciousPath(ctx);
        File file = this.getFileFromRequest(ctx);
        if (!file.exists()) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        if (file.isDirectory()) {
            void $this$mapTo$iv$iv;
            void $this$sortedBy$iv;
            void $this$filterTo$iv$iv222;
            void $this$sortedBy$iv2;
            void $this$filterTo$iv$iv3;
            File[] fileArray = file.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"file.listFiles()");
            List listFiles = ArraysKt.toList((Object[])fileArray);
            Iterable $this$filter$iv = listFiles;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!it.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            boolean $this$filterTo$iv$iv3 = false;
            List directories = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    File it = (File)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            Iterable $this$filter$iv2 = listFiles;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv222) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!(!it.isDirectory())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$sortedBy2 = false;
            boolean $this$filterTo$iv$iv222 = false;
            List files = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    File it = (File)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            Iterable $this$map$iv = CollectionsKt.union((Iterable)directories, (Iterable)files);
            boolean $i$f$map = false;
            Iterable $this$filterTo$iv$iv222 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File it = (File)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                FileInfo fileInfo = new FileInfo(string, it.isDirectory(), it.length());
                collection.add(fileInfo);
            }
            return (List)destination$iv$iv2;
        }
        if (Context.queryParam$default((Context)ctx, (String)"view", null, (int)2, null) == null) {
            ctx.res.setHeader("Content-Disposition", Intrinsics.stringPlus((String)"attachment; filename=", (Object)file.getName()));
        }
        ctx.result(FilesKt.readBytes((File)file));
        return CollectionsKt.emptyList();
    }

    @RequestMapping(requestType=RequestType.DELETE, additionalPath="*", permission="web.filemanager.delete")
    public final boolean handleDelete(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.checkForSuspiciousPath(ctx);
        File file = this.getFileFromRequest(ctx);
        if (!file.exists()) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        if (!file.isDirectory()) {
            file.delete();
        }
        return true;
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="*", permission="web.filemanager.create")
    public final boolean handleCreate(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.checkForSuspiciousPath(ctx);
        File file = this.getFileFromRequest(ctx);
        Object object = file.getAbsolutePath();
        boolean bl = false;
        System.out.println(object);
        if (file.exists() && file.isDirectory()) {
            return false;
        }
        if (file.exists()) {
            file.delete();
        }
        if ((object = file.getParentFile()) != null) {
            ((File)object).mkdirs();
        }
        UploadedFile uploadedFile = ctx.uploadedFile("file");
        if (uploadedFile != null) {
            InputStream inputStream = uploadedFile.getContent();
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            FileUtil.streamToFile((InputStream)inputStream, (String)string);
        } else {
            Launcher.Companion.getInstance().getLogger().info(ctx.body());
            CharSequence charSequence = ctx.body();
            boolean bl2 = false;
            if (charSequence.length() > 0) {
                FilesKt.writeText$default((File)file, (String)ctx.body(), null, (int)2, null);
            }
        }
        return true;
    }

    private final File getFileFromRequest(Context ctx) {
        String string = ctx.req.getPathInfo();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.req.pathInfo");
        String filepath = StringsKt.replace$default((String)string, (String)"/filemanager/", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.isBlank((CharSequence)filepath)) {
            return new File(".");
        }
        return new File(filepath);
    }

    private final void checkForSuspiciousPath(Context ctx) {
        block3: {
            block2: {
                String string = ctx.req.getPathInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.req.pathInfo");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"..", (boolean)false, (int)2, null)) break block2;
                string = ctx.req.getPathInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.req.pathInfo");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"//", (boolean)false, (int)2, null)) break block3;
            }
            throw new InvalidPathException("Invalid file path");
        }
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IController.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IController.DefaultImpls.throwNoSuchElement(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/filemanager/FileManagerController$FileAlreadyExistsException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "simplecloud-module-rest"})
    public static final class FileAlreadyExistsException
    extends Exception {
        public FileAlreadyExistsException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/filemanager/FileManagerController$InvalidPathException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "simplecloud-module-rest"})
    public static final class InvalidPathException
    extends Exception {
        public InvalidPathException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/filemanager/FileManagerController$FileInfo;", "", "name", "", "isDirectory", "", "size", "", "(Ljava/lang/String;ZJ)V", "()Z", "getName", "()Ljava/lang/String;", "getSize", "()J", "simplecloud-module-rest"})
    public static final class FileInfo {
        @NotNull
        private final String name;
        private final boolean isDirectory;
        private final long size;

        public FileInfo(@NotNull String name, boolean isDirectory, long size) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.isDirectory = isDirectory;
            this.size = size;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isDirectory() {
            return this.isDirectory;
        }

        public final long getSize() {
            return this.size;
        }
    }
}

