/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.defaultcontroller.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.impl.DefaultCloudService;
import eu.thesimplecloud.launcher.screens.IScreen;
import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.module.rest.annotation.RequestBody;
import eu.thesimplecloud.module.rest.annotation.RequestMapping;
import eu.thesimplecloud.module.rest.annotation.RequestPathParam;
import eu.thesimplecloud.module.rest.annotation.RequestType;
import eu.thesimplecloud.module.rest.annotation.RestController;
import eu.thesimplecloud.module.rest.controller.IController;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@RestController(path="cloud/service/")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u0012\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/service/ServiceController;", "Leu/thesimplecloud/module/rest/controller/IController;", "()V", "doesServiceExist", "", "name", "", "handleGetAllServices", "", "Leu/thesimplecloud/api/service/ICloudService;", "handleGetOneService", "handleGetServiceLogs", "handleUpdateService", "service", "Leu/thesimplecloud/api/service/impl/DefaultCloudService;", "simplecloud-module-rest"})
public final class ServiceController
implements IController {
    @RequestMapping(requestType=RequestType.GET, additionalPath="", permission="web.cloud.service.get.all")
    @NotNull
    public final List<ICloudService> handleGetAllServices() {
        return CloudAPI.Companion.getInstance().getCloudServiceManager().getAllCachedObjects();
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="name/:name", permission="web.cloud.service.get.one")
    @NotNull
    public final ICloudService handleGetOneService(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudService iCloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(name);
        if (iCloudService == null) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        return iCloudService;
    }

    @RequestMapping(requestType=RequestType.PUT, additionalPath="", permission="web.cloud.service.update")
    @NotNull
    public final ICloudService handleUpdateService(@RequestBody @NotNull DefaultCloudService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        if (!this.doesServiceExist(service.getName())) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getCloudServiceManager()), (ICacheValue)((ICacheValue)service), (boolean)false, (boolean)false, (int)6, null);
        return (ICloudService)service;
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="logs/:name", permission="web.cloud.service.logs")
    @NotNull
    public final List<String> handleGetServiceLogs(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.doesServiceExist(name)) {
            this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        IScreen screen = Launcher.Companion.getInstance().getScreenManager().getScreen(name);
        IScreen iScreen = screen;
        List list = iScreen == null ? null : iScreen.getAllSavedMessages();
        return list == null ? CollectionsKt.emptyList() : list;
    }

    private final boolean doesServiceExist(String name) {
        return CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(name) != null;
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IController.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IController.DefaultImpls.throwNoSuchElement(this);
    }
}

