/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.javalin;

import com.auth0.jwt.interfaces.DecodedJWT;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.rest.auth.AuthService;
import eu.thesimplecloud.module.rest.auth.JwtProvider;
import eu.thesimplecloud.module.rest.auth.user.User;
import eu.thesimplecloud.module.rest.auth.user.permission.entity.PermissionEntity;
import eu.thesimplecloud.module.rest.controller.RequestMethodData;
import eu.thesimplecloud.module.rest.defaultcontroller.dto.ErrorDto;
import eu.thesimplecloud.module.rest.javalin.SingleRequestProcessor;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javalinjwt.JWTProvider;
import javalinjwt.JavalinJWT;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Leu/thesimplecloud/module/rest/javalin/JavalinRequestHandler;", "Lio/javalin/http/Handler;", "requestMethodData", "Leu/thesimplecloud/module/rest/controller/RequestMethodData;", "authService", "Leu/thesimplecloud/module/rest/auth/AuthService;", "(Leu/thesimplecloud/module/rest/controller/RequestMethodData;Leu/thesimplecloud/module/rest/auth/AuthService;)V", "getRequestMethodData", "()Leu/thesimplecloud/module/rest/controller/RequestMethodData;", "getUserByContext", "Leu/thesimplecloud/module/rest/auth/user/User;", "context", "Lio/javalin/http/Context;", "handle", "", "ctx", "isPermitted", "", "user", "simplecloud-module-rest"})
public final class JavalinRequestHandler
implements Handler {
    @NotNull
    private final RequestMethodData requestMethodData;
    @NotNull
    private final AuthService authService;

    public JavalinRequestHandler(@NotNull RequestMethodData requestMethodData, @NotNull AuthService authService) {
        Intrinsics.checkNotNullParameter((Object)requestMethodData, (String)"requestMethodData");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        this.requestMethodData = requestMethodData;
        this.authService = authService;
    }

    @NotNull
    public final RequestMethodData getRequestMethodData() {
        return this.requestMethodData;
    }

    public void handle(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        User user = this.getUserByContext(ctx);
        if (!this.isPermitted(user)) {
            ctx.result("Unauthorized");
            ctx.status(401);
            return;
        }
        try {
            new SingleRequestProcessor(ctx, this.requestMethodData, user).processRequest();
        }
        catch (Exception ex) {
            Throwable throwable;
            if (ex instanceof InvocationTargetException) {
                Throwable throwable2 = ex.getCause();
                throwable = throwable2;
                Intrinsics.checkNotNull((Object)throwable2);
            } else {
                throwable = ex;
            }
            Throwable exception = throwable;
            ctx.status(500);
            JsonLib json = JsonLib.Companion.fromObject((Object)ErrorDto.Companion.fromException(exception));
            ctx.result(json.getAsJsonString());
            ex.printStackTrace();
        }
    }

    private final boolean isPermitted(User user) {
        boolean bl;
        Boolean bl2;
        Object object = user;
        Boolean bl3 = bl2 = object == null ? null : Boolean.valueOf(((PermissionEntity)object).hasPermission(this.requestMethodData.getPermission()));
        if (bl2 == null) {
            object = this.requestMethodData.getPermission();
            boolean bl4 = false;
            bl = object.length() == 0;
        } else {
            bl = bl2;
        }
        return bl;
    }

    private final User getUserByContext(Context context) {
        Optional optional = JavalinJWT.getTokenFromHeader((Context)context).flatMap(arg_0 -> ((JWTProvider)JwtProvider.Companion.getInstance().getProvider()).validateToken(arg_0));
        if (optional == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.Optional<com.auth0.jwt.interfaces.DecodedJWT>");
        }
        Optional decodedJWTOptional = optional;
        if (!decodedJWTOptional.isPresent()) {
            return null;
        }
        Object u = decodedJWTOptional.get();
        Intrinsics.checkNotNullExpressionValue(u, (String)"decodedJWTOptional.get()");
        DecodedJWT decodedJWT = (DecodedJWT)u;
        String username = decodedJWT.getClaim("username").asString();
        Intrinsics.checkNotNullExpressionValue((Object)username, (String)"username");
        return this.authService.getUserByName(username);
    }
}

