/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.javalin;

import com.google.gson.Gson;
import eu.thesimplecloud.clientserverapi.lib.json.PacketExclude;
import eu.thesimplecloud.jsonlib.GsonCreator;
import eu.thesimplecloud.module.rest.annotation.WebExclude;
import eu.thesimplecloud.module.rest.auth.AuthService;
import eu.thesimplecloud.module.rest.auth.JwtProvider;
import eu.thesimplecloud.module.rest.auth.Roles;
import eu.thesimplecloud.module.rest.auth.RolesKt;
import eu.thesimplecloud.module.rest.auth.controller.AuthController;
import eu.thesimplecloud.module.rest.controller.ControllerHandler;
import eu.thesimplecloud.module.rest.controller.RequestMethodData;
import eu.thesimplecloud.module.rest.defaultcontroller.UserController;
import eu.thesimplecloud.module.rest.defaultcontroller.filemanager.FileManagerController;
import eu.thesimplecloud.module.rest.defaultcontroller.group.ServiceGroupActionController;
import eu.thesimplecloud.module.rest.defaultcontroller.group.ServiceGroupController;
import eu.thesimplecloud.module.rest.defaultcontroller.player.PlayerController;
import eu.thesimplecloud.module.rest.defaultcontroller.service.ServiceActionController;
import eu.thesimplecloud.module.rest.defaultcontroller.service.ServiceController;
import eu.thesimplecloud.module.rest.defaultcontroller.template.TemplateController;
import eu.thesimplecloud.module.rest.defaultcontroller.uptime.UptimeController;
import eu.thesimplecloud.module.rest.defaultcontroller.version.VersionController;
import eu.thesimplecloud.module.rest.defaultcontroller.wrapper.WrapperController;
import eu.thesimplecloud.module.rest.javalin.JavalinRequestHandler;
import io.javalin.Javalin;
import io.javalin.core.security.AccessManager;
import io.javalin.core.security.Role;
import io.javalin.core.security.SecurityUtil;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.HandlerType;
import java.util.Map;
import javalinjwt.JWTAccessManager;
import javalinjwt.JWTProvider;
import javalinjwt.JavalinJWT;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0013R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Leu/thesimplecloud/module/rest/javalin/RestServer;", "", "port", "", "(I)V", "app", "Lio/javalin/Javalin;", "kotlin.jvm.PlatformType", "authService", "Leu/thesimplecloud/module/rest/auth/AuthService;", "controllerHandler", "Leu/thesimplecloud/module/rest/controller/ControllerHandler;", "getControllerHandler", "()Leu/thesimplecloud/module/rest/controller/ControllerHandler;", "webGson", "Lcom/google/gson/Gson;", "getWebGson", "()Lcom/google/gson/Gson;", "addToJavalin", "", "requestHandler", "Leu/thesimplecloud/module/rest/javalin/JavalinRequestHandler;", "registerRequestMethod", "requestMethodData", "Leu/thesimplecloud/module/rest/controller/RequestMethodData;", "shutdown", "Companion", "simplecloud-module-rest"})
public final class RestServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthService authService = new AuthService();
    @NotNull
    private final ControllerHandler controllerHandler = new ControllerHandler(this);
    private final Javalin app;
    @NotNull
    private final Gson webGson;
    public static RestServer instance;

    public RestServer(int port) {
        this.app = Javalin.create().start(port);
        Class[] classArray = new Class[]{WebExclude.class, PacketExclude.class};
        this.webGson = new GsonCreator().excludeAnnotations(classArray).create();
        Companion.setInstance(this);
        this.app.config.accessManager((AccessManager)new JWTAccessManager("role", (Map)RolesKt.createRolesMapping(), (Role)Roles.ANYONE));
        this.app.before(JavalinJWT.createHeaderDecodeHandler((JWTProvider)JwtProvider.Companion.getInstance().getProvider()));
        this.app.before(RestServer::_init_$lambda-0);
        classArray = new Role[]{Roles.ANYONE};
        this.app.options("/*", RestServer::_init_$lambda-1, SecurityUtil.roles((Role[])classArray));
        this.controllerHandler.registerController(new AuthController(this.authService));
        this.controllerHandler.registerController(new UserController(this.authService));
        this.controllerHandler.registerController(new ServiceGroupController());
        this.controllerHandler.registerController(new ServiceGroupActionController());
        this.controllerHandler.registerController(new ServiceController());
        this.controllerHandler.registerController(new ServiceActionController());
        this.controllerHandler.registerController(new TemplateController());
        this.controllerHandler.registerController(new WrapperController());
        this.controllerHandler.registerController(new PlayerController());
        this.controllerHandler.registerController(new VersionController());
        this.controllerHandler.registerController(new FileManagerController());
        this.controllerHandler.registerController(new UptimeController());
    }

    @NotNull
    public final ControllerHandler getControllerHandler() {
        return this.controllerHandler;
    }

    @NotNull
    public final Gson getWebGson() {
        return this.webGson;
    }

    public final void registerRequestMethod(@NotNull RequestMethodData requestMethodData) {
        Intrinsics.checkNotNullParameter((Object)requestMethodData, (String)"requestMethodData");
        JavalinRequestHandler requestHandler = new JavalinRequestHandler(requestMethodData, this.authService);
        this.addToJavalin(requestHandler);
    }

    private final void addToJavalin(JavalinRequestHandler requestHandler) {
        RequestMethodData requestMethodData = requestHandler.getRequestMethodData();
        this.app.addHandler(HandlerType.valueOf((String)requestMethodData.getRequestType().name()), requestMethodData.getPath(), (Handler)requestHandler, SetsKt.setOf((Object)((Object)Roles.ANYONE)));
    }

    public final void shutdown() {
        this.app.stop();
    }

    private static final void _init_$lambda-0(Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.header("Access-Control-Allow-Headers", "*");
        ctx.header("Access-Control-Allow-Origin", "*");
        ctx.header("Access-Control-Allow-Methods", "GET, PUT, POST, DELETE, OPTIONS");
        ctx.header("Content-Type", "application/json; charset=utf-8");
    }

    private static final void _init_$lambda-1(Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.status(200);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/module/rest/javalin/RestServer$Companion;", "", "()V", "instance", "Leu/thesimplecloud/module/rest/javalin/RestServer;", "getInstance", "()Leu/thesimplecloud/module/rest/javalin/RestServer;", "setInstance", "(Leu/thesimplecloud/module/rest/javalin/RestServer;)V", "simplecloud-module-rest"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RestServer getInstance() {
            RestServer restServer = instance;
            if (restServer != null) {
                return restServer;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public final void setInstance(@NotNull RestServer restServer) {
            Intrinsics.checkNotNullParameter((Object)restServer, (String)"<set-?>");
            instance = restServer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

