/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.javalin;

import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.rest.annotation.RequestBody;
import eu.thesimplecloud.module.rest.annotation.RequestParam;
import eu.thesimplecloud.module.rest.annotation.RequestPathParam;
import eu.thesimplecloud.module.rest.annotation.RequestingUser;
import eu.thesimplecloud.module.rest.auth.user.User;
import eu.thesimplecloud.module.rest.controller.RequestMethodData;
import eu.thesimplecloud.module.rest.defaultcontroller.dto.ErrorDto;
import eu.thesimplecloud.module.rest.defaultcontroller.dto.ResultDto;
import eu.thesimplecloud.module.rest.exception.NullResultException;
import eu.thesimplecloud.module.rest.javalin.RestServer;
import io.javalin.http.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0002J\u0006\u0010\u0015\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Leu/thesimplecloud/module/rest/javalin/SingleRequestProcessor;", "", "ctx", "Lio/javalin/http/Context;", "requestMethodData", "Leu/thesimplecloud/module/rest/controller/RequestMethodData;", "requestingUser", "Leu/thesimplecloud/module/rest/auth/user/User;", "(Lio/javalin/http/Context;Leu/thesimplecloud/module/rest/controller/RequestMethodData;Leu/thesimplecloud/module/rest/auth/user/User;)V", "handleClientFaultException", "", "ex", "", "handleParameters", "", "Leu/thesimplecloud/module/rest/controller/RequestMethodData$RequestParameterData;", "handleValueForParameter", "parameterData", "isValueIncorrect", "", "value", "processRequest", "IncorrectValueException", "simplecloud-module-rest"})
public final class SingleRequestProcessor {
    @NotNull
    private final Context ctx;
    @NotNull
    private final RequestMethodData requestMethodData;
    @Nullable
    private final User requestingUser;

    public SingleRequestProcessor(@NotNull Context ctx, @NotNull RequestMethodData requestMethodData, @Nullable User requestingUser) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)requestMethodData, (String)"requestMethodData");
        this.ctx = ctx;
        this.requestMethodData = requestMethodData;
        this.requestingUser = requestingUser;
    }

    public final void processRequest() {
        Object $i$f$toTypedArray2;
        Map<RequestMethodData.RequestParameterData, Object> map;
        try {
            map = this.handleParameters();
        }
        catch (Exception e) {
            this.handleClientFaultException(e);
            return;
        }
        Map<RequestMethodData.RequestParameterData, Object> parameterDataToInvokeValue = map;
        Collection<Object> $this$toTypedArray$iv = parameterDataToInvokeValue.values();
        boolean $i$f$toTypedArray2 = false;
        Collection<Object> thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] valueArray = objectArray;
        try {
            $i$f$toTypedArray2 = this.requestMethodData.getMethod().invoke((Object)this.requestMethodData.getController(), Arrays.copyOf(valueArray, valueArray.length));
        }
        catch (Exception e) {
            Throwable throwable;
            if (e instanceof InvocationTargetException) {
                Throwable throwable2 = e.getCause();
                throwable = throwable2;
                Intrinsics.checkNotNull((Object)throwable2);
            } else {
                throwable = e;
            }
            Throwable ex = throwable;
            this.handleClientFaultException(ex);
            return;
        }
        Object result = $i$f$toTypedArray2;
        if (this.ctx.resultString() != null) {
            return;
        }
        if (result == null) {
            throw new NullResultException();
        }
        if (Intrinsics.areEqual((Object)result, (Object)Unit.INSTANCE)) {
            return;
        }
        this.ctx.status(200);
        ResultDto resultDto = new ResultDto(result);
        this.ctx.result(JsonLib.Companion.fromObject((Object)resultDto, RestServer.Companion.getInstance().getWebGson()).getAsJsonString());
    }

    private final void handleClientFaultException(Throwable ex) {
        this.ctx.status(400);
        this.ctx.result(JsonLib.Companion.fromObject((Object)ErrorDto.Companion.fromException(ex)).getAsJsonString());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<RequestMethodData.RequestParameterData, Object> handleParameters() {
        boolean bl;
        Map parameterDataToInvokeValue;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.requestMethodData.getParameters();
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RequestMethodData.RequestParameterData requestParameterData = (RequestMethodData.RequestParameterData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it, (Object)this.handleValueForParameter((RequestMethodData.RequestParameterData)it));
                collection.add(pair);
            }
            Map $this$any$iv = parameterDataToInvokeValue = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv;
                boolean bl3 = false;
                Iterator iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl4 = false;
                    if (!this.isValueIncorrect((RequestMethodData.RequestParameterData)it.getKey(), it.getValue())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IncorrectValueException("A value is incorrect");
        }
        return parameterDataToInvokeValue;
    }

    private final boolean isValueIncorrect(RequestMethodData.RequestParameterData parameterData, Object value) {
        Annotation annotation = parameterData.getAnnotation();
        if (annotation instanceof RequestParam) {
            return ((RequestParam)annotation).required() && value == null;
        }
        if (annotation instanceof RequestPathParam) {
            return value == null;
        }
        return false;
    }

    private final Object handleValueForParameter(RequestMethodData.RequestParameterData parameterData) {
        Annotation annotation;
        if (Intrinsics.areEqual(parameterData.getParameterType(), Context.class)) {
            return this.ctx;
        }
        if (Intrinsics.areEqual(parameterData.getParameterType(), User.class) && parameterData.getAnnotation() instanceof RequestingUser) {
            return this.requestingUser;
        }
        Annotation annotation2 = parameterData.getAnnotation();
        Intrinsics.checkNotNull((Object)annotation2);
        Annotation annotation3 = annotation = annotation2;
        if (annotation3 instanceof RequestBody) {
            return JsonLib.Companion.fromJsonString(this.ctx.body(), RestServer.Companion.getInstance().getWebGson()).getObject(parameterData.getParameterType());
        }
        if (annotation3 instanceof RequestParam) {
            String string = this.ctx.req.getParameter(((RequestParam)annotation).parameterName());
            if (string == null) {
                return null;
            }
            String parameter = string;
            return JsonLib.Companion.fromJsonString$default((JsonLib.Companion)JsonLib.Companion, (String)parameter, null, (int)2, null).getObject(parameterData.getParameterType());
        }
        if (annotation3 instanceof RequestPathParam) {
            String pathParam = this.ctx.pathParam(((RequestPathParam)annotation).parameterName());
            return JsonLib.Companion.fromJsonString$default((JsonLib.Companion)JsonLib.Companion, (String)pathParam, null, (int)2, null).getObject(parameterData.getParameterType());
        }
        throw new IllegalStateException();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Leu/thesimplecloud/module/rest/javalin/SingleRequestProcessor$IncorrectValueException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "simplecloud-module-rest"})
    public static final class IncorrectValueException
    extends Exception {
        public IncorrectValueException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

