/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.serviceselection.api;

import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.module.serviceselection.api.AbstractServiceViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000e\"\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011J\u000f\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u000f\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0013\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0006\u0010 \u001a\u00020\fJ\u0006\u0010!\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Leu/thesimplecloud/module/serviceselection/api/ServiceViewGroupManager;", "T", "Leu/thesimplecloud/module/serviceselection/api/AbstractServiceViewer;", "", "group", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "(Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;)V", "getGroup", "()Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "serviceViewers", "", "addServiceViewers", "", "serviceViewer", "", "([Leu/thesimplecloud/module/serviceselection/api/AbstractServiceViewer;)V", "getAllServicesToDisplay", "", "Leu/thesimplecloud/api/service/ICloudService;", "getAllServicesWaitingForViewer", "getNewViewerForService", "service", "(Leu/thesimplecloud/api/service/ICloudService;)Leu/thesimplecloud/module/serviceselection/api/AbstractServiceViewer;", "getServiceViewers", "getVacantOrStartingViewer", "()Leu/thesimplecloud/module/serviceselection/api/AbstractServiceViewer;", "getVacantViewer", "hasViewer", "", "removeServiceViewer", "(Leu/thesimplecloud/module/serviceselection/api/AbstractServiceViewer;)V", "searchViewerForService", "sortWaitingServicesToViewers", "updateAllViewers", "simplecloud-module-serviceselection"})
public final class ServiceViewGroupManager<T extends AbstractServiceViewer> {
    @NotNull
    private final ICloudServiceGroup group;
    @NotNull
    private final List<T> serviceViewers;

    public ServiceViewGroupManager(@NotNull ICloudServiceGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.group = group;
        this.serviceViewers = new ArrayList();
    }

    @NotNull
    public final ICloudServiceGroup getGroup() {
        return this.group;
    }

    public final void addServiceViewers(T ... serviceViewer) {
        Intrinsics.checkNotNullParameter(serviceViewer, (String)"serviceViewer");
        CollectionsKt.addAll((Collection)this.serviceViewers, (Object[])serviceViewer);
    }

    public final void removeServiceViewer(@NotNull T serviceViewer) {
        Intrinsics.checkNotNullParameter(serviceViewer, (String)"serviceViewer");
        this.serviceViewers.remove(serviceViewer);
        ((AbstractServiceViewer)serviceViewer).removeView();
    }

    /*
     * WARNING - void declaration
     */
    public final void sortWaitingServicesToViewers() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        List<ICloudService> allServicesWaiting = this.getAllServicesWaitingForViewer();
        Iterable $this$filter$iv = allServicesWaiting;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ICloudService it = (ICloudService)element$iv$iv;
            boolean bl = false;
            if (!(it.getState() == ServiceState.VISIBLE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allVisibleServices = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = allServicesWaiting;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudService it = (ICloudService)element$iv$iv;
            boolean bl = false;
            if (!(it.getState() == ServiceState.STARTING)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List allStartingServices = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = allVisibleServices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudService it = (ICloudService)element$iv;
            boolean bl = false;
            this.searchViewerForService(it);
        }
        $this$forEach$iv = allStartingServices;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudService it = (ICloudService)element$iv;
            boolean bl = false;
            this.searchViewerForService(it);
        }
    }

    public final void updateAllViewers() {
        Iterable $this$forEach$iv = this.serviceViewers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractServiceViewer it = (AbstractServiceViewer)element$iv;
            boolean bl = false;
            it.updateView();
        }
    }

    @NotNull
    public final List<T> getServiceViewers() {
        return this.serviceViewers;
    }

    private final void searchViewerForService(ICloudService service) {
        boolean bl = !this.hasViewer(service);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Service does already has a viewer";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        T newViewer = this.getNewViewerForService(service);
        T t = newViewer;
        if (t != null) {
            ((AbstractServiceViewer)t).setService(service);
        }
    }

    private final T getNewViewerForService(ICloudService service) {
        boolean bl = !this.hasViewer(service);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Service does already has a viewer";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return service.getState() == ServiceState.VISIBLE ? this.getVacantOrStartingViewer() : this.getVacantViewer();
    }

    private final T getVacantOrStartingViewer() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.serviceViewers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AbstractServiceViewer it = (AbstractServiceViewer)element$iv;
                boolean bl = false;
                if (!(it.isVacant() || it.isCurrentServiceStarting())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((AbstractServiceViewer)v0);
    }

    private final T getVacantViewer() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.serviceViewers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AbstractServiceViewer it = (AbstractServiceViewer)element$iv;
                boolean bl = false;
                if (!it.isVacant()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((AbstractServiceViewer)v0);
    }

    private final boolean hasViewer(ICloudService service) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.serviceViewers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractServiceViewer it = (AbstractServiceViewer)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getService(), (Object)service)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ICloudService> getAllServicesWaitingForViewer() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllServicesToDisplay();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudService it = (ICloudService)element$iv$iv;
            boolean bl = false;
            if (!(!this.hasViewer(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ICloudService> getAllServicesToDisplay() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.group.getAllServices();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudService it = (ICloudService)element$iv$iv;
            boolean bl = false;
            if (!it.isStartingOrVisible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

