/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.manager;

import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.sign.lib.SignModuleConfig;
import eu.thesimplecloud.module.sign.lib.group.GroupLayoutsContainer;
import eu.thesimplecloud.module.sign.lib.layout.LayoutType;
import eu.thesimplecloud.module.sign.lib.layout.SignFrame;
import eu.thesimplecloud.module.sign.lib.layout.SignLayout;
import eu.thesimplecloud.module.sign.lib.layout.SignLayoutContainer;
import eu.thesimplecloud.module.sign.lib.sign.CloudSignContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Leu/thesimplecloud/module/sign/manager/SignModuleConfigPersistence;", "", "()V", "groupLayoutsFile", "Ljava/io/File;", "layoutsDir", "signsFile", "createDefaultConfig", "Leu/thesimplecloud/module/sign/lib/SignModuleConfig;", "getDefaultLayoutList", "", "Leu/thesimplecloud/module/sign/lib/layout/SignLayout;", "getLayoutsDirectoryByLayoutType", "layoutType", "Leu/thesimplecloud/module/sign/lib/layout/LayoutType;", "load", "save", "", "signModuleConfig", "simplecloud-module-sign"})
public final class SignModuleConfigPersistence {
    @NotNull
    public static final SignModuleConfigPersistence INSTANCE = new SignModuleConfigPersistence();
    @NotNull
    private static final File layoutsDir = new File("modules/sign/layouts/");
    @NotNull
    private static final File signsFile = new File("modules/sign/signs.json");
    @NotNull
    private static final File groupLayoutsFile = new File("modules/sign/groupLayouts.json");

    private SignModuleConfigPersistence() {
    }

    public final void save(@NotNull SignModuleConfig signModuleConfig) {
        Intrinsics.checkNotNullParameter((Object)signModuleConfig, (String)"signModuleConfig");
        JsonLib.Companion.fromObject((Object)signModuleConfig.getGroupsLayoutContainer()).saveAsFile(groupLayoutsFile);
        JsonLib.Companion.fromObject((Object)signModuleConfig.getSignContainer()).saveAsFile(signsFile);
        List<SignLayout> allLayouts = signModuleConfig.getSignLayoutContainer().getAllLayouts();
        Iterable $this$forEach$iv = allLayouts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SignLayout it = (SignLayout)element$iv;
            boolean bl = false;
            File dir = INSTANCE.getLayoutsDirectoryByLayoutType(it.getLayoutType());
            JsonLib.Companion.fromObject((Object)it).saveAsFile(new File(dir, Intrinsics.stringPlus((String)it.getName(), (Object)".json")));
        }
    }

    private final File getLayoutsDirectoryByLayoutType(LayoutType layoutType) {
        String string = layoutType.name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return new File(layoutsDir, Intrinsics.stringPlus((String)string3, (Object)"/"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SignModuleConfig load() {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        Collection collection;
        File item$iv$iv2;
        void $this$mapTo$iv$iv3;
        if (!groupLayoutsFile.exists()) {
            return this.createDefaultConfig();
        }
        if (!signsFile.exists()) {
            return this.createDefaultConfig();
        }
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)groupLayoutsFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib);
        GroupLayoutsContainer groupsLayoutContainer = (GroupLayoutsContainer)jsonLib.getObject(GroupLayoutsContainer.class);
        JsonLib jsonLib2 = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)signsFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib2);
        CloudSignContainer cloudSignContainer = (CloudSignContainer)jsonLib2.getObject(CloudSignContainer.class);
        LayoutType[] $this$map$iv = LayoutType.values();
        boolean $i$f$map = false;
        LayoutType[] layoutTypeArray = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (File item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it;
            void var13_23 = item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = INSTANCE.getLayoutsDirectoryByLayoutType((LayoutType)it);
            collection.add(object);
        }
        List allLayoutDirectories = (List)destination$iv$iv;
        Iterable $this$map$iv2 = allLayoutDirectories;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void it;
            item$iv$iv2 = (File)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl = false;
            File[] bl2 = it.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.listFiles()");
            object = ArraysKt.toList((Object[])bl2);
            collection.add(object);
        }
        List allFiles = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = allFiles;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            File bl = item$iv$iv2 = iterator.next();
            collection = destination$iv$iv3;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            JsonLib jsonLib3 = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)it, null, (int)2, null);
            Intrinsics.checkNotNull((Object)jsonLib3);
            object = (SignLayout)jsonLib3.getObject(SignLayout.class);
            collection.add(object);
        }
        List layouts = (List)destination$iv$iv3;
        return new SignModuleConfig(new SignLayoutContainer(CollectionsKt.toMutableList((Collection)layouts)), cloudSignContainer, groupsLayoutContainer);
    }

    private final SignModuleConfig createDefaultConfig() {
        GroupLayoutsContainer groupsLayoutContainer = new GroupLayoutsContainer();
        CloudSignContainer cloudSignContainer = new CloudSignContainer();
        SignLayoutContainer layoutsContainer = new SignLayoutContainer(CollectionsKt.toMutableList((Collection)this.getDefaultLayoutList()));
        return new SignModuleConfig(layoutsContainer, cloudSignContainer, groupsLayoutContainer);
    }

    private final List<SignLayout> getDefaultLayoutList() {
        Object[] objectArray = new SignLayout[5];
        Object[] objectArray2 = new SignFrame[3];
        String[] stringArray = new String[]{"\u00a78--------", "Searching for", "server.", "\u00a78--------"};
        objectArray2[0] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a78--------", "Searching for", "server..", "\u00a78--------"};
        objectArray2[1] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a78--------", "Searching for", "server...", "\u00a78--------"};
        objectArray2[2] = new SignFrame(stringArray);
        objectArray[0] = new SignLayout("default", LayoutType.SEARCHING, CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new SignFrame[3];
        stringArray = new String[]{"\u00a76--------", "Server is", "starting.", "\u00a76--------"};
        objectArray2[0] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a76--------", "Server is", "starting..", "\u00a76--------"};
        objectArray2[1] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a76--------", "Server is", "starting...", "\u00a76--------"};
        objectArray2[2] = new SignFrame(stringArray);
        objectArray[1] = new SignLayout("default", LayoutType.STARTING, CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"\u00a74--------", "%GROUP%", "\u00a78Maintenance", "\u00a74--------"};
        objectArray[2] = new SignLayout("default", LayoutType.MAINTENANCE, CollectionsKt.listOf((Object)new SignFrame((String[])objectArray2)));
        objectArray2 = new String[]{"%SERVICE%", "\u00a7a%STATE%", "%MOTD%", "%ONLINE_PLAYERS%/%MAX_PLAYERS%"};
        objectArray[3] = new SignLayout("default", LayoutType.ONLINE, CollectionsKt.listOf((Object)new SignFrame((String[])objectArray2)));
        objectArray2 = new String[]{"%SERVICE%", "\u00a76%STATE%", "%MOTD%", "%ONLINE_PLAYERS%/%MAX_PLAYERS%"};
        objectArray[4] = new SignLayout("default", LayoutType.FULL, CollectionsKt.listOf((Object)new SignFrame((String[])objectArray2)));
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

