/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.manager.command;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.module.sign.lib.SignModuleConfig;
import eu.thesimplecloud.module.sign.lib.group.GroupLayouts;
import eu.thesimplecloud.module.sign.lib.group.GroupLayoutsContainer;
import eu.thesimplecloud.module.sign.lib.layout.LayoutType;
import eu.thesimplecloud.module.sign.lib.layout.SignLayout;
import eu.thesimplecloud.module.sign.manager.SignModuleConfigPersistence;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Command(name="sign", commandType=CommandType.CONSOLE_AND_INGAME, permission="cloud.module.sign")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\r"}, d2={"Leu/thesimplecloud/module/sign/manager/command/SignCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "()V", "handleEditLayout", "", "sender", "Leu/thesimplecloud/api/command/ICommandSender;", "groupName", "", "layoutType", "Leu/thesimplecloud/module/sign/lib/layout/LayoutType;", "layoutName", "handleReload", "simplecloud-module-sign"})
public final class SignCommand
implements ICommandHandler {
    @CommandSubPath(path="reload", description="Reloads the sign module")
    public final void handleReload(@NotNull ICommandSender sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        SignModuleConfig config = SignModuleConfigPersistence.INSTANCE.load();
        config.update();
        sender.sendProperty("manager.command.sign.reload", new String[0]);
    }

    @CommandSubPath(path="layout <group> <layoutType> <layout>", description="Sets the layout for a group")
    public final void handleEditLayout(@NotNull ICommandSender sender, @CommandArgument(name="group") @NotNull String groupName, @CommandArgument(name="layoutType") @NotNull LayoutType layoutType, @CommandArgument(name="layout") @NotNull String layoutName) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutType), (String)"layoutType");
        Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
        ICloudServiceGroup group = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(groupName);
        if (group == null) {
            sender.sendProperty("manager.command.sign.layout.group-not-found", new String[0]);
            return;
        }
        SignModuleConfig config = SignModuleConfigPersistence.INSTANCE.load();
        SignLayout signLayout = config.getSignLayoutContainer().getLayoutByName(layoutType, layoutName);
        if (signLayout == null) {
            sender.sendProperty("manager.command.sign.layout.layout-not-found", new String[0]);
            return;
        }
        GroupLayoutsContainer groupsLayoutContainer = config.getGroupsLayoutContainer();
        if (groupsLayoutContainer.hasGroupLayout(group)) {
            GroupLayouts groupLayouts = groupsLayoutContainer.getGroupLayoutsByGroupName(group.getName());
            Intrinsics.checkNotNull((Object)groupLayouts);
            GroupLayouts groupLayouts2 = groupLayouts;
            groupLayouts2.setLayout(layoutType, layoutName);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)layoutType), (Object)layoutName)};
            GroupLayouts groupsLayout = new GroupLayouts(group.getName(), MapsKt.mutableMapOf((Pair[])pairArray));
            groupsLayoutContainer.addGroupLayouts(groupsLayout);
        }
        config.update();
        SignModuleConfigPersistence.INSTANCE.save(config);
        String[] stringArray = new String[]{group.getName(), layoutName, layoutType.toString()};
        sender.sendProperty("manager.command.sign.layout.success", stringArray);
    }
}

