/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.service.command;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.location.TemplateLocation;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.module.sign.lib.SignModuleConfig;
import eu.thesimplecloud.module.sign.lib.sign.CloudSign;
import eu.thesimplecloud.plugin.extension.LocationExtensionKt;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/module/sign/service/command/CloudSignsCommand;", "Lorg/bukkit/command/CommandExecutor;", "()V", "thisService", "Leu/thesimplecloud/api/service/ICloudService;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "simplecloud-module-sign"})
public final class CloudSignsCommand
implements CommandExecutor {
    @NotNull
    private final ICloudService thisService = CloudPlugin.Companion.getInstance().thisService();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(sender instanceof Player)) {
            return true;
        }
        Object object = ((Player)sender).getTargetBlock(null, 4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sender.getTargetBlock(null, 4)");
        String[] block = object;
        if (!(block.getState() instanceof Sign)) {
            sender.sendMessage("\u00a7cYou must look at a sign.");
            return true;
        }
        object = args;
        boolean bl = false;
        if (((String[])object).length == 0) {
            sender.sendMessage("\u00a7cUsage: /cloudsigns <add/remove> [group]");
            return true;
        }
        String string = args[0];
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        object = string3;
        if (Intrinsics.areEqual((Object)object, (Object)"add")) {
            if (args.length != 2) {
                sender.sendMessage("\u00a7cUsage: /cloudsigns <add> <group>");
                return true;
            }
            String groupName = args[1];
            ICloudServiceGroup serviceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(groupName);
            if (serviceGroup == null) {
                sender.sendMessage("\u00a7cGroup not found.");
                return true;
            }
            if (serviceGroup.getServiceType() == ServiceType.PROXY) {
                sender.sendMessage("\u00a7cCannot create a sign for proxy groups.");
                return true;
            }
            SignModuleConfig signModuleConfig2 = SignModuleConfig.Companion.getConfig();
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
            TemplateLocation templateLocation = LocationExtensionKt.toCloudLocation((Location)location).toTemplateLocation();
            CloudSign cloudSignByLocation = signModuleConfig2.getSignContainer().getCloudSignByLocation(this.thisService.getTemplate(), templateLocation);
            if (cloudSignByLocation != null) {
                sender.sendMessage("\u00a7cThere is already a sign registered on this location.");
                return true;
            }
            signModuleConfig2.getSignContainer().addSign(new CloudSign(templateLocation, serviceGroup.getName()));
            signModuleConfig2.update();
            sender.sendMessage("\u00a7aSign added.");
        } else if (Intrinsics.areEqual((Object)object, (Object)"remove")) {
            SignModuleConfig signModuleConfig = SignModuleConfig.Companion.getConfig();
            Location signModuleConfig2 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)signModuleConfig2, (String)"block.location");
            TemplateLocation templateLocation = LocationExtensionKt.toCloudLocation((Location)signModuleConfig2).toTemplateLocation();
            CloudSign cloudSign = signModuleConfig.getSignContainer().getCloudSignByLocation(this.thisService.getTemplate(), templateLocation);
            if (cloudSign == null) {
                sender.sendMessage("\u00a7cSign is not registered.");
                return true;
            }
            signModuleConfig.getSignContainer().removeSign(cloudSign);
            signModuleConfig.update();
            sender.sendMessage("\u00a7aSign removed.");
        } else {
            sender.sendMessage("\u00a7cUsage: /cloudsigns <add/remove> [group]");
            return true;
        }
        return true;
    }
}

