/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.service.listener;

import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.module.sign.service.BukkitCloudSign;
import eu.thesimplecloud.module.sign.service.SignAPI;
import eu.thesimplecloud.module.sign.service.SignServiceViewManager;
import eu.thesimplecloud.plugin.extension.PlayerExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Leu/thesimplecloud/module/sign/service/listener/InteractListener;", "Lorg/bukkit/event/Listener;", "()V", "on", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "simplecloud-module-sign"})
public final class InteractListener
implements Listener {
    @EventHandler
    public final void on(@NotNull PlayerInteractEvent event) {
        Block block;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block2 = event.getClickedBlock();
        if (block2 == null) {
            return;
        }
        Block clickedBlock = block = block2;
        block2 = clickedBlock.getState();
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"clickedBlock.state");
        Block state = block2;
        if (state instanceof Sign) {
            SignServiceViewManager signServiceViewManager = SignAPI.Companion.getInstance().getServiceViewManager();
            Location location = ((Sign)state).getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"state.location");
            BukkitCloudSign bukkitCloudSign = signServiceViewManager.getBukkitCloudSignByLocation(location);
            if (bukkitCloudSign == null) {
                return;
            }
            BukkitCloudSign bukkitCloudSign2 = bukkitCloudSign;
            if ((bukkitCloudSign = bukkitCloudSign2.getServiceGroup()) == null ? false : bukkitCloudSign.isInMaintenance()) {
                return;
            }
            location = bukkitCloudSign2.getService();
            if (location == null) {
                return;
            }
            Location currentServer = location;
            if (currentServer.getState() != ServiceState.VISIBLE) {
                return;
            }
            location = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"event.player");
            PlayerExtensionsKt.getCloudPlayer((Player)location).connect((ICloudService)currentServer);
        }
    }
}

