/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.statistics;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.base.manager.database.IOfflineCloudPlayerHandler;
import eu.thesimplecloud.base.manager.database.MongoOfflineCloudPlayerHandler;
import eu.thesimplecloud.base.manager.database.SQLOfflineCloudPlayerHandler;
import eu.thesimplecloud.base.manager.startup.Manager;
import eu.thesimplecloud.module.rest.controller.IController;
import eu.thesimplecloud.module.rest.javalin.RestServer;
import eu.thesimplecloud.module.statistics.rest.timed.TimedValueController;
import eu.thesimplecloud.module.statistics.timed.TimedValueCollectorManager;
import eu.thesimplecloud.module.statistics.timed.collector.CPUUsageTimedCollector;
import eu.thesimplecloud.module.statistics.timed.collector.MemoryTimedCollector;
import eu.thesimplecloud.module.statistics.timed.collector.PlayerCountTimedCollector;
import eu.thesimplecloud.module.statistics.timed.listener.CloudServiceStartListener;
import eu.thesimplecloud.module.statistics.timed.listener.PlayerConnectListener;
import eu.thesimplecloud.module.statistics.timed.store.ITimedValueStore;
import eu.thesimplecloud.module.statistics.timed.store.MongoTimedValueStore;
import eu.thesimplecloud.module.statistics.timed.store.SQLTimedValueStore;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Leu/thesimplecloud/module/statistics/StatisticsModule;", "Leu/thesimplecloud/api/external/ICloudModule;", "()V", "timedValueCollectorManager", "Leu/thesimplecloud/module/statistics/timed/TimedValueCollectorManager;", "valueStores", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Leu/thesimplecloud/module/statistics/timed/store/ITimedValueStore;", "createTimedValueStore", "T", "", "collectionName", "", "clazz", "Ljava/lang/Class;", "getValueStoreByName", "name", "onDisable", "", "onEnable", "Companion", "simplecloud-module-statistics"})
public final class StatisticsModule
implements ICloudModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimedValueCollectorManager timedValueCollectorManager = new TimedValueCollectorManager();
    @NotNull
    private final CopyOnWriteArrayList<ITimedValueStore<?>> valueStores = new CopyOnWriteArrayList();
    private static StatisticsModule instance;

    public void onEnable() {
        instance = this;
        CloudAPI.Companion.getInstance().getEventManager().registerListener((ICloudModule)this, (IListener)new CloudServiceStartListener());
        CloudAPI.Companion.getInstance().getEventManager().registerListener((ICloudModule)this, (IListener)new PlayerConnectListener());
        Iterable $this$forEach$iv = CloudAPI.Companion.getInstance().getWrapperManager().getAllCachedObjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IWrapperInfo it = (IWrapperInfo)element$iv;
            boolean bl = false;
            this.timedValueCollectorManager.registerValueCollector(new CPUUsageTimedCollector(it), Float.TYPE);
            this.timedValueCollectorManager.registerValueCollector(new MemoryTimedCollector(it), Integer.TYPE);
        }
        this.timedValueCollectorManager.registerValueCollector(new PlayerCountTimedCollector(), Integer.TYPE);
        this.timedValueCollectorManager.start();
        RestServer.Companion.getInstance().getControllerHandler().registerController((IController)new TimedValueController());
    }

    public void onDisable() {
    }

    @Nullable
    public final ITimedValueStore<?> getValueStoreByName(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.valueStores;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ITimedValueStore it = (ITimedValueStore)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCollectionName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final <T> ITimedValueStore<T> createTimedValueStore(@NotNull String collectionName, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        IOfflineCloudPlayerHandler offlineCloudPlayerHandler = Manager.Companion.getInstance().getOfflineCloudPlayerHandler();
        if (offlineCloudPlayerHandler instanceof SQLOfflineCloudPlayerHandler) {
            SQLTimedValueStore<T> sqlTimedValueStore = new SQLTimedValueStore<T>(clazz, collectionName);
            this.valueStores.add(sqlTimedValueStore);
            return sqlTimedValueStore;
        }
        if (offlineCloudPlayerHandler instanceof MongoOfflineCloudPlayerHandler) {
            MongoTimedValueStore<T> mongoTimedValueStore = new MongoTimedValueStore<T>(clazz, collectionName, ((MongoOfflineCloudPlayerHandler)offlineCloudPlayerHandler).getDatabase());
            this.valueStores.add(mongoTimedValueStore);
            return mongoTimedValueStore;
        }
        throw new IllegalStateException("OfflineCloudPlayerManager was not SQL or MongoDB");
    }

    public boolean isReloadable() {
        return ICloudModule.DefaultImpls.isReloadable((ICloudModule)this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Leu/thesimplecloud/module/statistics/StatisticsModule$Companion;", "", "()V", "<set-?>", "Leu/thesimplecloud/module/statistics/StatisticsModule;", "instance", "getInstance", "()Leu/thesimplecloud/module/statistics/StatisticsModule;", "simplecloud-module-statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatisticsModule getInstance() {
            StatisticsModule statisticsModule = instance;
            if (statisticsModule != null) {
                return statisticsModule;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

