/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.statistics.timed.collector;

import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.module.statistics.timed.TimedValue;
import eu.thesimplecloud.module.statistics.timed.collector.ITimedValueCollector;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Leu/thesimplecloud/module/statistics/timed/collector/MemoryTimedCollector;", "Leu/thesimplecloud/module/statistics/timed/collector/ITimedValueCollector;", "", "wrapperInfo", "Leu/thesimplecloud/api/wrapper/IWrapperInfo;", "(Leu/thesimplecloud/api/wrapper/IWrapperInfo;)V", "collectInterval", "", "collectValue", "Leu/thesimplecloud/module/statistics/timed/TimedValue;", "collectionName", "", "simplecloud-module-statistics"})
public final class MemoryTimedCollector
implements ITimedValueCollector<Integer> {
    @NotNull
    private final IWrapperInfo wrapperInfo;

    public MemoryTimedCollector(@NotNull IWrapperInfo wrapperInfo) {
        Intrinsics.checkNotNullParameter((Object)wrapperInfo, (String)"wrapperInfo");
        this.wrapperInfo = wrapperInfo;
    }

    @Override
    @NotNull
    public TimedValue<Integer> collectValue() {
        int usedMemory = this.wrapperInfo.getUsedMemory();
        return new TimedValue<Integer>(usedMemory, 0L, 2, null);
    }

    @Override
    public long collectInterval() {
        return TimeUnit.MINUTES.toMillis(1L);
    }

    @Override
    @NotNull
    public String collectionName() {
        return Intrinsics.stringPlus((String)"cloud_stats_memory_usage_", (Object)this.wrapperInfo.getName());
    }
}

