/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.statistics.timed.store;

import eu.thesimplecloud.base.manager.database.SQLOfflineCloudPlayerHandler;
import eu.thesimplecloud.base.manager.startup.Manager;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.statistics.timed.TimedValue;
import eu.thesimplecloud.module.statistics.timed.store.ITimedValueStore;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Leu/thesimplecloud/module/statistics/timed/store/SQLTimedValueStore;", "T", "", "Leu/thesimplecloud/module/statistics/timed/store/ITimedValueStore;", "classOfT", "Ljava/lang/Class;", "collectionName", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "count", "", "createDatabaseAndIndicesIfNotExist", "", "createIndex", "columnName", "doesTableExist", "", "get", "", "Leu/thesimplecloud/module/statistics/timed/TimedValue;", "fromTimeStamp", "", "toTimeStamp", "getAll", "getAllTimedValuesFromResultSet", "resultSet", "Ljava/sql/ResultSet;", "getCollectionName", "getConnection", "Ljava/sql/Connection;", "store", "timedValue", "simplecloud-module-statistics"})
public final class SQLTimedValueStore<T>
implements ITimedValueStore<T> {
    @NotNull
    private final Class<T> classOfT;
    @NotNull
    private final String collectionName;

    public SQLTimedValueStore(@NotNull Class<T> classOfT, @NotNull String collectionName) {
        Intrinsics.checkNotNullParameter(classOfT, (String)"classOfT");
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        this.classOfT = classOfT;
        this.collectionName = collectionName;
        this.createDatabaseAndIndicesIfNotExist();
    }

    private final Connection getConnection() {
        SQLOfflineCloudPlayerHandler playerHandler = (SQLOfflineCloudPlayerHandler)Manager.Companion.getInstance().getOfflineCloudPlayerHandler();
        Connection connection = playerHandler.getConnection();
        Intrinsics.checkNotNull((Object)connection);
        return connection;
    }

    private final void createDatabaseAndIndicesIfNotExist() {
        if (!this.doesTableExist()) {
            PreparedStatement statement = this.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.collectionName + "` (`value` varchar(36), `timestamp` BIGINT(20))");
            statement.executeUpdate();
            this.createIndex("timestamp");
        }
    }

    @Override
    public void store(@NotNull TimedValue<T> timedValue) {
        Intrinsics.checkNotNullParameter(timedValue, (String)"timedValue");
        PreparedStatement statement = this.getConnection().prepareStatement("INSERT INTO `" + this.collectionName + "` (`value`, `timestamp`) VALUES (?, ?)");
        statement.setString(1, timedValue.getValue().toString());
        statement.setLong(2, timedValue.getTimeStamp());
        statement.executeUpdate();
    }

    private final void createIndex(String columnName) {
        PreparedStatement statement = this.getConnection().prepareStatement("ALTER TABLE " + this.collectionName + " ADD INDEX (" + columnName + ')');
        statement.executeUpdate();
    }

    private final boolean doesTableExist() {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"getConnection().metaData");
        DatabaseMetaData meta = databaseMetaData;
        String[] stringArray = new String[]{"TABLE"};
        ResultSet res = meta.getTables(null, null, this.collectionName, stringArray);
        return res.next();
    }

    @Override
    @NotNull
    public List<TimedValue<T>> getAll() {
        PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM `" + this.collectionName + '`');
        ResultSet resultSet = statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
        return this.getAllTimedValuesFromResultSet(resultSet);
    }

    @Override
    @NotNull
    public List<TimedValue<T>> get(long fromTimeStamp, long toTimeStamp) {
        PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM `" + this.collectionName + "` WHERE timestamp BETWEEN " + fromTimeStamp + " and " + toTimeStamp + " ORDER BY timestamp ASC");
        ResultSet resultSet = statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
        return this.getAllTimedValuesFromResultSet(resultSet);
    }

    private final List<TimedValue<T>> getAllTimedValuesFromResultSet(ResultSet resultSet) {
        ArrayList<TimedValue<Object>> returnList = new ArrayList<TimedValue<Object>>();
        while (resultSet.next()) {
            String value = resultSet.getString(1);
            long timeStamp = resultSet.getLong(2);
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            returnList.add(new TimedValue<Object>(JsonLib.Companion.fromJsonString$default((JsonLib.Companion)JsonLib.Companion, (String)value, null, (int)2, null).getObject(this.classOfT), timeStamp));
        }
        return returnList;
    }

    @Override
    @NotNull
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public int count() {
        PreparedStatement statement = this.getConnection().prepareStatement("SELECT COUNT(*) FROM `" + this.collectionName + '`');
        ResultSet resultSet = statement.executeQuery();
        return !resultSet.next() ? 0 : resultSet.getInt(1);
    }

    @Override
    @NotNull
    public <T extends Number> List<TimedValue<T>> getAveraged(@NotNull List<TimedValue<T>> valueList, long resolution) {
        return ITimedValueStore.DefaultImpls.getAveraged(this, valueList, resolution);
    }

    @Override
    @NotNull
    public List<TimedValue<T>> get(long fromTimeStamp, long toTimeStamp, long resolution) {
        return ITimedValueStore.DefaultImpls.get(this, fromTimeStamp, toTimeStamp, resolution);
    }
}

