/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.player;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.api.event.player.permission.CloudPlayerPermissionCheckEvent;
import eu.thesimplecloud.api.event.player.permission.PermissionState;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.player.ICloudPlayerUpdater;
import eu.thesimplecloud.api.player.IOfflineCloudPlayer;
import eu.thesimplecloud.api.player.PlayerServerConnectState;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.player.connection.IPlayerConnection;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0011\u001a\u00020\u000fH&J\n\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000fH&J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0019H&J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00062\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u001bH&J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010#\u001a\u00020$H'J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010%\u001a\u00020&H&J)\u0010'\u001a\u00020\u000b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0)H\u0016\u00a2\u0006\u0002\u0010+J0\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u00105\u001a\u00020\u0015H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0016\u00a8\u0006:"}, d2={"Leu/thesimplecloud/api/player/ICloudPlayer;", "Leu/thesimplecloud/api/cachelist/value/ICacheValue;", "Leu/thesimplecloud/api/player/ICloudPlayerUpdater;", "Leu/thesimplecloud/api/player/IOfflineCloudPlayer;", "Leu/thesimplecloud/api/command/ICommandSender;", "connect", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "disableUpdates", "", "enableUpdates", "forceCommandExecution", "command", "", "getConnectedProxy", "getConnectedProxyName", "getConnectedServer", "getConnectedServerName", "getLocation", "Leu/thesimplecloud/api/location/ServiceLocation;", "getPlayerConnection", "Leu/thesimplecloud/api/player/connection/IPlayerConnection;", "getServerConnectState", "Leu/thesimplecloud/api/player/PlayerServerConnectState;", "hasPermission", "", "permission", "isUpdatesEnabled", "kick", "message", "sendActionBar", "actionbar", "sendMessage", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "component", "Lnet/kyori/adventure/text/Component;", "sendTablist", "headers", "", "footers", "([Ljava/lang/String;[Ljava/lang/String;)V", "sendTitle", "title", "subTitle", "fadeIn", "", "stay", "fadeOut", "sendToLobby", "teleport", "location", "Leu/thesimplecloud/api/location/SimpleLocation;", "toSimplePlayer", "Leu/thesimplecloud/api/player/SimpleCloudPlayer;", "update", "simplecloud-api"})
public interface ICloudPlayer
extends ICacheValue<ICloudPlayerUpdater>,
IOfflineCloudPlayer,
ICommandSender {
    @NotNull
    public IPlayerConnection getPlayerConnection();

    @NotNull
    public PlayerServerConnectState getServerConnectState();

    @Deprecated(message="Use sendMessage with component instead")
    @NotNull
    public ICommunicationPromise<Unit> sendMessage(@NotNull CloudText var1);

    @NotNull
    public ICommunicationPromise<Unit> sendMessage(@NotNull Component var1);

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendMessage(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<ConnectionResponse> connect(@NotNull ICloudService var1);

    @NotNull
    public ICommunicationPromise<Unit> kick(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<Unit> kick();

    public void sendTitle(@NotNull String var1, @NotNull String var2, int var3, int var4, int var5);

    public void sendActionBar(@NotNull String var1);

    public void sendTablist(@NotNull String[] var1, @NotNull String[] var2);

    @NotNull
    public String getConnectedProxyName();

    @Nullable
    public String getConnectedServerName();

    @Nullable
    public ICloudService getConnectedProxy();

    @Nullable
    public ICloudService getConnectedServer();

    public void enableUpdates();

    public void disableUpdates();

    public void forceCommandExecution(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<Unit> teleport(@NotNull SimpleLocation var1);

    @NotNull
    public ICommunicationPromise<Unit> teleport(@NotNull ServiceLocation var1);

    @Override
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocation();

    @NotNull
    public ICommunicationPromise<Unit> sendToLobby();

    @NotNull
    public SimpleCloudPlayer toSimplePlayer();

    @Override
    @NotNull
    public ICommunicationPromise<Unit> update();

    public boolean isUpdatesEnabled();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ICommunicationPromise<Unit> sendMessage(@NotNull ICloudPlayer this_, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            TextComponent textComponent = Component.text((String)message);
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(message)");
            return this_.sendMessage((Component)textComponent);
        }

        @NotNull
        public static ICommunicationPromise<ConnectionResponse> connect(@NotNull ICloudPlayer this_, @NotNull ICloudService cloudService) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().connectPlayer(this_, cloudService);
        }

        @NotNull
        public static ICommunicationPromise<Unit> kick(@NotNull ICloudPlayer this_, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().kickPlayer(this_, message);
        }

        @NotNull
        public static ICommunicationPromise<Unit> kick(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.kick("\u00a7cYou were kicked from the network.");
        }

        public static void sendTitle(@NotNull ICloudPlayer this_, @NotNull String title, @NotNull String subTitle, int fadeIn, int stay, int fadeOut) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)subTitle, (String)"subTitle");
            CloudAPI.Companion.getInstance().getCloudPlayerManager().sendTitle(this_, title, subTitle, fadeIn, stay, fadeOut);
        }

        public static void sendActionBar(@NotNull ICloudPlayer this_, @NotNull String actionbar) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)actionbar, (String)"actionbar");
            CloudAPI.Companion.getInstance().getCloudPlayerManager().sendActionbar(this_, actionbar);
        }

        public static void sendTablist(@NotNull ICloudPlayer this_, @NotNull String[] headers, @NotNull String[] footers) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)footers, (String)"footers");
            CloudAPI.Companion.getInstance().getCloudPlayerManager().sendTablist(this_, headers, footers);
        }

        @Nullable
        public static ICloudService getConnectedProxy(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(this_.getConnectedProxyName());
        }

        @Nullable
        public static ICloudService getConnectedServer(@NotNull ICloudPlayer this_) {
            ICloudService iCloudService;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String string = this_.getConnectedServerName();
            if (string == null) {
                iCloudService = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                iCloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(it);
            }
            return iCloudService;
        }

        public static void enableUpdates(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            CloudAPI.Companion.getInstance().getCloudPlayerManager().setUpdates(this_, true, CloudAPI.Companion.getInstance().getThisSidesName());
        }

        public static void disableUpdates(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            CloudAPI.Companion.getInstance().getCloudPlayerManager().setUpdates(this_, false, CloudAPI.Companion.getInstance().getThisSidesName());
        }

        public static void forceCommandExecution(@NotNull ICloudPlayer this_, @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            CloudAPI.Companion.getInstance().getCloudPlayerManager().forcePlayerCommandExecution(this_, command);
        }

        @NotNull
        public static ICommunicationPromise<Unit> teleport(@NotNull ICloudPlayer this_, @NotNull SimpleLocation location) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().teleportPlayer(this_, location);
        }

        @NotNull
        public static ICommunicationPromise<Unit> teleport(@NotNull ICloudPlayer this_, @NotNull ServiceLocation location) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().teleportPlayer(this_, location);
        }

        @NotNull
        public static ICommunicationPromise<Boolean> hasPermission(@NotNull ICloudPlayer this_, @NotNull String permission) {
            ICommunicationPromise iCommunicationPromise;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            CloudPlayerPermissionCheckEvent event = new CloudPlayerPermissionCheckEvent(this_, permission, PermissionState.UNKNOWN);
            IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), event, false, 2, null);
            if (event.getState() == PermissionState.UNKNOWN) {
                iCommunicationPromise = CloudAPI.Companion.getInstance().getCloudPlayerManager().hasPermission(this_, permission);
            } else {
                String string = event.getState().name();
                boolean bl = false;
                iCommunicationPromise = CommunicationPromise.Companion.of((Object)Boolean.parseBoolean(string));
            }
            return iCommunicationPromise;
        }

        @NotNull
        public static ICommunicationPromise<ServiceLocation> getLocation(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().getLocationOfPlayer(this_);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendToLobby(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().sendPlayerToLobby(this_);
        }

        @NotNull
        public static SimpleCloudPlayer toSimplePlayer(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return new SimpleCloudPlayer(this_.getName(), this_.getUniqueId());
        }

        @NotNull
        public static ICommunicationPromise<Unit> update(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return ICacheList.DefaultImpls.update$default(CloudAPI.Companion.getInstance().getCloudPlayerManager(), this_, false, false, 6, null);
        }

        @Nullable
        public static <T> IProperty<T> getProperty(@NotNull ICloudPlayer this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return IOfflineCloudPlayer.DefaultImpls.getProperty(this_, name);
        }

        @NotNull
        public static ConcurrentMap<String, IProperty<?>> getMapWithNewestProperties(@NotNull ICloudPlayer this_, @NotNull Map<String, ? extends IProperty<?>> compareMap) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(compareMap, (String)"compareMap");
            return IOfflineCloudPlayer.DefaultImpls.getMapWithNewestProperties(this_, compareMap);
        }

        public static boolean hasPermissionSync(@NotNull ICloudPlayer this_, @NotNull String permission) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            return ICommandSender.DefaultImpls.hasPermissionSync(this_, permission);
        }

        public static boolean hasProperty(@NotNull ICloudPlayer this_, @NotNull String property) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return IOfflineCloudPlayer.DefaultImpls.hasProperty(this_, property);
        }

        public static boolean isOnline(@NotNull ICloudPlayer this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return IOfflineCloudPlayer.DefaultImpls.isOnline(this_);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendProperty(@NotNull ICloudPlayer this_, @NotNull String property, String ... placeholderValues) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)placeholderValues, (String)"placeholderValues");
            return ICommandSender.DefaultImpls.sendProperty(this_, property, placeholderValues);
        }
    }
}

