/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.player.impl;

import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerUpdater;
import eu.thesimplecloud.api.player.OfflineCloudPlayer;
import eu.thesimplecloud.api.player.PlayerMessageQueue;
import eu.thesimplecloud.api.player.PlayerServerConnectState;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.api.player.connection.IPlayerConnection;
import eu.thesimplecloud.api.player.impl.CloudPlayerUpdater;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.player.text.CloudTextBuilder;
import eu.thesimplecloud.api.property.Property;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.json.PacketExclude;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.jsonlib.JsonLibExclude;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B_\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J\b\u0010(\u001a\u00020\u001fH\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0,2\u0006\u0010/\u001a\u000200H\u0016J\u0006\u00101\u001a\u00020\u001dJ\b\u00102\u001a\u00020\u0004H\u0016R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Leu/thesimplecloud/api/player/impl/CloudPlayer;", "Leu/thesimplecloud/api/player/OfflineCloudPlayer;", "Leu/thesimplecloud/api/player/ICloudPlayer;", "name", "", "uniqueId", "Ljava/util/UUID;", "firstLogin", "", "lastLogin", "onlineTime", "connectedProxyName", "connectedServerName", "playerConnection", "Leu/thesimplecloud/api/player/connection/DefaultPlayerConnection;", "propertyMap", "Ljava/util/concurrent/ConcurrentMap;", "Leu/thesimplecloud/api/property/Property;", "(Ljava/lang/String;Ljava/util/UUID;JJJLjava/lang/String;Ljava/lang/String;Leu/thesimplecloud/api/player/connection/DefaultPlayerConnection;Ljava/util/concurrent/ConcurrentMap;)V", "connectState", "Leu/thesimplecloud/api/player/PlayerServerConnectState;", "online", "", "playerMessageQueue", "Leu/thesimplecloud/api/player/PlayerMessageQueue;", "playerUpdater", "Leu/thesimplecloud/api/player/impl/CloudPlayerUpdater;", "updatesEnabled", "applyValuesFromUpdater", "", "updater", "Leu/thesimplecloud/api/player/ICloudPlayerUpdater;", "disableUpdates", "enableUpdates", "getConnectedProxyName", "getConnectedServerName", "getOnlineTime", "getPlayerConnection", "Leu/thesimplecloud/api/player/connection/IPlayerConnection;", "getServerConnectState", "getUpdater", "isOnline", "isUpdatesEnabled", "sendMessage", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "component", "Lnet/kyori/adventure/text/Component;", "setOffline", "toString", "simplecloud-api"})
public final class CloudPlayer
extends OfflineCloudPlayer
implements ICloudPlayer {
    @NotNull
    private volatile String connectedProxyName;
    @Nullable
    private volatile String connectedServerName;
    @JsonLibExclude
    @PacketExclude
    @Nullable
    private volatile CloudPlayerUpdater playerUpdater;
    @NotNull
    private volatile PlayerServerConnectState connectState;
    private volatile boolean online;
    @PacketExclude
    private volatile boolean updatesEnabled;
    @PacketExclude
    @JsonLibExclude
    @Nullable
    private PlayerMessageQueue playerMessageQueue;

    public CloudPlayer(@NotNull String name, @NotNull UUID uniqueId, long firstLogin, long lastLogin, long onlineTime, @NotNull String connectedProxyName, @Nullable String connectedServerName, @NotNull DefaultPlayerConnection playerConnection, @NotNull ConcurrentMap<String, Property<?>> propertyMap) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)connectedProxyName, (String)"connectedProxyName");
        Intrinsics.checkNotNullParameter((Object)playerConnection, (String)"playerConnection");
        Intrinsics.checkNotNullParameter(propertyMap, (String)"propertyMap");
        super(name, uniqueId, firstLogin, lastLogin, onlineTime, playerConnection, propertyMap);
        this.connectedProxyName = connectedProxyName;
        this.connectedServerName = connectedServerName;
        this.playerUpdater = new CloudPlayerUpdater(this);
        this.connectState = PlayerServerConnectState.CONNECTING;
        this.online = true;
    }

    @Override
    @NotNull
    public IPlayerConnection getPlayerConnection() {
        return this.getLastPlayerConnection();
    }

    @Override
    @NotNull
    public PlayerServerConnectState getServerConnectState() {
        return this.connectState;
    }

    @Override
    @NotNull
    public synchronized ICommunicationPromise<Unit> sendMessage(@NotNull CloudText cloudText) {
        Intrinsics.checkNotNullParameter((Object)cloudText, (String)"cloudText");
        return this.sendMessage(new CloudTextBuilder().build(cloudText));
    }

    @Override
    @NotNull
    public synchronized ICommunicationPromise<Unit> sendMessage(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.playerMessageQueue == null) {
            this.playerMessageQueue = new PlayerMessageQueue(this);
        }
        PlayerMessageQueue playerMessageQueue = this.playerMessageQueue;
        Intrinsics.checkNotNull((Object)playerMessageQueue);
        return playerMessageQueue.queueMessage(component);
    }

    @Override
    @NotNull
    public String getConnectedProxyName() {
        return this.connectedProxyName;
    }

    @Override
    @Nullable
    public String getConnectedServerName() {
        return this.connectedServerName;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void enableUpdates() {
        ICloudPlayer.DefaultImpls.enableUpdates(this);
        this.updatesEnabled = true;
    }

    @Override
    public void disableUpdates() {
        ICloudPlayer.DefaultImpls.disableUpdates(this);
        this.updatesEnabled = false;
    }

    @Override
    public boolean isUpdatesEnabled() {
        return this.updatesEnabled;
    }

    @Override
    @NotNull
    public ICloudPlayerUpdater getUpdater() {
        if (this.playerUpdater == null) {
            this.playerUpdater = new CloudPlayerUpdater(this);
        }
        CloudPlayerUpdater cloudPlayerUpdater = this.playerUpdater;
        Intrinsics.checkNotNull((Object)cloudPlayerUpdater);
        return cloudPlayerUpdater;
    }

    @Override
    public void applyValuesFromUpdater(@NotNull ICloudPlayerUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        super.setDisplayName(updater2.getDisplayName());
        CloudPlayerUpdater cfr_ignored_0 = (CloudPlayerUpdater)updater2;
        this.connectedServerName = updater2.getConnectedServerName();
        this.connectedProxyName = updater2.getConnectedProxyName();
        this.connectState = updater2.getServerConnectState();
        this.setPropertyMap(this.getMapWithNewestProperties(updater2.getCloudPlayer().getProperties()));
    }

    public final synchronized void setOffline() {
        this.online = false;
    }

    @Override
    public long getOnlineTime() {
        return System.currentTimeMillis() - this.getLastLogin() + super.getOnlineTime();
    }

    @NotNull
    public String toString() {
        return JsonLib.Companion.fromObject((Object)this).getAsJsonString();
    }

    @Override
    @NotNull
    public ICommunicationPromise<ConnectionResponse> connect(@NotNull ICloudService cloudService) {
        return ICloudPlayer.DefaultImpls.connect(this, cloudService);
    }

    @Override
    public void forceCommandExecution(@NotNull String command) {
        ICloudPlayer.DefaultImpls.forceCommandExecution(this, command);
    }

    @Override
    @Nullable
    public ICloudService getConnectedProxy() {
        return ICloudPlayer.DefaultImpls.getConnectedProxy(this);
    }

    @Override
    @Nullable
    public ICloudService getConnectedServer() {
        return ICloudPlayer.DefaultImpls.getConnectedServer(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocation() {
        return ICloudPlayer.DefaultImpls.getLocation(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull String permission) {
        return ICloudPlayer.DefaultImpls.hasPermission(this, permission);
    }

    @Override
    public boolean hasPermissionSync(@NotNull String permission) {
        return ICloudPlayer.DefaultImpls.hasPermissionSync(this, permission);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> kick() {
        return ICloudPlayer.DefaultImpls.kick(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> kick(@NotNull String message) {
        return ICloudPlayer.DefaultImpls.kick(this, message);
    }

    @Override
    public void sendActionBar(@NotNull String actionbar) {
        ICloudPlayer.DefaultImpls.sendActionBar(this, actionbar);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendMessage(@NotNull String message) {
        return ICloudPlayer.DefaultImpls.sendMessage(this, message);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendProperty(@NotNull String property, String ... placeholderValues) {
        return ICloudPlayer.DefaultImpls.sendProperty(this, property, placeholderValues);
    }

    @Override
    public void sendTablist(@NotNull String[] headers, @NotNull String[] footers) {
        ICloudPlayer.DefaultImpls.sendTablist(this, headers, footers);
    }

    @Override
    public void sendTitle(@NotNull String title, @NotNull String subTitle, int fadeIn, int stay, int fadeOut) {
        ICloudPlayer.DefaultImpls.sendTitle(this, title, subTitle, fadeIn, stay, fadeOut);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendToLobby() {
        return ICloudPlayer.DefaultImpls.sendToLobby(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleport(@NotNull ServiceLocation location) {
        return ICloudPlayer.DefaultImpls.teleport((ICloudPlayer)this, location);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleport(@NotNull SimpleLocation location) {
        return ICloudPlayer.DefaultImpls.teleport((ICloudPlayer)this, location);
    }

    @Override
    @NotNull
    public SimpleCloudPlayer toSimplePlayer() {
        return ICloudPlayer.DefaultImpls.toSimplePlayer(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> update() {
        return ICloudPlayer.DefaultImpls.update(this);
    }
}

