/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.client.NetworkComponentReference;
import eu.thesimplecloud.api.client.NetworkComponentType;
import eu.thesimplecloud.api.event.service.CloudServiceConnectedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartingEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.listenerextension.AdvancedListener;
import eu.thesimplecloud.api.network.component.INetworkComponent;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.IPropertyMap;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ICloudServiceUpdater;
import eu.thesimplecloud.api.service.ICloudServiceVariables;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.service.version.ServiceVersion;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.template.ITemplate;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.IBootstrap;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromiseExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH&J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\bH\u0016J\u0016\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010!0\u001e0\bH\u0016J\b\u0010\"\u001a\u00020\u0017H&J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0017H&J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H&J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u000bH&J\b\u0010-\u001a\u00020.H&J\b\u0010/\u001a\u00020\u0017H&J\b\u00100\u001a\u000201H\u0016J\n\u00102\u001a\u0004\u0018\u00010\u000bH&J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000204H\u0016J\b\u00106\u001a\u000204H\u0016J\b\u00107\u001a\u000204H\u0016J\b\u00108\u001a\u000204H\u0016J\b\u00109\u001a\u000204H\u0016J\b\u0010:\u001a\u000204H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006>"}, d2={"Leu/thesimplecloud/api/service/ICloudService;", "Leu/thesimplecloud/api/cachelist/value/ICacheValue;", "Leu/thesimplecloud/api/service/ICloudServiceUpdater;", "Leu/thesimplecloud/api/service/ICloudServiceVariables;", "Leu/thesimplecloud/api/network/component/INetworkComponent;", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/IBootstrap;", "Leu/thesimplecloud/api/property/IPropertyMap;", "copy", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "path", "", "createClosedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceUnregisteredEvent;", "createConnectedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceConnectedEvent;", "createStartedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceStartedEvent;", "createStartingPromise", "Leu/thesimplecloud/api/event/service/CloudServiceStartingEvent;", "getGroupName", "getHost", "getMaxMemory", "", "getName", "getNetworkComponentType", "Leu/thesimplecloud/api/client/NetworkComponentType;", "getOnlinePercentage", "", "getOnlinePlayers", "", "Leu/thesimplecloud/api/player/SimpleCloudPlayer;", "getOnlinePlayersDirect", "Leu/thesimplecloud/api/player/ICloudPlayer;", "getPort", "getServiceGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "getServiceNumber", "getServiceType", "Leu/thesimplecloud/api/service/ServiceType;", "getServiceVersion", "Leu/thesimplecloud/api/service/version/ServiceVersion;", "getTemplate", "Leu/thesimplecloud/api/template/ITemplate;", "getTemplateName", "getUniqueId", "Ljava/util/UUID;", "getUsedMemory", "getWrapper", "Leu/thesimplecloud/api/wrapper/IWrapperInfo;", "getWrapperName", "isActive", "", "isFull", "isLobby", "isOnline", "isProxy", "isStartingOrVisible", "isStatic", "shutdown", "start", "update", "simplecloud-api"})
public interface ICloudService
extends ICacheValue<ICloudServiceUpdater>,
ICloudServiceVariables,
INetworkComponent,
IBootstrap,
IPropertyMap {
    @NotNull
    public String getGroupName();

    public int getServiceNumber();

    @NotNull
    public UUID getUniqueId();

    @NotNull
    public ServiceType getServiceType();

    @NotNull
    public ServiceVersion getServiceVersion();

    @NotNull
    public String getTemplateName();

    @NotNull
    public ITemplate getTemplate();

    @NotNull
    public ICloudServiceGroup getServiceGroup();

    public int getMaxMemory();

    public int getUsedMemory();

    @Nullable
    public String getWrapperName();

    @NotNull
    public IWrapperInfo getWrapper();

    @NotNull
    public String getHost();

    public int getPort();

    public boolean isStatic();

    public double getOnlinePercentage();

    @Override
    @NotNull
    public String getName();

    @NotNull
    public ICommunicationPromise<List<SimpleCloudPlayer>> getOnlinePlayers();

    @NotNull
    public ICommunicationPromise<List<ICloudPlayer>> getOnlinePlayersDirect();

    public boolean isOnline();

    public boolean isFull();

    @Override
    @NotNull
    public NetworkComponentType getNetworkComponentType();

    @NotNull
    public ICommunicationPromise<CloudServiceStartingEvent> createStartingPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceConnectedEvent> createConnectedPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceStartedEvent> createStartedPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceUnregisteredEvent> createClosedPromise();

    public boolean isLobby();

    public boolean isProxy();

    @NotNull
    public ICommunicationPromise<Unit> update();

    @NotNull
    public ICommunicationPromise<Unit> copy(@NotNull String var1);

    public boolean isStartingOrVisible();

    public boolean isActive();

    @NotNull
    public ICommunicationPromise<Unit> start();

    @NotNull
    public ICommunicationPromise<Unit> shutdown();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ServiceType getServiceType(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getServiceGroup().getServiceType();
        }

        @NotNull
        public static ITemplate getTemplate(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ITemplate iTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName(this_.getTemplateName());
            if (iTemplate == null) {
                throw new IllegalStateException("Can't find the template of an registered service (templates: " + CollectionsKt.joinToString$default((Iterable)CloudAPI.Companion.getInstance().getTemplateManager().getAllCachedObjects(), null, null, null, (int)0, null, (Function1)getTemplate.1.INSTANCE, (int)31, null) + ')');
            }
            return iTemplate;
        }

        @NotNull
        public static ICloudServiceGroup getServiceGroup(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ICloudServiceGroup iCloudServiceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(this_.getGroupName());
            if (iCloudServiceGroup == null) {
                throw new IllegalStateException("Can't find the service group of an registered service");
            }
            return iCloudServiceGroup;
        }

        @NotNull
        public static IWrapperInfo getWrapper(@NotNull ICloudService this_) {
            IWrapperInfo iWrapperInfo;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String string = this_.getWrapperName();
            if (string == null) {
                iWrapperInfo = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                iWrapperInfo = CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByName(it);
            }
            IWrapperInfo iWrapperInfo2 = iWrapperInfo;
            if (iWrapperInfo2 == null) {
                throw new IllegalStateException("Can't find the wrapper where the service " + this_.getName() + " is running on. Wrapper-Name: " + this_.getWrapperName());
            }
            return iWrapperInfo2;
        }

        @NotNull
        public static String getHost(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getWrapper().getHost();
        }

        public static boolean isStatic(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getServiceGroup().isStatic();
        }

        public static double getOnlinePercentage(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (double)this_.getOnlineCount() / (double)this_.getMaxPlayers();
        }

        @NotNull
        public static String getName(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getGroupName() + '-' + this_.getServiceNumber();
        }

        @NotNull
        public static ICommunicationPromise<List<SimpleCloudPlayer>> getOnlinePlayers(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().getPlayersConnectedToService(this_);
        }

        @NotNull
        public static ICommunicationPromise<List<ICloudPlayer>> getOnlinePlayersDirect(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CommunicationPromiseExtensionKt.flatten$default((ICommunicationPromise)this_.getOnlinePlayers().then((Function1)getOnlinePlayersDirect.1.INSTANCE), (long)0L, (boolean)false, (int)3, null);
        }

        public static boolean isOnline(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.isServiceJoinable();
        }

        public static boolean isFull(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getOnlineCount() >= this_.getMaxPlayers();
        }

        @NotNull
        public static NetworkComponentType getNetworkComponentType(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return NetworkComponentType.SERVICE;
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceStartingEvent> createStartingPromise(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            if (this_.isActive() || this_.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of((Object)new CloudServiceStartingEvent(this_));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceStartingEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceStartingEvent, Boolean>(this_){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceStartingEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceConnectedEvent> createConnectedPromise(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            if (this_.isAuthenticated() || this_.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of((Object)new CloudServiceConnectedEvent(this_));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceConnectedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceConnectedEvent, Boolean>(this_){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceConnectedEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceStartedEvent> createStartedPromise(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            if (this_.isOnline() || this_.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of((Object)new CloudServiceStartedEvent(this_));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceStartedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceStartedEvent, Boolean>(this_){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceStartedEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceUnregisteredEvent> createClosedPromise(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            if (this_.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of((Object)new CloudServiceUnregisteredEvent(this_));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceUnregisteredEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceUnregisteredEvent, Boolean>(this_){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceUnregisteredEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        public static boolean isLobby(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getServiceType() == ServiceType.LOBBY;
        }

        public static boolean isProxy(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getServiceType() == ServiceType.PROXY;
        }

        @NotNull
        public static ICommunicationPromise<Unit> update(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return ((ICloudServiceUpdater)this_.getUpdater()).update();
        }

        @NotNull
        public static ICommunicationPromise<Unit> copy(@NotNull ICloudService this_, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return CloudAPI.Companion.getInstance().getCloudServiceManager().copyService(this_, path);
        }

        public static boolean isStartingOrVisible(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getState() == ServiceState.STARTING || this_.getState() == ServiceState.VISIBLE;
        }

        public static boolean isActive(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getState() != ServiceState.PREPARED && this_.getState() != ServiceState.CLOSED;
        }

        @NotNull
        public static ICommunicationPromise<Unit> start(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CloudAPI.Companion.getInstance().getCloudServiceManager().startService(this_);
        }

        @NotNull
        public static ICommunicationPromise<Unit> shutdown(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CloudAPI.Companion.getInstance().getCloudServiceManager().stopService(this_);
        }

        @Nullable
        public static <T> IProperty<T> getProperty(@NotNull ICloudService this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return IPropertyMap.DefaultImpls.getProperty(this_, name);
        }

        public static void executeCommand(@NotNull ICloudService this_, @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            INetworkComponent.DefaultImpls.executeCommand(this_, command);
        }

        @NotNull
        public static ConcurrentMap<String, IProperty<?>> getMapWithNewestProperties(@NotNull ICloudService this_, @NotNull Map<String, ? extends IProperty<?>> compareMap) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(compareMap, (String)"compareMap");
            return IPropertyMap.DefaultImpls.getMapWithNewestProperties(this_, compareMap);
        }

        public static boolean hasProperty(@NotNull ICloudService this_, @NotNull String property) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return IPropertyMap.DefaultImpls.hasProperty(this_, property);
        }

        public static boolean isServiceJoinable(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return ICloudServiceVariables.DefaultImpls.isServiceJoinable(this_);
        }

        @NotNull
        public static NetworkComponentReference toNetworkComponentReference(@NotNull ICloudService this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return INetworkComponent.DefaultImpls.toNetworkComponentReference(this_);
        }
    }
}

