/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service.impl;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.AbstractCacheList;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.ICacheObjectUpdateExecutor;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.event.service.CloudServiceConnectedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceEvent;
import eu.thesimplecloud.api.event.service.CloudServiceInvisibleEvent;
import eu.thesimplecloud.api.event.service.CloudServiceRegisteredEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartingEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUpdatedEvent;
import eu.thesimplecloud.api.eventapi.IEvent;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.network.packets.sync.cachelist.PacketIOUpdateCacheObject;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ICloudServiceManager;
import eu.thesimplecloud.api.service.ICloudServiceUpdater;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.impl.AbstractCloudServiceManager;
import eu.thesimplecloud.api.utils.time.Timestamp;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0007\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0013H\u0016R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/api/service/impl/AbstractCloudServiceManager;", "Leu/thesimplecloud/api/cachelist/AbstractCacheList;", "Leu/thesimplecloud/api/service/ICloudServiceUpdater;", "Leu/thesimplecloud/api/service/ICloudService;", "Leu/thesimplecloud/api/service/ICloudServiceManager;", "()V", "updater", "eu/thesimplecloud/api/service/impl/AbstractCloudServiceManager$updater$1", "Leu/thesimplecloud/api/service/impl/AbstractCloudServiceManager$updater$1;", "delete", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "value", "fromPacket", "", "deleteCloudService", "name", "", "getUpdateExecutor", "Leu/thesimplecloud/api/cachelist/ICacheObjectUpdateExecutor;", "simplecloud-api"})
public abstract class AbstractCloudServiceManager
extends AbstractCacheList<ICloudServiceUpdater, ICloudService>
implements ICloudServiceManager {
    @NotNull
    private final updater.1 updater = new ICacheObjectUpdateExecutor<ICloudServiceUpdater, ICloudService>(this){
        final /* synthetic */ AbstractCloudServiceManager this$0;
        {
            this.this$0 = $receiver;
        }

        @Nullable
        public ICloudService getCachedObjectByUpdateValue(@NotNull ICloudService value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.this$0.getCloudServiceByName(value.getName());
        }

        @NotNull
        public List<IEvent> determineEventsToCall(@NotNull ICloudServiceUpdater updater2, @Nullable ICloudService cachedValue) {
            Object[] serviceToUse;
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            Object[] objectArray = cachedValue;
            Object object = serviceToUse = objectArray == null ? updater2.getCloudService() : objectArray;
            if (cachedValue == null) {
                objectArray = new CloudServiceEvent[]{new CloudServiceRegisteredEvent((ICloudService)serviceToUse), new CloudServiceUpdatedEvent((ICloudService)serviceToUse)};
                return CollectionsKt.listOf((Object[])objectArray);
            }
            boolean nowStarting = cachedValue.getState() == ServiceState.PREPARED && updater2.getState() == ServiceState.STARTING;
            boolean nowOnline = !cachedValue.isOnline() && updater2.isServiceJoinable();
            boolean nowConnected = !cachedValue.isAuthenticated() && updater2.isAuthenticated();
            boolean nowInvisible = cachedValue.getState() == ServiceState.VISIBLE && updater2.getState() == ServiceState.INVISIBLE;
            ArrayList<CloudServiceEvent> events = new ArrayList<CloudServiceEvent>();
            events.add(new CloudServiceUpdatedEvent((ICloudService)cachedValue));
            if (nowStarting) {
                events.add(new CloudServiceStartingEvent((ICloudService)cachedValue));
            }
            if (nowConnected) {
                events.add(new CloudServiceConnectedEvent((ICloudService)cachedValue));
            }
            if (nowOnline) {
                events.add(new CloudServiceStartedEvent((ICloudService)cachedValue));
            }
            if (nowInvisible) {
                events.add(new CloudServiceInvisibleEvent((ICloudService)cachedValue));
            }
            return events;
        }

        public void addNewValue(@NotNull ICloudService value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            value.setLastPlayerUpdate(new Timestamp(0L, 1, null));
            AbstractCloudServiceManager.access$getValues(this.this$0).add(value);
        }

        @NotNull
        public String getIdentificationName() {
            return "service-cache";
        }

        @NotNull
        public ICommunicationPromise<Unit> sendUpdatesToOtherComponents(@NotNull ICloudService value, @NotNull PacketIOUpdateCacheObject.Action action) {
            return ICacheObjectUpdateExecutor.DefaultImpls.sendUpdatesToOtherComponents(this, (ICacheValue)value, action);
        }
    };

    public AbstractCloudServiceManager() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public ICacheObjectUpdateExecutor<ICloudServiceUpdater, ICloudService> getUpdateExecutor() {
        return this.updater;
    }

    @Override
    public void deleteCloudService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudService iCloudService = this.getCloudServiceByName(name);
        if (iCloudService != null) {
            ICloudService iCloudService2 = iCloudService;
            boolean bl = false;
            boolean bl2 = false;
            ICloudService it = iCloudService2;
            boolean bl3 = false;
            ICacheList.DefaultImpls.delete$default(this, it, false, 2, null);
        }
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> delete(@NotNull ICloudService value, boolean fromPacket) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), new CloudServiceUnregisteredEvent(value), false, 2, null);
        return super.delete((ICacheValue)value, fromPacket);
    }

    @Override
    @Nullable
    public ICloudService getCloudServiceByName(@NotNull String name) {
        return ICloudServiceManager.DefaultImpls.getCloudServiceByName(this, name);
    }

    @Override
    @NotNull
    public List<ICloudService> getCloudServicesByGroupName(@NotNull String groupName) {
        return ICloudServiceManager.DefaultImpls.getCloudServicesByGroupName(this, groupName);
    }

    @Override
    @NotNull
    public List<ICloudService> getCloudServicesInLobbyStateByGroupName(@NotNull String groupName) {
        return ICloudServiceManager.DefaultImpls.getCloudServicesInLobbyStateByGroupName(this, groupName);
    }

    @Override
    @NotNull
    public List<ICloudService> getNotFullServicesInLobbyStateByGroupName(@NotNull String groupName) {
        return ICloudServiceManager.DefaultImpls.getNotFullServicesInLobbyStateByGroupName(this, groupName);
    }

    @Override
    @NotNull
    public List<ICloudService> getServicesRunningOnWrapper(@NotNull String wrapperName) {
        return ICloudServiceManager.DefaultImpls.getServicesRunningOnWrapper(this, wrapperName);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> startService(@NotNull ICloudService cloudService) {
        return ICloudServiceManager.DefaultImpls.startService(this, cloudService);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getValues(AbstractCloudServiceManager $this) {
        return $this.getValues();
    }
}

