/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.wrapper;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.client.NetworkComponentReference;
import eu.thesimplecloud.api.client.NetworkComponentType;
import eu.thesimplecloud.api.network.component.INetworkComponent;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.wrapper.IWrapperInfoUpdater;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0007H&J\b\u0010\u000b\u001a\u00020\u0007H&J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0007H&J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0014H&\u00a8\u0006\u0017"}, d2={"Leu/thesimplecloud/api/wrapper/IWrapperInfo;", "Leu/thesimplecloud/api/cachelist/value/ICacheValue;", "Leu/thesimplecloud/api/wrapper/IWrapperInfoUpdater;", "Leu/thesimplecloud/api/network/component/INetworkComponent;", "getCpuUsage", "", "getCurrentlyStartingServices", "", "getHost", "", "getMaxMemory", "getMaxSimultaneouslyStartingServices", "getNetworkComponentType", "Leu/thesimplecloud/api/client/NetworkComponentType;", "getServicesRunningOnThisWrapper", "", "Leu/thesimplecloud/api/service/ICloudService;", "getUnusedMemory", "getUsedMemory", "hasEnoughMemory", "", "memory", "hasTemplatesReceived", "simplecloud-api"})
public interface IWrapperInfo
extends ICacheValue<IWrapperInfoUpdater>,
INetworkComponent {
    @NotNull
    public String getHost();

    public int getMaxSimultaneouslyStartingServices();

    public int getUsedMemory();

    public int getMaxMemory();

    public float getCpuUsage();

    public int getUnusedMemory();

    public boolean hasEnoughMemory(int var1);

    public boolean hasTemplatesReceived();

    public int getCurrentlyStartingServices();

    @NotNull
    public List<ICloudService> getServicesRunningOnThisWrapper();

    @Override
    @NotNull
    public NetworkComponentType getNetworkComponentType();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getUnusedMemory(@NotNull IWrapperInfo this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getMaxMemory() - this_.getUsedMemory();
        }

        public static boolean hasEnoughMemory(@NotNull IWrapperInfo this_, int memory) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getUnusedMemory() >= memory;
        }

        @NotNull
        public static List<ICloudService> getServicesRunningOnThisWrapper(@NotNull IWrapperInfo this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return CloudAPI.Companion.getInstance().getCloudServiceManager().getServicesRunningOnWrapper(this_.getName());
        }

        @NotNull
        public static NetworkComponentType getNetworkComponentType(@NotNull IWrapperInfo this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return NetworkComponentType.WRAPPER;
        }

        public static void executeCommand(@NotNull IWrapperInfo this_, @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            INetworkComponent.DefaultImpls.executeCommand(this_, command);
        }

        @NotNull
        public static NetworkComponentReference toNetworkComponentReference(@NotNull IWrapperInfo this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return INetworkComponent.DefaultImpls.toNetworkComponentReference(this_);
        }
    }
}

