/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.eventapi;

import com.google.common.collect.Maps;
import eu.thesimplecloud.api.eventapi.CloudEventHandler;
import eu.thesimplecloud.api.eventapi.IEvent;
import eu.thesimplecloud.api.eventapi.IEventExecutor;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.eventapi.exception.EventException;
import eu.thesimplecloud.api.external.ICloudModule;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0005H\u0002J0\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016R\u0086\u0001\u0010\u0003\u001az\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0006 \u0007*\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b \u0007*<\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0006 \u0007*\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Leu/thesimplecloud/api/eventapi/BasicEventManager;", "Leu/thesimplecloud/api/eventapi/IEventManager;", "()V", "listeners", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/lang/Class;", "Leu/thesimplecloud/api/eventapi/IEvent;", "kotlin.jvm.PlatformType", "", "Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent;", "addRegisteredEvent", "", "registeredEvent", "call", "event", "fromPacket", "", "getValidMethods", "", "Ljava/lang/reflect/Method;", "listenerClass", "Leu/thesimplecloud/api/eventapi/IListener;", "registerEvent", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "eventClass", "listener", "eventExecutor", "Leu/thesimplecloud/api/eventapi/IEventExecutor;", "registerListener", "removeRegisteredEvent", "unregisterAll", "unregisterAllListenersByCloudModule", "unregisterListener", "RegisteredEvent", "simplecloud-api"})
@SourceDebugExtension(value={"SMAP\nBasicEventManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicEventManager.kt\neu/thesimplecloud/api/eventapi/BasicEventManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1549#2:140\n1620#2,2:141\n766#2:143\n857#2,2:144\n1622#2:146\n1855#2,2:147\n1855#2,2:149\n1855#2,2:151\n1855#2,2:156\n3792#3:153\n4307#3,2:154\n73#4,2:158\n1#5:160\n*S KotlinDebug\n*F\n+ 1 BasicEventManager.kt\neu/thesimplecloud/api/eventapi/BasicEventManager\n*L\n55#1:140\n55#1:141,2\n55#1:143\n55#1:144,2\n55#1:146\n56#1:147,2\n60#1:149,2\n66#1:151,2\n86#1:156,2\n81#1:153\n81#1:154,2\n96#1:158,2\n96#1:160\n*E\n"})
public class BasicEventManager
implements IEventManager {
    private final ConcurrentMap<Class<? extends IEvent>, List<RegisteredEvent>> listeners = Maps.newConcurrentMap();

    @Override
    public void registerListener(@NotNull ICloudModule cloudModule, @NotNull IListener listener) {
        Intrinsics.checkNotNullParameter(cloudModule, "cloudModule");
        Intrinsics.checkNotNullParameter(listener, "listener");
        for (Method method : this.getValidMethods(listener.getClass())) {
            Class<?> eventClass;
            Intrinsics.checkNotNull(method.getParameterTypes()[0], "null cannot be cast to non-null type java.lang.Class<out eu.thesimplecloud.api.eventapi.IEvent>");
            this.addRegisteredEvent(RegisteredEvent.Companion.fromEventMethod(cloudModule, eventClass, listener, method));
        }
    }

    @Override
    public void registerEvent(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull IEventExecutor eventExecutor) {
        Intrinsics.checkNotNullParameter(cloudModule, "cloudModule");
        Intrinsics.checkNotNullParameter(eventClass, "eventClass");
        Intrinsics.checkNotNullParameter(listener, "listener");
        Intrinsics.checkNotNullParameter(eventExecutor, "eventExecutor");
        this.addRegisteredEvent(new RegisteredEvent(cloudModule, eventClass, listener, eventExecutor));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregisterListener(@NotNull IListener listener) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(listener, "listener");
        Iterable $this$map$iv = this.listeners.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Iterable $this$filter$iv = (Iterable)it;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RegisteredEvent it2 = (RegisteredEvent)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it2.getListener(), listener)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            collection.add((List)destination$iv$iv2);
        }
        List list = CollectionsKt.flatten((List)destination$iv$iv);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisteredEvent it = (RegisteredEvent)element$iv;
            boolean bl = false;
            this.removeRegisteredEvent(it);
        }
    }

    @Override
    public void call(@NotNull IEvent event, boolean fromPacket) {
        block1: {
            Intrinsics.checkNotNullParameter(event, "event");
            List list = (List)this.listeners.get(event.getClass());
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RegisteredEvent registeredEvent = (RegisteredEvent)element$iv;
                boolean bl = false;
                registeredEvent.getEventExecutor().execute(event);
            }
        }
    }

    @Override
    public void unregisterAllListenersByCloudModule(@NotNull ICloudModule cloudModule) {
        Intrinsics.checkNotNullParameter(cloudModule, "cloudModule");
        Iterable $this$forEach$iv = this.listeners.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list = (List)element$iv;
            boolean bl = false;
            list.removeIf(arg_0 -> BasicEventManager.unregisterAllListenersByCloudModule$lambda$5$lambda$4(new Function1<RegisteredEvent, Boolean>(cloudModule){
                final /* synthetic */ ICloudModule $cloudModule;
                {
                    this.$cloudModule = $cloudModule;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull RegisteredEvent it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it.getCloudModule(), this.$cloudModule);
                }
            }, arg_0));
        }
    }

    @Override
    public void unregisterAll() {
        this.listeners.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Method> getValidMethods(Class<? extends IListener> listenerClass) {
        void $this$filterTo$iv$iv;
        Method[] methodArray = listenerClass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "listenerClass.declaredMethods");
        Object[] $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            if (!(it.isAnnotationPresent(CloudEventHandler.class) && it.getParameterTypes().length == 1 && IEvent.class.isAssignableFrom(it.getParameterTypes()[0]))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List methods = (List)destination$iv$iv;
        Iterable $this$forEach$iv = methods;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            it.setAccessible(true);
        }
        return methods;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRegisteredEvent(RegisteredEvent registeredEvent) {
        void $this$getOrPut$iv;
        ConcurrentMap<Class<? extends IEvent>, List<RegisteredEvent>> concurrentMap = this.listeners;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "this.listeners");
        ConcurrentMap<Class<? extends IEvent>, List<RegisteredEvent>> concurrentMap2 = concurrentMap;
        Class<? extends IEvent> key$iv = registeredEvent.getEventClass();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            List default$iv = new CopyOnWriteArrayList();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ((List)object).add(registeredEvent);
    }

    private final void removeRegisteredEvent(RegisteredEvent registeredEvent) {
        block0: {
            List list = (List)this.listeners.get(registeredEvent.getEventClass());
            if (list == null) break block0;
            list.remove(registeredEvent);
        }
    }

    private static final boolean unregisterAllListenersByCloudModule$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent;", "", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "eventClass", "Ljava/lang/Class;", "Leu/thesimplecloud/api/eventapi/IEvent;", "listener", "Leu/thesimplecloud/api/eventapi/IListener;", "eventExecutor", "Leu/thesimplecloud/api/eventapi/IEventExecutor;", "(Leu/thesimplecloud/api/external/ICloudModule;Ljava/lang/Class;Leu/thesimplecloud/api/eventapi/IListener;Leu/thesimplecloud/api/eventapi/IEventExecutor;)V", "getCloudModule", "()Leu/thesimplecloud/api/external/ICloudModule;", "getEventClass", "()Ljava/lang/Class;", "getEventExecutor", "()Leu/thesimplecloud/api/eventapi/IEventExecutor;", "getListener", "()Leu/thesimplecloud/api/eventapi/IListener;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "simplecloud-api"})
    public static final class RegisteredEvent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ICloudModule cloudModule;
        @NotNull
        private final Class<? extends IEvent> eventClass;
        @NotNull
        private final IListener listener;
        @NotNull
        private final IEventExecutor eventExecutor;

        public RegisteredEvent(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull IEventExecutor eventExecutor) {
            Intrinsics.checkNotNullParameter(cloudModule, "cloudModule");
            Intrinsics.checkNotNullParameter(eventClass, "eventClass");
            Intrinsics.checkNotNullParameter(listener, "listener");
            Intrinsics.checkNotNullParameter(eventExecutor, "eventExecutor");
            this.cloudModule = cloudModule;
            this.eventClass = eventClass;
            this.listener = listener;
            this.eventExecutor = eventExecutor;
        }

        @NotNull
        public final ICloudModule getCloudModule() {
            return this.cloudModule;
        }

        @NotNull
        public final Class<? extends IEvent> getEventClass() {
            return this.eventClass;
        }

        @NotNull
        public final IListener getListener() {
            return this.listener;
        }

        @NotNull
        public final IEventExecutor getEventExecutor() {
            return this.eventExecutor;
        }

        @NotNull
        public final ICloudModule component1() {
            return this.cloudModule;
        }

        @NotNull
        public final Class<? extends IEvent> component2() {
            return this.eventClass;
        }

        @NotNull
        public final IListener component3() {
            return this.listener;
        }

        @NotNull
        public final IEventExecutor component4() {
            return this.eventExecutor;
        }

        @NotNull
        public final RegisteredEvent copy(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull IEventExecutor eventExecutor) {
            Intrinsics.checkNotNullParameter(cloudModule, "cloudModule");
            Intrinsics.checkNotNullParameter(eventClass, "eventClass");
            Intrinsics.checkNotNullParameter(listener, "listener");
            Intrinsics.checkNotNullParameter(eventExecutor, "eventExecutor");
            return new RegisteredEvent(cloudModule, eventClass, listener, eventExecutor);
        }

        public static /* synthetic */ RegisteredEvent copy$default(RegisteredEvent registeredEvent, ICloudModule iCloudModule, Class clazz, IListener iListener, IEventExecutor iEventExecutor, int n, Object object) {
            if ((n & 1) != 0) {
                iCloudModule = registeredEvent.cloudModule;
            }
            if ((n & 2) != 0) {
                clazz = registeredEvent.eventClass;
            }
            if ((n & 4) != 0) {
                iListener = registeredEvent.listener;
            }
            if ((n & 8) != 0) {
                iEventExecutor = registeredEvent.eventExecutor;
            }
            return registeredEvent.copy(iCloudModule, clazz, iListener, iEventExecutor);
        }

        @NotNull
        public String toString() {
            return "RegisteredEvent(cloudModule=" + this.cloudModule + ", eventClass=" + this.eventClass + ", listener=" + this.listener + ", eventExecutor=" + this.eventExecutor + ')';
        }

        public int hashCode() {
            int result2 = this.cloudModule.hashCode();
            result2 = result2 * 31 + this.eventClass.hashCode();
            result2 = result2 * 31 + this.listener.hashCode();
            result2 = result2 * 31 + this.eventExecutor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegisteredEvent)) {
                return false;
            }
            RegisteredEvent registeredEvent = (RegisteredEvent)other;
            if (!Intrinsics.areEqual(this.cloudModule, registeredEvent.cloudModule)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.eventClass, registeredEvent.eventClass)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.listener, registeredEvent.listener)) {
                return false;
            }
            return Intrinsics.areEqual(this.eventExecutor, registeredEvent.eventExecutor);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent$Companion;", "", "()V", "fromEventMethod", "Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent;", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "eventClass", "Ljava/lang/Class;", "Leu/thesimplecloud/api/eventapi/IEvent;", "listener", "Leu/thesimplecloud/api/eventapi/IListener;", "method", "Ljava/lang/reflect/Method;", "simplecloud-api"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RegisteredEvent fromEventMethod(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull Method method) {
                Intrinsics.checkNotNullParameter(cloudModule, "cloudModule");
                Intrinsics.checkNotNullParameter(eventClass, "eventClass");
                Intrinsics.checkNotNullParameter(listener, "listener");
                Intrinsics.checkNotNullParameter(method, "method");
                return new RegisteredEvent(cloudModule, eventClass, listener, new IEventExecutor(eventClass, method, listener){
                    final /* synthetic */ Class<? extends IEvent> $eventClass;
                    final /* synthetic */ Method $method;
                    final /* synthetic */ IListener $listener;
                    {
                        this.$eventClass = $eventClass;
                        this.$method = $method;
                        this.$listener = $listener;
                    }

                    public void execute(@NotNull IEvent event) {
                        Intrinsics.checkNotNullParameter(event, "event");
                        if (!this.$eventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        try {
                            Object[] objectArray = new Object[]{event};
                            this.$method.invoke((Object)this.$listener, objectArray);
                        }
                        catch (Exception ex) {
                            throw new EventException(event, (Throwable)ex);
                        }
                    }
                });
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

