/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.client.NetworkComponentReference;
import eu.thesimplecloud.api.client.NetworkComponentType;
import eu.thesimplecloud.api.event.service.CloudServiceConnectedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartingEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.listenerextension.AdvancedListener;
import eu.thesimplecloud.api.network.component.INetworkComponent;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.IPropertyMap;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ICloudServiceUpdater;
import eu.thesimplecloud.api.service.ICloudServiceVariables;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.service.version.ServiceVersion;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.template.ITemplate;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.IBootstrap;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromiseExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH&J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0017H&J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\bH\u0016J\u0016\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u001f0\bH\u0016J\b\u0010#\u001a\u00020\u0017H&J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0017H&J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H&J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u000bH&J\b\u0010.\u001a\u00020/H&J\b\u00100\u001a\u00020\u0017H&J\b\u00101\u001a\u000202H\u0016J\n\u00103\u001a\u0004\u0018\u00010\u000bH&J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000205H\u0016J\b\u00107\u001a\u000205H\u0016J\b\u00108\u001a\u000205H\u0016J\b\u00109\u001a\u000205H\u0016J\b\u0010:\u001a\u000205H\u0016J\b\u0010;\u001a\u000205H\u0016J\b\u0010<\u001a\u000205H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006@"}, d2={"Leu/thesimplecloud/api/service/ICloudService;", "Leu/thesimplecloud/api/cachelist/value/ICacheValue;", "Leu/thesimplecloud/api/service/ICloudServiceUpdater;", "Leu/thesimplecloud/api/service/ICloudServiceVariables;", "Leu/thesimplecloud/api/network/component/INetworkComponent;", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/IBootstrap;", "Leu/thesimplecloud/api/property/IPropertyMap;", "copy", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "path", "", "createClosedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceUnregisteredEvent;", "createConnectedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceConnectedEvent;", "createStartedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceStartedEvent;", "createStartingPromise", "Leu/thesimplecloud/api/event/service/CloudServiceStartingEvent;", "getGroupName", "getHost", "getMaxMemory", "", "getMinimumMemory", "getName", "getNetworkComponentType", "Leu/thesimplecloud/api/client/NetworkComponentType;", "getOnlinePercentage", "", "getOnlinePlayers", "", "Leu/thesimplecloud/api/player/SimpleCloudPlayer;", "getOnlinePlayersDirect", "Leu/thesimplecloud/api/player/ICloudPlayer;", "getPort", "getServiceGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "getServiceNumber", "getServiceType", "Leu/thesimplecloud/api/service/ServiceType;", "getServiceVersion", "Leu/thesimplecloud/api/service/version/ServiceVersion;", "getTemplate", "Leu/thesimplecloud/api/template/ITemplate;", "getTemplateName", "getUniqueId", "Ljava/util/UUID;", "getUsedMemory", "getWrapper", "Leu/thesimplecloud/api/wrapper/IWrapperInfo;", "getWrapperName", "isActive", "", "isForceCopyTemplates", "isFull", "isLobby", "isOnline", "isProxy", "isStartingOrVisible", "isStatic", "shutdown", "start", "update", "simplecloud-api"})
public interface ICloudService
extends ICacheValue<ICloudServiceUpdater>,
ICloudServiceVariables,
INetworkComponent,
IBootstrap,
IPropertyMap {
    @NotNull
    public String getGroupName();

    public int getServiceNumber();

    @NotNull
    public UUID getUniqueId();

    @NotNull
    public ServiceType getServiceType();

    @NotNull
    public ServiceVersion getServiceVersion();

    @NotNull
    public String getTemplateName();

    @NotNull
    public ITemplate getTemplate();

    @NotNull
    public ICloudServiceGroup getServiceGroup();

    public int getMinimumMemory();

    public int getMaxMemory();

    public int getUsedMemory();

    @Nullable
    public String getWrapperName();

    @NotNull
    public IWrapperInfo getWrapper();

    @NotNull
    public String getHost();

    public int getPort();

    public boolean isStatic();

    public boolean isForceCopyTemplates();

    public double getOnlinePercentage();

    @Override
    @NotNull
    public String getName();

    @NotNull
    public ICommunicationPromise<List<SimpleCloudPlayer>> getOnlinePlayers();

    @NotNull
    public ICommunicationPromise<List<ICloudPlayer>> getOnlinePlayersDirect();

    public boolean isOnline();

    public boolean isFull();

    @Override
    @NotNull
    public NetworkComponentType getNetworkComponentType();

    @NotNull
    public ICommunicationPromise<CloudServiceStartingEvent> createStartingPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceConnectedEvent> createConnectedPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceStartedEvent> createStartedPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceUnregisteredEvent> createClosedPromise();

    public boolean isLobby();

    public boolean isProxy();

    @NotNull
    public ICommunicationPromise<Unit> update();

    @NotNull
    public ICommunicationPromise<Unit> copy(@NotNull String var1);

    public boolean isStartingOrVisible();

    @Override
    public boolean isActive();

    @Override
    @NotNull
    public ICommunicationPromise<Unit> start();

    @Override
    @NotNull
    public ICommunicationPromise<Unit> shutdown();

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nICloudService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ICloudService.kt\neu/thesimplecloud/api/service/ICloudService$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AdvancedListenerExtension.kt\neu/thesimplecloud/api/listenerextension/AdvancedListenerExtensionKt\n*L\n1#1,271:1\n1#2:272\n27#3,5:273\n27#3,5:278\n27#3,5:283\n27#3,5:288\n*S KotlinDebug\n*F\n+ 1 ICloudService.kt\neu/thesimplecloud/api/service/ICloudService$DefaultImpls\n*L\n197#1:273,5\n208#1:278,5\n219#1:283,5\n230#1:288,5\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static ServiceType getServiceType(@NotNull ICloudService $this) {
            return $this.getServiceGroup().getServiceType();
        }

        @NotNull
        public static ITemplate getTemplate(@NotNull ICloudService $this) {
            ITemplate iTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName($this.getTemplateName());
            if (iTemplate == null) {
                throw new IllegalStateException("Can't find the template of an registered service (templates: " + CollectionsKt.joinToString$default(CloudAPI.Companion.getInstance().getTemplateManager().getAllCachedObjects(), null, null, null, 0, null, getTemplate.1.INSTANCE, 31, null) + ')');
            }
            return iTemplate;
        }

        @NotNull
        public static ICloudServiceGroup getServiceGroup(@NotNull ICloudService $this) {
            ICloudServiceGroup iCloudServiceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName($this.getGroupName());
            if (iCloudServiceGroup == null) {
                throw new IllegalStateException("Can't find the service group of an registered service");
            }
            return iCloudServiceGroup;
        }

        @NotNull
        public static IWrapperInfo getWrapper(@NotNull ICloudService $this) {
            Object object;
            block3: {
                block2: {
                    object = $this.getWrapperName();
                    if (object == null) break block2;
                    String it = object;
                    boolean bl = false;
                    IWrapperInfo iWrapperInfo = CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByName(it);
                    object = iWrapperInfo;
                    if (iWrapperInfo != null) break block3;
                }
                throw new IllegalStateException("Can't find the wrapper where the service " + $this.getName() + " is running on. Wrapper-Name: " + $this.getWrapperName());
            }
            return object;
        }

        @NotNull
        public static String getHost(@NotNull ICloudService $this) {
            return $this.getWrapper().getHost();
        }

        public static boolean isStatic(@NotNull ICloudService $this) {
            return $this.getServiceGroup().isStatic();
        }

        public static boolean isForceCopyTemplates(@NotNull ICloudService $this) {
            return $this.getServiceGroup().isForceCopyTemplates();
        }

        public static double getOnlinePercentage(@NotNull ICloudService $this) {
            return (double)$this.getOnlineCount() / (double)$this.getMaxPlayers();
        }

        @NotNull
        public static String getName(@NotNull ICloudService $this) {
            return $this.getGroupName() + '-' + $this.getServiceNumber();
        }

        @NotNull
        public static ICommunicationPromise<List<SimpleCloudPlayer>> getOnlinePlayers(@NotNull ICloudService $this) {
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().getPlayersConnectedToService($this);
        }

        @NotNull
        public static ICommunicationPromise<List<ICloudPlayer>> getOnlinePlayersDirect(@NotNull ICloudService $this) {
            return CommunicationPromiseExtensionKt.flatten$default($this.getOnlinePlayers().then(getOnlinePlayersDirect.1.INSTANCE), 0L, false, 3, null);
        }

        public static boolean isOnline(@NotNull ICloudService $this) {
            return $this.isServiceJoinable();
        }

        public static boolean isFull(@NotNull ICloudService $this) {
            return $this.getOnlineCount() >= $this.getMaxPlayers();
        }

        @NotNull
        public static NetworkComponentType getNetworkComponentType(@NotNull ICloudService $this) {
            return NetworkComponentType.SERVICE;
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceStartingEvent> createStartingPromise(@NotNull ICloudService $this) {
            if ($this.isActive() || $this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceStartingEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceStartingEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceStartingEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceStartingEvent it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceConnectedEvent> createConnectedPromise(@NotNull ICloudService $this) {
            if ($this.isAuthenticated() || $this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceConnectedEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceConnectedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceConnectedEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceConnectedEvent it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceStartedEvent> createStartedPromise(@NotNull ICloudService $this) {
            if ($this.isOnline() || $this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceStartedEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceStartedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceStartedEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceStartedEvent it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceUnregisteredEvent> createClosedPromise(@NotNull ICloudService $this) {
            if ($this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceUnregisteredEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceUnregisteredEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceUnregisteredEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CloudServiceUnregisteredEvent it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getCloudService() == this.this$0;
                }
            }).toPromise();
        }

        public static boolean isLobby(@NotNull ICloudService $this) {
            return $this.getServiceType() == ServiceType.LOBBY;
        }

        public static boolean isProxy(@NotNull ICloudService $this) {
            return $this.getServiceType() == ServiceType.PROXY;
        }

        @NotNull
        public static ICommunicationPromise<Unit> update(@NotNull ICloudService $this) {
            return ((ICloudServiceUpdater)$this.getUpdater()).update();
        }

        @NotNull
        public static ICommunicationPromise<Unit> copy(@NotNull ICloudService $this, @NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            return CloudAPI.Companion.getInstance().getCloudServiceManager().copyService($this, path);
        }

        public static boolean isStartingOrVisible(@NotNull ICloudService $this) {
            return $this.getState() == ServiceState.STARTING || $this.getState() == ServiceState.VISIBLE;
        }

        public static boolean isActive(@NotNull ICloudService $this) {
            return $this.getState() != ServiceState.PREPARED && $this.getState() != ServiceState.CLOSED;
        }

        @NotNull
        public static ICommunicationPromise<Unit> start(@NotNull ICloudService $this) {
            return CloudAPI.Companion.getInstance().getCloudServiceManager().startService($this);
        }

        @NotNull
        public static ICommunicationPromise<Unit> shutdown(@NotNull ICloudService $this) {
            return CloudAPI.Companion.getInstance().getCloudServiceManager().stopService($this);
        }

        public static boolean isServiceJoinable(@NotNull ICloudService $this) {
            return ICloudServiceVariables.DefaultImpls.isServiceJoinable($this);
        }

        @NotNull
        public static NetworkComponentReference toNetworkComponentReference(@NotNull ICloudService $this) {
            return INetworkComponent.DefaultImpls.toNetworkComponentReference($this);
        }

        public static void executeCommand(@NotNull ICloudService $this, @NotNull String command2) {
            Intrinsics.checkNotNullParameter(command2, "command");
            INetworkComponent.DefaultImpls.executeCommand($this, command2);
        }

        @Nullable
        public static <T> IProperty<T> getProperty(@NotNull ICloudService $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return IPropertyMap.DefaultImpls.getProperty($this, name);
        }

        public static boolean hasProperty(@NotNull ICloudService $this, @NotNull String property) {
            Intrinsics.checkNotNullParameter(property, "property");
            return IPropertyMap.DefaultImpls.hasProperty($this, property);
        }

        @NotNull
        public static ConcurrentMap<String, IProperty<?>> getMapWithNewestProperties(@NotNull ICloudService $this, @NotNull Map<String, ? extends IProperty<?>> compareMap) {
            Intrinsics.checkNotNullParameter(compareMap, "compareMap");
            return IPropertyMap.DefaultImpls.getMapWithNewestProperties($this, compareMap);
        }
    }
}

