/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service.version.loader;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.service.version.ServiceVersion;
import eu.thesimplecloud.api.service.version.loader.IServiceVersionLoader;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.runner.utils.WebContentLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Leu/thesimplecloud/api/service/version/loader/ServiceVersionWebLoader;", "Leu/thesimplecloud/api/service/version/loader/IServiceVersionLoader;", "()V", "file", "Ljava/io/File;", "loadFromFile", "", "Leu/thesimplecloud/api/service/version/ServiceVersion;", "loadVersions", "processWebContent", "contentString", "", "simplecloud-api"})
public final class ServiceVersionWebLoader
implements IServiceVersionLoader {
    @NotNull
    private final File file = new File(DirectoryPaths.Companion.getPaths().getStoragePath() + "onlineServiceVersions.json");

    @Override
    @NotNull
    public List<ServiceVersion> loadVersions() {
        String string = this.getClass().getPackage().getImplementationVersion();
        Intrinsics.checkNotNullExpressionValue(string, "this::class.java.`package`.implementationVersion");
        String string2 = string;
        int n = 0;
        int n2 = 3;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String version = string3;
        String contentString = new WebContentLoader().loadContent("https://api.thesimplecloud.eu/versions?implementationVersion[$lte]=" + version);
        return contentString == null ? this.loadFromFile() : this.processWebContent(contentString);
    }

    private final List<ServiceVersion> loadFromFile() {
        if (!this.file.exists()) {
            throw new FileNotFoundException("File " + this.file.getAbsolutePath() + " does not exist and the web server to load the service versions from is not available");
        }
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default(JsonLib.Companion, this.file, null, 2, null);
        Intrinsics.checkNotNull(jsonLib);
        return ArraysKt.toList((Object[])jsonLib.getObject(ServiceVersion[].class));
    }

    private final List<ServiceVersion> processWebContent(String contentString) {
        JsonLib jsonLib = JsonLib.Companion.fromJsonString$default(JsonLib.Companion, contentString, null, 2, null);
        jsonLib.saveAsFile(this.file);
        return ArraysKt.toList((Object[])jsonLib.getObject(ServiceVersion[].class));
    }
}

