/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.servicegroup;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.service.start.configuration.IServiceStartConfiguration;
import eu.thesimplecloud.api.service.start.configuration.ServiceStartConfiguration;
import eu.thesimplecloud.api.service.start.future.IServiceStartPromise;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroupUpdater;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroupVariables;
import eu.thesimplecloud.api.template.ITemplate;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\rH&J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0010H&J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\u001e"}, d2={"Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "Leu/thesimplecloud/api/cachelist/value/ICacheValue;", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroupUpdater;", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroupVariables;", "createStartConfiguration", "Leu/thesimplecloud/api/service/start/configuration/IServiceStartConfiguration;", "delete", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "getAllServices", "", "Leu/thesimplecloud/api/service/ICloudService;", "getJavaCommandName", "", "getName", "getOnlinePlayerCount", "", "getOnlineServiceCount", "getRegisteredServiceCount", "getServiceType", "Leu/thesimplecloud/api/service/ServiceType;", "getStartPriority", "getTemplate", "Leu/thesimplecloud/api/template/ITemplate;", "isStatic", "", "shutdownAllServices", "startNewService", "Leu/thesimplecloud/api/service/start/future/IServiceStartPromise;", "update", "simplecloud-api"})
public interface ICloudServiceGroup
extends ICacheValue<ICloudServiceGroupUpdater>,
ICloudServiceGroupVariables {
    @NotNull
    public String getName();

    @NotNull
    public ServiceType getServiceType();

    @NotNull
    public ITemplate getTemplate();

    public boolean isStatic();

    @NotNull
    public String getJavaCommandName();

    public int getStartPriority();

    @NotNull
    public IServiceStartPromise startNewService();

    @NotNull
    public IServiceStartConfiguration createStartConfiguration();

    @NotNull
    public List<ICloudService> getAllServices();

    public int getOnlinePlayerCount();

    public int getRegisteredServiceCount();

    public int getOnlineServiceCount();

    public void shutdownAllServices();

    @NotNull
    public ICommunicationPromise<Unit> delete() throws IllegalStateException;

    @NotNull
    public ICommunicationPromise<Unit> update();

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nICloudServiceGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ICloudServiceGroup.kt\neu/thesimplecloud/api/servicegroup/ICloudServiceGroup$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n2976#2,5:125\n766#2:130\n857#2,2:131\n1855#2,2:133\n*S KotlinDebug\n*F\n+ 1 ICloudServiceGroup.kt\neu/thesimplecloud/api/servicegroup/ICloudServiceGroup$DefaultImpls\n*L\n95#1:125,5\n105#1:130\n105#1:131,2\n110#1:133,2\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static ITemplate getTemplate(@NotNull ICloudServiceGroup $this) {
            ITemplate iTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName($this.getTemplateName());
            if (iTemplate == null) {
                throw new IllegalStateException("Can't find the template of an registered group (group: " + $this.getName() + " templates: " + CollectionsKt.joinToString$default(CloudAPI.Companion.getInstance().getTemplateManager().getAllCachedObjects(), null, null, null, 0, null, getTemplate.1.INSTANCE, 31, null) + ')');
            }
            return iTemplate;
        }

        @NotNull
        public static IServiceStartPromise startNewService(@NotNull ICloudServiceGroup $this) {
            return $this.createStartConfiguration().startService();
        }

        @NotNull
        public static IServiceStartConfiguration createStartConfiguration(@NotNull ICloudServiceGroup $this) {
            return new ServiceStartConfiguration($this);
        }

        @NotNull
        public static List<ICloudService> getAllServices(@NotNull ICloudServiceGroup $this) {
            return CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServicesByGroupName($this.getName());
        }

        /*
         * WARNING - void declaration
         */
        public static int getOnlinePlayerCount(@NotNull ICloudServiceGroup $this) {
            void var3_3;
            Iterable $this$sumBy$iv = $this.getAllServices();
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                ICloudService iCloudService = (ICloudService)element$iv;
                int n = sum$iv;
                boolean bl = false;
                int n2 = it.getOnlineCount();
                sum$iv = n + n2;
            }
            return (int)var3_3;
        }

        public static int getRegisteredServiceCount(@NotNull ICloudServiceGroup $this) {
            return $this.getAllServices().size();
        }

        /*
         * WARNING - void declaration
         */
        public static int getOnlineServiceCount(@NotNull ICloudServiceGroup $this) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this.getAllServices();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!it.isOnline()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return ((List)destination$iv$iv).size();
        }

        public static void shutdownAllServices(@NotNull ICloudServiceGroup $this) {
            Iterable $this$forEach$iv = $this.getAllServices();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ICloudService it = (ICloudService)element$iv;
                boolean bl = false;
                it.shutdown();
            }
        }

        @NotNull
        public static ICommunicationPromise<Unit> delete(@NotNull ICloudServiceGroup $this) throws IllegalStateException {
            return ICacheList.DefaultImpls.delete$default(CloudAPI.Companion.getInstance().getCloudServiceGroupManager(), $this, false, 2, null);
        }

        @NotNull
        public static ICommunicationPromise<Unit> update(@NotNull ICloudServiceGroup $this) {
            return ((ICloudServiceGroupUpdater)$this.getUpdater()).update();
        }
    }
}

