/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.client;

import eu.thesimplecloud.clientserverapi.client.ClientConnection;
import eu.thesimplecloud.clientserverapi.client.INettyClient;
import eu.thesimplecloud.clientserverapi.client.NettyClientHandler;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.AbstractCommunicationBootstrap;
import eu.thesimplecloud.clientserverapi.lib.codec.ProtobufVarint32FrameDecoder;
import eu.thesimplecloud.clientserverapi.lib.codec.ProtobufVarint32LengthFieldPrepender;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.defaultpackets.PacketIOConnectionWillClose;
import eu.thesimplecloud.clientserverapi.lib.handler.DefaultConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.packet.PacketDecoder;
import eu.thesimplecloud.clientserverapi.lib.packet.PacketEncoder;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Leu/thesimplecloud/clientserverapi/client/NettyClient;", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/AbstractCommunicationBootstrap;", "Leu/thesimplecloud/clientserverapi/client/INettyClient;", "host", "", "port", "", "connectionHandler", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "(Ljava/lang/String;ILeu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;)V", "clientConnection", "Leu/thesimplecloud/clientserverapi/client/ClientConnection;", "running", "", "workerGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "getConnection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "isActive", "shutdown", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "start", "clientserverapi"})
@SourceDebugExtension(value={"SMAP\nNettyClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyClient.kt\neu/thesimplecloud/clientserverapi/client/NettyClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class NettyClient
extends AbstractCommunicationBootstrap
implements INettyClient {
    @Nullable
    private NioEventLoopGroup workerGroup;
    @NotNull
    private final ClientConnection clientConnection;
    private boolean running;

    public NettyClient(@NotNull String host, int port, @NotNull IConnectionHandler connectionHandler) {
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(connectionHandler, "connectionHandler");
        super(host, port, connectionHandler);
        this.clientConnection = new ClientConnection(this);
    }

    public /* synthetic */ NettyClient(String string, int n, IConnectionHandler iConnectionHandler, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            iConnectionHandler = new DefaultConnectionHandler();
        }
        this(string, n, iConnectionHandler);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> start() {
        if (!(!this.running)) {
            boolean $i$a$-check-NettyClient$start$22 = false;
            String $i$a$-check-NettyClient$start$22 = "Cannot start client while it is running";
            throw new IllegalStateException($i$a$-check-NettyClient$start$22.toString());
        }
        this.running = true;
        String[] stringArray = new String[]{"eu.thesimplecloud.clientserverapi.lib.defaultpackets"};
        this.addPacketsByPackage(stringArray);
        CommunicationPromise startedPromise = new CommunicationPromise(false);
        NettyClient instance = this;
        this.workerGroup = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.workerGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler(new ChannelInitializer<Channel>(instance, this){
            final /* synthetic */ NettyClient $instance;
            final /* synthetic */ NettyClient this$0;
            {
                this.$instance = $instance;
                this.this$0 = $receiver;
            }

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkNotNullParameter(channel, "channel");
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 5));
                pipeline.addLast("frameDecoder", (ChannelHandler)new ProtobufVarint32FrameDecoder());
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new PacketDecoder(this.$instance, this.this$0.getPacketManager())};
                pipeline.addLast(channelHandlerArray);
                pipeline.addLast("frameEncoder", (ChannelHandler)new ProtobufVarint32LengthFieldPrepender());
                channelHandlerArray = new ChannelHandler[]{new PacketEncoder(this.$instance)};
                pipeline.addLast(channelHandlerArray);
                channelHandlerArray = new ChannelHandler[]{new NettyClientHandler(this.$instance, this.this$0.getConnectionHandler())};
                pipeline.addLast(channelHandlerArray);
                channelHandlerArray = new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)};
                pipeline.addLast(channelHandlerArray);
            }
        });
        Channel channel = bootstrap.connect(this.getHost(), this.getPort()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)arg_0 -> NettyClient.start$lambda$1(startedPromise, this, arg_0))).channel();
        Intrinsics.checkNotNull(channel);
        this.clientConnection.setChannel(channel);
        return startedPromise;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> shutdown() {
        CommunicationPromise<Unit> shutdownPromise;
        block2: {
            shutdownPromise = new CommunicationPromise<Unit>(false);
            if (this.clientConnection.getChannel() == null) {
                shutdownPromise.trySuccess(Unit.INSTANCE);
            }
            IPacketSender.DefaultImpls.sendUnitQuery$default(this.clientConnection, new PacketIOConnectionWillClose(), 0L, 2, null);
            NioEventLoopGroup nioEventLoopGroup = this.workerGroup;
            if (nioEventLoopGroup != null) {
                nioEventLoopGroup.shutdownGracefully();
            }
            this.running = false;
            Object object = this.clientConnection.getChannel();
            if (object == null || (object = object.closeFuture()) == null) break block2;
            object.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)arg_0 -> NettyClient.shutdown$lambda$2(shutdownPromise, arg_0)));
        }
        return shutdownPromise;
    }

    @Override
    public boolean isActive() {
        return this.running;
    }

    @Override
    @NotNull
    public IConnection getConnection() {
        return this.clientConnection;
    }

    private static final void start$lambda$1(CommunicationPromise $startedPromise, NettyClient this$0, Future future) {
        Intrinsics.checkNotNullParameter($startedPromise, "$startedPromise");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (future.isSuccess()) {
            $startedPromise.trySuccess(Unit.INSTANCE);
        } else {
            Throwable throwable = future.cause();
            Intrinsics.checkNotNullExpressionValue(throwable, "cause(...)");
            $startedPromise.tryFailure(throwable);
            this$0.shutdown();
        }
    }

    private static final void shutdown$lambda$2(CommunicationPromise $shutdownPromise, Future it) {
        Intrinsics.checkNotNullParameter($shutdownPromise, "$shutdownPromise");
        if (it.isSuccess()) {
            $shutdownPromise.trySuccess(Unit.INSTANCE);
        } else {
            Throwable throwable = it.cause();
            Intrinsics.checkNotNullExpressionValue(throwable, "cause(...)");
            $shutdownPromise.tryFailure(throwable);
        }
    }
}

