/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.directorywatch;

import eu.thesimplecloud.clientserverapi.lib.directorywatch.IDirectoryWatch;
import eu.thesimplecloud.clientserverapi.lib.directorywatch.IDirectoryWatchListener;
import eu.thesimplecloud.clientserverapi.lib.directorywatch.IDirectoryWatchManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0006\u0010\u001a\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u000ej\b\u0012\u0004\u0012\u00020\u0001`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Leu/thesimplecloud/clientserverapi/lib/directorywatch/DirectoryWatch;", "Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatch;", "directoryWatchManager", "Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchManager;", "directory", "Ljava/io/File;", "(Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchManager;Ljava/io/File;)V", "lastTickFiles", "", "listeners", "Ljava/util/ArrayList;", "Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchListener;", "Lkotlin/collections/ArrayList;", "subDirectoryWatches", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addWatchListener", "", "watchListener", "createSubDirectoryWatch", "file", "getAllCurrentFiles", "getAllListenersExceptFirst", "getDirectory", "removeSubDirectoryWatch", "removeWatchListener", "tick", "clientserverapi"})
@SourceDebugExtension(value={"SMAP\nDirectoryWatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryWatch.kt\neu/thesimplecloud/clientserverapi/lib/directorywatch/DirectoryWatch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1#2:104\n3792#3:105\n4307#3,2:106\n1855#4,2:108\n1855#4,2:110\n766#4:112\n857#4,2:113\n1855#4,2:115\n1855#4,2:117\n1855#4,2:119\n288#4,2:121\n1855#4,2:123\n1855#4,2:125\n*S KotlinDebug\n*F\n+ 1 DirectoryWatch.kt\neu/thesimplecloud/clientserverapi/lib/directorywatch/DirectoryWatch\n*L\n56#1:105\n56#1:106,2\n56#1:108,2\n40#1:110,2\n41#1:112\n41#1:113,2\n42#1:115,2\n45#1:117,2\n80#1:119,2\n84#1:121,2\n91#1:123,2\n96#1:125,2\n*E\n"})
public final class DirectoryWatch
implements IDirectoryWatch {
    @NotNull
    private final IDirectoryWatchManager directoryWatchManager;
    @NotNull
    private final File directory;
    @NotNull
    private final HashSet<IDirectoryWatch> subDirectoryWatches;
    @NotNull
    private final ArrayList<IDirectoryWatchListener> listeners;
    @NotNull
    private List<? extends File> lastTickFiles;

    /*
     * WARNING - void declaration
     */
    public DirectoryWatch(@NotNull IDirectoryWatchManager directoryWatchManager, @NotNull File directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(directoryWatchManager, "directoryWatchManager");
        Intrinsics.checkNotNullParameter(directory, "directory");
        this.directoryWatchManager = directoryWatchManager;
        this.directory = directory;
        this.subDirectoryWatches = new HashSet();
        this.listeners = new ArrayList();
        this.lastTickFiles = this.getAllCurrentFiles();
        if (!this.directory.isDirectory()) {
            boolean $i$a$-require-DirectoryWatch$22 = false;
            String $i$a$-require-DirectoryWatch$22 = "Specified file must be a directory";
            throw new IllegalArgumentException($i$a$-require-DirectoryWatch$22.toString());
        }
        File[] fileArray = this.directory.listFiles();
        Intrinsics.checkNotNullExpressionValue(fileArray, "listFiles(...)");
        Object[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.createSubDirectoryWatch(it);
        }
        this.addWatchListener(new IDirectoryWatchListener(){

            @Override
            public void fileCreated(@NotNull File file) {
                Intrinsics.checkNotNullParameter(file, "file");
                if (file.isDirectory()) {
                    this.createSubDirectoryWatch(file);
                }
            }

            @Override
            public void fileModified(@NotNull File file) {
                Intrinsics.checkNotNullParameter(file, "file");
            }

            @Override
            public void fileDeleted(@NotNull File file) {
                Intrinsics.checkNotNullParameter(file, "file");
                this.removeSubDirectoryWatch(file);
            }
        });
    }

    public final void tick() {
        Iterator $this$filterTo$iv$iv;
        Object $this$forEach$iv;
        Object element$iv2;
        List<File> allCurrentFiles = this.getAllCurrentFiles();
        List addedFiles = CollectionsKt.toMutableList((Collection)allCurrentFiles);
        addedFiles.removeAll((Collection)this.lastTickFiles);
        Iterable $this$forEach$iv2 = addedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            File file = (File)element$iv2;
            boolean bl = false;
            $this$forEach$iv = this.listeners;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv3 = iterator2.next();
                IDirectoryWatchListener it2 = (IDirectoryWatchListener)element$iv3;
                boolean bl2 = false;
                it2.fileCreated(file);
            }
        }
        Iterable $this$filter$iv = this.lastTickFiles;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        $this$forEach$iv = $this$filterTo$iv$iv.iterator();
        while ($this$forEach$iv.hasNext()) {
            Object element$iv$iv = $this$forEach$iv.next();
            File it = (File)element$iv$iv;
            boolean bl = false;
            long it2 = System.currentTimeMillis() - it.lastModified();
            boolean bl3 = 200L <= it2 ? it2 < 400L : false;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiedFiles = (List)destination$iv$iv;
        Iterable $this$forEach$iv3 = modifiedFiles;
        boolean $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv3) {
            File file = (File)element$iv4;
            boolean bl = false;
            Iterable $this$forEach$iv4 = this.listeners;
            boolean $i$f$forEach4 = false;
            for (Object element$iv5 : $this$forEach$iv4) {
                IDirectoryWatchListener it = (IDirectoryWatchListener)element$iv5;
                boolean bl4 = false;
                it.fileModified(file);
            }
        }
        List removedFiles = CollectionsKt.toMutableList((Collection)this.lastTickFiles);
        removedFiles.removeAll((Collection)allCurrentFiles);
        Iterable $this$forEach$iv5 = removedFiles;
        boolean $i$f$forEach5 = false;
        for (Object element$iv6 : $this$forEach$iv5) {
            File file = (File)element$iv6;
            boolean bl = false;
            Iterable $this$forEach$iv6 = this.listeners;
            boolean $i$f$forEach6 = false;
            for (Object element$iv7 : $this$forEach$iv6) {
                IDirectoryWatchListener it = (IDirectoryWatchListener)element$iv7;
                boolean bl5 = false;
                it.fileDeleted(file);
            }
        }
        this.lastTickFiles = this.getAllCurrentFiles();
    }

    private final List<File> getAllCurrentFiles() {
        Object object = this.directory.listFiles();
        if (object == null || (object = ArraysKt.toList(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final void createSubDirectoryWatch(File file) {
        IDirectoryWatch directoryWatch = this.directoryWatchManager.createDirectoryWatch(file);
        this.subDirectoryWatches.add(directoryWatch);
        Iterable $this$forEach$iv = this.getAllListenersExceptFirst();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDirectoryWatchListener it = (IDirectoryWatchListener)element$iv;
            boolean bl = false;
            directoryWatch.addWatchListener(it);
        }
    }

    private final void removeSubDirectoryWatch(File file) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.subDirectoryWatches;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IDirectoryWatch it = (IDirectoryWatch)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getDirectory(), file)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        IDirectoryWatch iDirectoryWatch = v0;
        if (iDirectoryWatch == null) {
            return;
        }
        IDirectoryWatch subDirectoryWatch = iDirectoryWatch;
        this.subDirectoryWatches.remove(subDirectoryWatch);
        this.directoryWatchManager.deleteDirectoryWatch(subDirectoryWatch);
    }

    @Override
    public void addWatchListener(@NotNull IDirectoryWatchListener watchListener) {
        Intrinsics.checkNotNullParameter(watchListener, "watchListener");
        this.listeners.add(watchListener);
        Iterable $this$forEach$iv = this.subDirectoryWatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDirectoryWatch it = (IDirectoryWatch)element$iv;
            boolean bl = false;
            it.addWatchListener(watchListener);
        }
    }

    @Override
    public void removeWatchListener(@NotNull IDirectoryWatchListener watchListener) {
        Intrinsics.checkNotNullParameter(watchListener, "watchListener");
        this.listeners.remove(watchListener);
        Iterable $this$forEach$iv = this.subDirectoryWatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDirectoryWatch it = (IDirectoryWatch)element$iv;
            boolean bl = false;
            it.removeWatchListener(watchListener);
        }
    }

    @NotNull
    public final List<IDirectoryWatchListener> getAllListenersExceptFirst() {
        return CollectionsKt.drop((Iterable)this.listeners, 1);
    }

    @Override
    @NotNull
    public File getDirectory() {
        return this.directory;
    }
}

