/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.filetransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0005\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Leu/thesimplecloud/clientserverapi/lib/filetransfer/TransferFile;", "", "uuid", "Ljava/util/UUID;", "lastModified", "", "savePath", "", "(Ljava/util/UUID;JLjava/lang/String;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "getLastModified", "()J", "getUuid", "()Ljava/util/UUID;", "addBytes", "", "byteArray", "", "", "([Ljava/lang/Byte;)V", "setLasModified", "clientserverapi"})
public final class TransferFile {
    @NotNull
    private final UUID uuid;
    private final long lastModified;
    @NotNull
    private final File file;

    public TransferFile(@NotNull UUID uuid, long lastModified, @NotNull String savePath) {
        block0: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Intrinsics.checkNotNullParameter(savePath, "savePath");
            this.uuid = uuid;
            this.lastModified = lastModified;
            this.file = new File(savePath);
            this.file.delete();
            File file = this.file.getParentFile();
            if (file == null) break block0;
            file.mkdirs();
        }
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final void addBytes(@NotNull Byte[] byteArray) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        while (true) {
            try {
                FileUtils.writeByteArrayToFile(this.file, ArraysKt.toByteArray(byteArray), true);
            }
            catch (FileNotFoundException e) {
                Thread.sleep(3L);
                continue;
            }
            break;
        }
    }

    public final void setLasModified() {
        this.file.setLastModified(this.lastModified);
    }
}

