/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.filetransfer.directory;

import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.directorywatch.IDirectoryWatchManager;
import eu.thesimplecloud.clientserverapi.lib.filetransfer.directory.DirectorySync;
import eu.thesimplecloud.clientserverapi.lib.filetransfer.directory.IDirectorySync;
import eu.thesimplecloud.clientserverapi.lib.filetransfer.directory.IDirectorySyncManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Leu/thesimplecloud/clientserverapi/lib/filetransfer/directory/DirectorySyncManager;", "Leu/thesimplecloud/clientserverapi/lib/filetransfer/directory/IDirectorySyncManager;", "directoryWatchManager", "Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchManager;", "(Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchManager;)V", "directorySyncList", "", "Leu/thesimplecloud/clientserverapi/lib/filetransfer/directory/DirectorySync;", "<set-?>", "Ljava/io/File;", "tmpZipDir", "getTmpZipDir", "()Ljava/io/File;", "createDirectorySync", "Leu/thesimplecloud/clientserverapi/lib/filetransfer/directory/IDirectorySync;", "directory", "toDirectory", "", "deleteDirectorySync", "", "getDirectorySync", "removeFromDirectorySyncs", "connection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "setTmpZipDirectory", "clientserverapi"})
@SourceDebugExtension(value={"SMAP\nDirectorySyncManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectorySyncManager.kt\neu/thesimplecloud/clientserverapi/lib/filetransfer/directory/DirectorySyncManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n288#2,2:59\n1855#2,2:61\n*S KotlinDebug\n*F\n+ 1 DirectorySyncManager.kt\neu/thesimplecloud/clientserverapi/lib/filetransfer/directory/DirectorySyncManager\n*L\n48#1:59,2\n56#1:61,2\n*E\n"})
public final class DirectorySyncManager
implements IDirectorySyncManager {
    @NotNull
    private final IDirectoryWatchManager directoryWatchManager;
    @NotNull
    private final List<DirectorySync> directorySyncList;
    @NotNull
    private volatile File tmpZipDir;

    public DirectorySyncManager(@NotNull IDirectoryWatchManager directoryWatchManager) {
        Intrinsics.checkNotNullParameter(directoryWatchManager, "directoryWatchManager");
        this.directoryWatchManager = directoryWatchManager;
        this.directorySyncList = new ArrayList();
        this.tmpZipDir = new File("tmpZip/");
    }

    @NotNull
    public final File getTmpZipDir() {
        return this.tmpZipDir;
    }

    @Override
    @NotNull
    public IDirectorySync createDirectorySync(@NotNull File directory, @NotNull String toDirectory) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(toDirectory, "toDirectory");
        DirectorySync directorySync = new DirectorySync(directory, toDirectory, this.tmpZipDir, this.directoryWatchManager.createDirectoryWatch(directory));
        this.directorySyncList.add(directorySync);
        return directorySync;
    }

    @Override
    public void deleteDirectorySync(@NotNull File directory) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        IDirectorySync directorySync = this.getDirectorySync(directory);
        if (!(directorySync instanceof DirectorySync)) {
            return;
        }
        this.directorySyncList.remove(directorySync);
    }

    @Override
    @Nullable
    public IDirectorySync getDirectorySync(@NotNull File directory) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(directory, "directory");
            Iterable $this$firstOrNull$iv = this.directorySyncList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DirectorySync it = (DirectorySync)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getDirectory(), directory)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void setTmpZipDirectory(@NotNull File tmpZipDir) {
        Intrinsics.checkNotNullParameter(tmpZipDir, "tmpZipDir");
        if (!((Collection)this.directorySyncList).isEmpty()) {
            throw new IllegalStateException("There must be no registered DirectorySyncs when calling this");
        }
        this.tmpZipDir = tmpZipDir;
    }

    public final void removeFromDirectorySyncs(@NotNull IConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Iterable $this$forEach$iv = this.directorySyncList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DirectorySync it = (DirectorySync)element$iv;
            boolean bl = false;
            it.syncNoLonger(connection);
        }
    }
}

