/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.packetresponse;

import com.google.common.collect.Maps;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.clientserverapi.lib.packetresponse.IPacketResponseManager;
import eu.thesimplecloud.clientserverapi.lib.packetresponse.WrappedResponseHandler;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016Rn\u0010\u0003\u001ab\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\b \u0006*\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00070\u0007 \u0006*0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\b \u0006*\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/clientserverapi/lib/packetresponse/PacketResponseManager;", "Leu/thesimplecloud/clientserverapi/lib/packetresponse/IPacketResponseManager;", "()V", "packetResponseHandlers", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "Leu/thesimplecloud/clientserverapi/lib/packetresponse/WrappedResponseHandler;", "", "getResponseHandler", "packetUniqueId", "incomingPacket", "", "wrappedPacket", "Leu/thesimplecloud/clientserverapi/lib/packet/WrappedPacket;", "registerResponseHandler", "wrappedResponseHandler", "clientserverapi"})
public final class PacketResponseManager
implements IPacketResponseManager {
    private final ConcurrentMap<UUID, WrappedResponseHandler<? extends Object>> packetResponseHandlers = Maps.newConcurrentMap();

    @Override
    public synchronized void registerResponseHandler(@NotNull UUID packetUniqueId, @NotNull WrappedResponseHandler<? extends Object> wrappedResponseHandler) {
        Intrinsics.checkNotNullParameter(packetUniqueId, "packetUniqueId");
        Intrinsics.checkNotNullParameter(wrappedResponseHandler, "wrappedResponseHandler");
        ConcurrentMap<UUID, WrappedResponseHandler<? extends Object>> concurrentMap = this.packetResponseHandlers;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "packetResponseHandlers");
        ((Map)concurrentMap).put(packetUniqueId, wrappedResponseHandler);
    }

    @Override
    @Nullable
    public synchronized WrappedResponseHandler<? extends Object> getResponseHandler(@NotNull UUID packetUniqueId) {
        Intrinsics.checkNotNullParameter(packetUniqueId, "packetUniqueId");
        return (WrappedResponseHandler)this.packetResponseHandlers.get(packetUniqueId);
    }

    @Override
    public synchronized void incomingPacket(@NotNull WrappedPacket wrappedPacket) {
        Intrinsics.checkNotNullParameter(wrappedPacket, "wrappedPacket");
        WrappedResponseHandler wrappedResponseHandler = (WrappedResponseHandler)this.packetResponseHandlers.remove(wrappedPacket.getPacketData().getUniqueId());
        if (wrappedResponseHandler == null) {
            throw new IllegalStateException("Incoming: No response handler was available for packet by id " + wrappedPacket.getPacketData().getUniqueId());
        }
        Object response = wrappedResponseHandler.getPacketResponseHandler().handleResponse(wrappedPacket.getPacket());
        ICommunicationPromise packetPromise = wrappedResponseHandler.getCommunicationPromise();
        if (response instanceof Throwable) {
            packetPromise.tryFailure((Throwable)response);
        } else {
            packetPromise.trySuccess(response);
        }
    }
}

