/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Leu/thesimplecloud/clientserverapi/lib/util/ZipUtils;", "", "()V", "Companion", "clientserverapi"})
public final class ZipUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u0005\u001a\u00020\u00042\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\b\b\u0002\u0010\u0012\u001a\u00020\b\u00a8\u0006\u0013"}, d2={"Leu/thesimplecloud/clientserverapi/lib/util/ZipUtils$Companion;", "", "()V", "unzipDir", "", "zipFile", "Ljava/io/File;", "dirToUnzip", "", "zipDir", "fileToZip", "zipDirFiles", "files", "", "fileName", "zipOut", "Ljava/util/zip/ZipOutputStream;", "zipFiles", "subtractRelativePath", "clientserverapi"})
    @SourceDebugExtension(value={"SMAP\nZipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtils.kt\neu/thesimplecloud/clientserverapi/lib/util/ZipUtils$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void zipFiles(@NotNull File zipFile, @NotNull List<? extends File> files, @NotNull String subtractRelativePath) {
            Intrinsics.checkNotNullParameter(zipFile, "zipFile");
            Intrinsics.checkNotNullParameter(files, "files");
            Intrinsics.checkNotNullParameter(subtractRelativePath, "subtractRelativePath");
            try {
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(zipFile);
                ZipOutputStream zos = new ZipOutputStream(fos);
                int n = files.size();
                for (int i = 0; i < n; ++i) {
                    File srcFile = files.get(i);
                    FileInputStream fis = new FileInputStream(srcFile);
                    String string = srcFile.getPath();
                    Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
                    zos.putNextEntry(new ZipEntry(StringsKt.replaceFirst$default(string, subtractRelativePath, "", false, 4, null)));
                    int length = 0;
                    while (true) {
                        int n2;
                        int it = n2 = fis.read(buffer);
                        boolean bl = false;
                        length = it;
                        if (n2 <= 0) break;
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                    fis.close();
                }
                zos.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public static /* synthetic */ void zipFiles$default(Companion companion, File file, List list, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            companion.zipFiles(file, list, string);
        }

        public final void zipDir(@NotNull File fileToZip, @NotNull File zipFile) throws IOException {
            Intrinsics.checkNotNullParameter(fileToZip, "fileToZip");
            Intrinsics.checkNotNullParameter(zipFile, "zipFile");
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            String string = fileToZip.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            this.zipFile(null, fileToZip, string, zipOut);
            zipOut.close();
            fos.close();
        }

        public final void zipDirFiles(@NotNull File fileToZip, @NotNull List<? extends File> files, @NotNull File zipFile) throws IOException {
            Intrinsics.checkNotNullParameter(fileToZip, "fileToZip");
            Intrinsics.checkNotNullParameter(files, "files");
            Intrinsics.checkNotNullParameter(zipFile, "zipFile");
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            String string = fileToZip.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            this.zipFile(files, fileToZip, string, zipOut);
            zipOut.close();
            fos.close();
        }

        private final void zipFile(List<? extends File> files, File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
            if (fileToZip.isHidden()) {
                return;
            }
            if (fileToZip.isDirectory()) {
                File[] children2 = fileToZip.listFiles();
                ZipEntry zipEntry = new ZipEntry(fileName + '/');
                zipOut.putNextEntry(zipEntry);
                Intrinsics.checkNotNull(children2);
                for (File childFile : children2) {
                    if (!childFile.isDirectory() && files != null && !files.contains(childFile)) continue;
                    Intrinsics.checkNotNull(childFile);
                    this.zipFile(files, childFile, fileName + '/' + childFile.getName(), zipOut);
                }
                return;
            }
            FileInputStream fis = new FileInputStream(fileToZip);
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            int length = 0;
            while (true) {
                int n;
                int it = n = fis.read(bytes);
                boolean bl = false;
                length = it;
                if (n < 0) break;
                zipOut.write(bytes, 0, length);
            }
            fis.close();
        }

        public final void unzipDir(@NotNull File zipFile, @NotNull String dirToUnzip) throws IOException {
            Intrinsics.checkNotNullParameter(zipFile, "zipFile");
            Intrinsics.checkNotNullParameter(dirToUnzip, "dirToUnzip");
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String fileName = zipEntry.getName();
                File newFile = new File(dirToUnzip + '/' + fileName);
                if (zipEntry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    new File(newFile.getParent()).mkdirs();
                    FileOutputStream fos = new FileOutputStream(newFile);
                    int len = 0;
                    while (true) {
                        int n;
                        int it = n = zis.read(buffer);
                        boolean bl = false;
                        len = it;
                        if (n <= 0) break;
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

