/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.server;

import eu.thesimplecloud.clientserverapi.lib.bootstrap.AbstractCommunicationBootstrap;
import eu.thesimplecloud.clientserverapi.lib.codec.ProtobufVarint32FrameDecoder;
import eu.thesimplecloud.clientserverapi.lib.codec.ProtobufVarint32LengthFieldPrepender;
import eu.thesimplecloud.clientserverapi.lib.defaultpackets.PacketIOConnectionWillClose;
import eu.thesimplecloud.clientserverapi.lib.handler.DefaultConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.DefaultServerHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.IServerHandler;
import eu.thesimplecloud.clientserverapi.lib.packet.PacketDecoder;
import eu.thesimplecloud.clientserverapi.lib.packet.PacketEncoder;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.clientserverapi.server.INettyServer;
import eu.thesimplecloud.clientserverapi.server.NettyServerHandler;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.ClientManager;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.IClientManager;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClientValue;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B/\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Leu/thesimplecloud/clientserverapi/server/NettyServer;", "T", "Leu/thesimplecloud/clientserverapi/server/client/connectedclient/IConnectedClientValue;", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/AbstractCommunicationBootstrap;", "Leu/thesimplecloud/clientserverapi/server/INettyServer;", "host", "", "port", "", "connectionHandler", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "serverHandler", "Leu/thesimplecloud/clientserverapi/lib/handler/IServerHandler;", "(Ljava/lang/String;ILeu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;Leu/thesimplecloud/clientserverapi/lib/handler/IServerHandler;)V", "active", "", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "clientManager", "Leu/thesimplecloud/clientserverapi/server/client/clientmanager/ClientManager;", "eventExecutorGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "listening", "workerGroup", "getClientManager", "Leu/thesimplecloud/clientserverapi/server/client/clientmanager/IClientManager;", "isActive", "isListening", "shutdown", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "start", "clientserverapi"})
@SourceDebugExtension(value={"SMAP\nNettyServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyServer.kt\neu/thesimplecloud/clientserverapi/server/NettyServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class NettyServer<T extends IConnectedClientValue>
extends AbstractCommunicationBootstrap
implements INettyServer<T> {
    @NotNull
    private final IServerHandler<T> serverHandler;
    @Nullable
    private NioEventLoopGroup bossGroup;
    @Nullable
    private NioEventLoopGroup workerGroup;
    @Nullable
    private EventExecutorGroup eventExecutorGroup;
    private boolean active;
    private boolean listening;
    @NotNull
    private final ClientManager<T> clientManager;

    public NettyServer(@NotNull String host, int port, @NotNull IConnectionHandler connectionHandler, @NotNull IServerHandler<T> serverHandler) {
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(connectionHandler, "connectionHandler");
        Intrinsics.checkNotNullParameter(serverHandler, "serverHandler");
        super(host, port, connectionHandler);
        this.serverHandler = serverHandler;
        this.clientManager = new ClientManager(this);
    }

    public /* synthetic */ NettyServer(String string, int n, IConnectionHandler iConnectionHandler, IServerHandler iServerHandler, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            iConnectionHandler = new DefaultConnectionHandler();
        }
        if ((n2 & 8) != 0) {
            iServerHandler = new DefaultServerHandler();
        }
        this(string, n, iConnectionHandler, iServerHandler);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> start() {
        String[] stringArray = new String[]{"eu.thesimplecloud.clientserverapi.lib.defaultpackets"};
        this.addPacketsByPackage(stringArray);
        if (!(!this.active)) {
            boolean $i$a$-check-NettyServer$start$22 = false;
            String $i$a$-check-NettyServer$start$22 = "Can't start server multiple times.";
            throw new IllegalStateException($i$a$-check-NettyServer$start$22.toString());
        }
        this.active = true;
        CommunicationPromise startPromise = new CommunicationPromise(false);
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.bossGroup, this.workerGroup);
        bootstrap.channel(NioServerSocketChannel.class);
        NettyServer instance = this;
        this.eventExecutorGroup = new DefaultEventExecutorGroup(20);
        bootstrap.childHandler(new ChannelInitializer<SocketChannel>(instance, this){
            final /* synthetic */ NettyServer<T> $instance;
            final /* synthetic */ NettyServer<T> this$0;
            {
                this.$instance = $instance;
                this.this$0 = $receiver;
            }

            protected void initChannel(@NotNull SocketChannel ch) throws Exception {
                Intrinsics.checkNotNullParameter(ch, "ch");
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("frameDecoder", (ChannelHandler)new ProtobufVarint32FrameDecoder());
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new PacketDecoder(this.$instance, this.this$0.getPacketManager())};
                pipeline.addLast(channelHandlerArray);
                pipeline.addLast("frameEncoder", (ChannelHandler)new ProtobufVarint32LengthFieldPrepender());
                channelHandlerArray = new ChannelHandler[]{new PacketEncoder(this.$instance)};
                pipeline.addLast(channelHandlerArray);
                pipeline.addLast(NettyServer.access$getEventExecutorGroup$p(this.this$0), "serverHandler", (ChannelHandler)new NettyServerHandler((INettyServer)this.$instance, this.this$0.getConnectionHandler()));
                channelHandlerArray = new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)};
                pipeline.addLast(channelHandlerArray);
            }
        });
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, true);
        ChannelFuture channelFuture = bootstrap.bind(this.getHost(), this.getPort());
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)arg_0 -> NettyServer.start$lambda$1(this, startPromise, arg_0)));
        return startPromise;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> shutdown() {
        Object object;
        if (!this.listening) {
            return CommunicationPromise.Companion.of(Unit.INSTANCE);
        }
        this.getClientManager().sendPacketToAllClients(new PacketIOConnectionWillClose());
        CommunicationPromise shutdownPromise = new CommunicationPromise(false);
        this.listening = false;
        NioEventLoopGroup nioEventLoopGroup = this.bossGroup;
        if (nioEventLoopGroup != null) {
            nioEventLoopGroup.shutdownGracefully();
        }
        NioEventLoopGroup nioEventLoopGroup2 = this.workerGroup;
        if (nioEventLoopGroup2 != null) {
            nioEventLoopGroup2.shutdownGracefully();
        }
        if ((object = this.eventExecutorGroup) != null && (object = object.shutdownGracefully()) != null) {
            object.addListener(arg_0 -> NettyServer.shutdown$lambda$2(shutdownPromise, arg_0));
        }
        this.serverHandler.onServerShutdown(this);
        this.active = false;
        return shutdownPromise;
    }

    @Override
    @NotNull
    public IClientManager<T> getClientManager() {
        return this.clientManager;
    }

    private static final void start$lambda$1(NettyServer this$0, CommunicationPromise $startPromise, Future future) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($startPromise, "$startPromise");
        if (future.isSuccess()) {
            this$0.listening = true;
            this$0.serverHandler.onServerStarted(this$0);
            $startPromise.trySuccess(Unit.INSTANCE);
        } else {
            this$0.shutdown();
            IServerHandler iServerHandler = this$0.serverHandler;
            INettyServer iNettyServer = this$0;
            Throwable throwable = future.cause();
            Intrinsics.checkNotNullExpressionValue(throwable, "cause(...)");
            iServerHandler.onServerStartException(iNettyServer, throwable);
            Throwable throwable2 = future.cause();
            Intrinsics.checkNotNullExpressionValue(throwable2, "cause(...)");
            $startPromise.tryFailure(throwable2);
        }
    }

    private static final void shutdown$lambda$2(CommunicationPromise $shutdownPromise, Future it) {
        Intrinsics.checkNotNullParameter($shutdownPromise, "$shutdownPromise");
        if (it.isSuccess()) {
            $shutdownPromise.trySuccess(Unit.INSTANCE);
        } else {
            Throwable throwable = it.cause();
            Intrinsics.checkNotNullExpressionValue(throwable, "cause(...)");
            $shutdownPromise.tryFailure(throwable);
        }
    }

    public static final /* synthetic */ EventExecutorGroup access$getEventExecutorGroup$p(NettyServer $this) {
        return $this.eventExecutorGroup;
    }
}

