/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.jsonlib;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import eu.thesimplecloud.jsonlib.GsonCreator;
import eu.thesimplecloud.jsonlib.JsonLibExclude;
import eu.thesimplecloud.jsonlib.JsonObjectExtensionKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u00015B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\u001d\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0015\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0015\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&\u00a2\u0006\u0002\u0010'J)\u0010#\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&\u00a2\u0006\u0002\u0010'J\u0010\u0010*\u001a\u0004\u0018\u00010\u00002\u0006\u0010+\u001a\u00020\u000bJ\u0010\u0010,\u001a\u0004\u0018\u00010\u00002\u0006\u0010-\u001a\u00020\u000bJ\u0010\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u000e\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020\u000bJ\u000e\u00103\u001a\u00020\r2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u000bJ\b\u00104\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00066"}, d2={"Leu/thesimplecloud/jsonlib/JsonLib;", "", "jsonElement", "Lcom/google/gson/JsonElement;", "currentGson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/JsonElement;Lcom/google/gson/Gson;)V", "getJsonElement", "()Lcom/google/gson/JsonElement;", "append", "property", "", "value", "", "(Ljava/lang/String;Ljava/lang/Boolean;)Leu/thesimplecloud/jsonlib/JsonLib;", "", "getAsJsonArray", "Lcom/google/gson/JsonArray;", "getAsJsonString", "getBoolean", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "getFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getJsonStringAsBytes", "", "getLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "getObject", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getObjectOrNull", "getPath", "path", "getProperty", "name", "getString", "saveAsFile", "", "file", "Ljava/io/File;", "saveJsonElementAsFile", "toString", "Companion", "json-lib"})
public final class JsonLib {
    @NotNull
    private final JsonElement jsonElement;
    private final Gson currentGson;
    @NotNull
    private static Gson GSON;
    public static final Companion Companion;

    @NotNull
    public final JsonLib append(@NotNull String property, @Nullable String value) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't append element to JsonPrimitive.");
        }
        ((JsonObject)this.jsonElement).addProperty(property, value);
        return this;
    }

    @NotNull
    public final JsonLib append(@NotNull String property, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't append element to JsonPrimitive.");
        }
        ((JsonObject)this.jsonElement).add(property, this.currentGson.toJsonTree(value));
        return this;
    }

    @NotNull
    public final JsonLib append(@NotNull String property, @Nullable Number value) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't append element to JsonPrimitive.");
        }
        ((JsonObject)this.jsonElement).addProperty(property, value);
        return this;
    }

    @NotNull
    public final JsonLib append(@NotNull String property, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't append element to JsonPrimitive.");
        }
        ((JsonObject)this.jsonElement).addProperty(property, value);
        return this;
    }

    @Nullable
    public final JsonLib getProperty(@NotNull String name) {
        JsonLib jsonLib;
        Intrinsics.checkNotNullParameter(name, "name");
        if (!(this.jsonElement instanceof JsonObject)) {
            return null;
        }
        JsonElement jsonElement = ((JsonObject)this.jsonElement).get(name);
        if (jsonElement != null) {
            JsonElement jsonElement2 = jsonElement;
            boolean bl = false;
            boolean bl2 = false;
            JsonElement it = jsonElement2;
            boolean bl3 = false;
            jsonLib = new JsonLib(it, this.currentGson);
        } else {
            jsonLib = null;
        }
        return jsonLib;
    }

    @Nullable
    public final JsonLib getPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        List array = StringsKt.split$default((CharSequence)path, new String[]{"."}, false, 0, 6, null);
        JsonLib currentJsonLib = this;
        for (String property : array) {
            JsonLib jsonLib = currentJsonLib;
            currentJsonLib = jsonLib != null ? jsonLib.getProperty(property) : null;
            if (currentJsonLib != null) continue;
            return null;
        }
        return currentJsonLib;
    }

    @Nullable
    public final Integer getInt(@NotNull String property) {
        Integer n;
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (!((JsonObject)this.jsonElement).has(property)) {
            n = null;
        } else {
            JsonElement jsonElement = JsonObjectExtensionKt.getOrNull((JsonObject)this.jsonElement, property);
            n = jsonElement != null ? Integer.valueOf(jsonElement.getAsInt()) : null;
        }
        return n;
    }

    @Nullable
    public final Long getLong(@NotNull String property) {
        Long l;
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (!((JsonObject)this.jsonElement).has(property)) {
            l = null;
        } else {
            JsonElement jsonElement = JsonObjectExtensionKt.getOrNull((JsonObject)this.jsonElement, property);
            l = jsonElement != null ? Long.valueOf(jsonElement.getAsLong()) : null;
        }
        return l;
    }

    @Nullable
    public final Double getDouble(@NotNull String property) {
        Double d;
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (!((JsonObject)this.jsonElement).has(property)) {
            d = null;
        } else {
            JsonElement jsonElement = JsonObjectExtensionKt.getOrNull((JsonObject)this.jsonElement, property);
            d = jsonElement != null ? Double.valueOf(jsonElement.getAsDouble()) : null;
        }
        return d;
    }

    @Nullable
    public final Float getFloat(@NotNull String property) {
        Float f;
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (!((JsonObject)this.jsonElement).has(property)) {
            f = null;
        } else {
            JsonElement jsonElement = JsonObjectExtensionKt.getOrNull((JsonObject)this.jsonElement, property);
            f = jsonElement != null ? Float.valueOf(jsonElement.getAsFloat()) : null;
        }
        return f;
    }

    @Nullable
    public final Boolean getBoolean(@NotNull String property) {
        Boolean bl;
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (!((JsonObject)this.jsonElement).has(property)) {
            bl = null;
        } else {
            JsonElement jsonElement = JsonObjectExtensionKt.getOrNull((JsonObject)this.jsonElement, property);
            bl = jsonElement != null ? Boolean.valueOf(jsonElement.getAsBoolean()) : null;
        }
        return bl;
    }

    @Nullable
    public final JsonArray getAsJsonArray(@NotNull String property) {
        JsonArray jsonArray;
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (!((JsonObject)this.jsonElement).has(property)) {
            jsonArray = null;
        } else {
            JsonElement jsonElement = JsonObjectExtensionKt.getOrNull((JsonObject)this.jsonElement, property);
            jsonArray = jsonElement != null ? jsonElement.getAsJsonArray() : null;
        }
        return jsonArray;
    }

    @Nullable
    public final String getString(@NotNull String property) {
        String string;
        Intrinsics.checkNotNullParameter(property, "property");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (!((JsonObject)this.jsonElement).has(property)) {
            string = null;
        } else {
            JsonElement jsonElement = JsonObjectExtensionKt.getOrNull((JsonObject)this.jsonElement, property);
            string = jsonElement != null ? jsonElement.getAsString() : null;
        }
        return string;
    }

    @Nullable
    public final <T> T getObject(@NotNull String property, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        if (!(this.jsonElement instanceof JsonObject)) {
            throw (Throwable)new UnsupportedOperationException("Can't get element from JsonPrimitive.");
        }
        if (Intrinsics.areEqual(clazz, JsonLib.class)) {
            return (T)this.getProperty(property);
        }
        return !((JsonObject)this.jsonElement).has(property) ? null : (T)this.currentGson.fromJson(((JsonObject)this.jsonElement).get(property), clazz);
    }

    public final <T> T getObject(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.currentGson.fromJson(this.getAsJsonString(), clazz);
    }

    @Nullable
    public final <T> T getObjectOrNull(@NotNull Class<T> clazz) {
        T t2;
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        if (StringsKt.isBlank(this.getAsJsonString())) {
            return null;
        }
        try {
            t2 = this.currentGson.fromJson(this.getAsJsonString(), clazz);
        }
        catch (Exception ex) {
            t2 = null;
        }
        return t2;
    }

    public final void saveAsFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.saveJsonElementAsFile(new File(path));
    }

    public final void saveAsFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.saveJsonElementAsFile(file);
    }

    public final boolean saveJsonElementAsFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.saveJsonElementAsFile(new File(path));
    }

    public final boolean saveJsonElementAsFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.getJsonStringAsBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    @NotNull
    public final String getAsJsonString() {
        String string = this.currentGson.toJson(this.jsonElement);
        Intrinsics.checkNotNullExpressionValue(string, "this.currentGson.toJson(jsonElement)");
        return string;
    }

    @NotNull
    public final byte[] getJsonStringAsBytes() {
        String string = this.getAsJsonString();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public String toString() {
        return this.getAsJsonString();
    }

    @NotNull
    public final JsonElement getJsonElement() {
        return this.jsonElement;
    }

    private JsonLib(JsonElement jsonElement, Gson currentGson) {
        this.jsonElement = jsonElement;
        this.currentGson = currentGson;
    }

    static {
        Companion = new Companion(null);
        GSON = new GsonCreator().excludeAnnotations(JsonLibExclude.class).create();
    }

    public /* synthetic */ JsonLib(JsonElement jsonElement, Gson currentGson, DefaultConstructorMarker $constructor_marker) {
        this(jsonElement, currentGson);
    }

    @JvmStatic
    @NotNull
    public static final JsonLib empty() {
        return Companion.empty();
    }

    @JvmStatic
    @NotNull
    public static final JsonLib empty(@NotNull Gson gson) {
        return Companion.empty(gson);
    }

    @JvmStatic
    @NotNull
    public static final JsonLib fromJsonElement(@NotNull JsonElement jsonElement) {
        return Companion.fromJsonElement(jsonElement);
    }

    @JvmStatic
    @NotNull
    public static final JsonLib fromObject(@NotNull Object any2) {
        return Companion.fromObject(any2);
    }

    @JvmStatic
    @NotNull
    public static final JsonLib fromObject(@NotNull Object any2, @NotNull Gson gson) {
        return Companion.fromObject(any2, gson);
    }

    @JvmStatic
    @Nullable
    public static final JsonLib fromJsonFile(@NotNull String path, @NotNull Gson gson) {
        return Companion.fromJsonFile(path, gson);
    }

    @JvmStatic
    @Nullable
    public static final JsonLib fromJsonFile(@NotNull File file, @NotNull Gson gson) {
        return Companion.fromJsonFile(file, gson);
    }

    @JvmStatic
    @NotNull
    public static final JsonLib fromInputStream(@NotNull InputStream inputStream) {
        return Companion.fromInputStream(inputStream);
    }

    @JvmStatic
    @NotNull
    public static final JsonLib fromInputStream(@NotNull InputStream inputStream, @NotNull Gson gson) {
        return Companion.fromInputStream(inputStream, gson);
    }

    @JvmStatic
    @NotNull
    public static final JsonLib fromJsonString(@NotNull String string, @NotNull Gson gson) {
        return Companion.fromJsonString(string, gson);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0007J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0007J\u001a\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0001H\u0007J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u0004R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Leu/thesimplecloud/jsonlib/JsonLib$Companion;", "", "()V", "<set-?>", "Lcom/google/gson/Gson;", "GSON", "getGSON", "()Lcom/google/gson/Gson;", "setGSON", "(Lcom/google/gson/Gson;)V", "empty", "Leu/thesimplecloud/jsonlib/JsonLib;", "gson", "fromInputStream", "inputStream", "Ljava/io/InputStream;", "fromJsonElement", "jsonElement", "Lcom/google/gson/JsonElement;", "fromJsonFile", "file", "Ljava/io/File;", "path", "", "fromJsonString", "string", "fromObject", "any", "loadFile", "loadFromInputStream", "setDefaultGson", "", "json-lib"})
    public static final class Companion {
        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        private final void setGSON(Gson gson) {
            GSON = gson;
        }

        public final void setDefaultGson(@NotNull Gson gson) {
            Intrinsics.checkNotNullParameter(gson, "gson");
            this.setGSON(gson);
        }

        @JvmStatic
        @NotNull
        public final JsonLib empty() {
            return this.empty(this.getGSON());
        }

        @JvmStatic
        @NotNull
        public final JsonLib empty(@NotNull Gson gson) {
            Intrinsics.checkNotNullParameter(gson, "gson");
            return new JsonLib(new JsonObject(), gson, null);
        }

        @JvmStatic
        @NotNull
        public final JsonLib fromJsonElement(@NotNull JsonElement jsonElement) {
            Intrinsics.checkNotNullParameter(jsonElement, "jsonElement");
            return new JsonLib(jsonElement, this.getGSON(), null);
        }

        @JvmStatic
        @NotNull
        public final JsonLib fromObject(@NotNull Object any2) {
            Intrinsics.checkNotNullParameter(any2, "any");
            String string = this.getGSON().toJson(any2);
            Intrinsics.checkNotNullExpressionValue(string, "GSON.toJson(any)");
            return eu.thesimplecloud.jsonlib.JsonLib$Companion.fromJsonString$default(this, string, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final JsonLib fromObject(@NotNull Object any2, @NotNull Gson gson) {
            Intrinsics.checkNotNullParameter(any2, "any");
            Intrinsics.checkNotNullParameter(gson, "gson");
            String string = gson.toJson(any2);
            Intrinsics.checkNotNullExpressionValue(string, "gson.toJson(any)");
            return this.fromJsonString(string, gson);
        }

        @JvmStatic
        @Nullable
        public final JsonLib fromJsonFile(@NotNull String path, @NotNull Gson gson) {
            Intrinsics.checkNotNullParameter(path, "path");
            Intrinsics.checkNotNullParameter(gson, "gson");
            return this.fromJsonFile(new File(path), gson);
        }

        public static /* synthetic */ JsonLib fromJsonFile$default(Companion companion, String string, Gson gson, int n, Object object) {
            if ((n & 2) != 0) {
                gson = companion.getGSON();
            }
            return companion.fromJsonFile(string, gson);
        }

        @JvmStatic
        @Nullable
        public final JsonLib fromJsonFile(@NotNull File file, @NotNull Gson gson) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(gson, "gson");
            if (!file.exists()) {
                return null;
            }
            return this.fromJsonString(this.loadFile(file), gson);
        }

        public static /* synthetic */ JsonLib fromJsonFile$default(Companion companion, File file, Gson gson, int n, Object object) {
            if ((n & 2) != 0) {
                gson = companion.getGSON();
            }
            return companion.fromJsonFile(file, gson);
        }

        @JvmStatic
        @NotNull
        public final JsonLib fromInputStream(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter(inputStream, "inputStream");
            return eu.thesimplecloud.jsonlib.JsonLib$Companion.fromJsonString$default(this, this.loadFromInputStream(inputStream), null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final JsonLib fromInputStream(@NotNull InputStream inputStream, @NotNull Gson gson) {
            Intrinsics.checkNotNullParameter(inputStream, "inputStream");
            Intrinsics.checkNotNullParameter(gson, "gson");
            return this.fromJsonString(this.loadFromInputStream(inputStream), gson);
        }

        @JvmStatic
        @NotNull
        public final JsonLib fromJsonString(@NotNull String string, @NotNull Gson gson) {
            JsonLib jsonLib;
            Intrinsics.checkNotNullParameter(string, "string");
            Intrinsics.checkNotNullParameter(gson, "gson");
            try {
                JsonObject jsonObject;
                JsonObject jsonObject2 = jsonObject = gson.fromJson(string, JsonObject.class);
                Intrinsics.checkNotNullExpressionValue(jsonObject2, "jsonObject");
                jsonLib = new JsonLib(jsonObject2, gson, null);
            }
            catch (Exception ex) {
                JsonLib jsonLib2;
                try {
                    JsonArray jsonPrimitive;
                    JsonArray jsonArray = jsonPrimitive = gson.fromJson(string, JsonArray.class);
                    Intrinsics.checkNotNullExpressionValue(jsonArray, "jsonPrimitive");
                    jsonLib2 = new JsonLib(jsonArray, gson, null);
                }
                catch (Exception ex2) {
                    JsonLib jsonLib3;
                    try {
                        JsonPrimitive jsonPrimitive;
                        JsonPrimitive jsonPrimitive2 = jsonPrimitive = gson.fromJson(string, JsonPrimitive.class);
                        Intrinsics.checkNotNullExpressionValue(jsonPrimitive2, "jsonPrimitive");
                        jsonLib3 = new JsonLib(jsonPrimitive2, gson, null);
                    }
                    catch (Exception ex3) {
                        throw (Throwable)new IllegalArgumentException("Can't parse string " + string, ex3);
                    }
                    jsonLib2 = jsonLib3;
                }
                jsonLib = jsonLib2;
            }
            return jsonLib;
        }

        public static /* synthetic */ JsonLib fromJsonString$default(Companion companion, String string, Gson gson, int n, Object object) {
            if ((n & 2) != 0) {
                gson = companion.getGSON();
            }
            return companion.fromJsonString(string, gson);
        }

        private final String loadFromInputStream(InputStream inputStream) {
            try {
                byte[] data = new byte[inputStream.available()];
                inputStream.read(data);
                inputStream.close();
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                return new String(data, charset);
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }

        private final String loadFile(File file) {
            if (!file.exists()) {
                return "";
            }
            return this.loadFromInputStream(new FileInputStream(file));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

