/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

final class PseudoRandomFunction {
    private PseudoRandomFunction() {
    }

    static byte[] hash(byte[] secret, byte[] label, byte[] seed, int length, String algo) {
        ObjectUtil.checkPositiveOrZero(length, "length");
        try {
            byte[] data;
            Mac hmac = Mac.getInstance(algo);
            hmac.init(new SecretKeySpec(secret, algo));
            int iterations = (int)Math.ceil((double)length / (double)hmac.getMacLength());
            byte[] expansion = EmptyArrays.EMPTY_BYTES;
            byte[] A2 = data = PseudoRandomFunction.concat(label, seed);
            for (int i = 0; i < iterations; ++i) {
                A2 = hmac.doFinal(A2);
                expansion = PseudoRandomFunction.concat(expansion, hmac.doFinal(PseudoRandomFunction.concat(A2, data)));
            }
            return Arrays.copyOf(expansion, length);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Could not find algo: " + algo, e);
        }
    }

    private static byte[] concat(byte[] first2, byte[] second2) {
        byte[] result2 = Arrays.copyOf(first2, first2.length + second2.length);
        System.arraycopy(second2, 0, result2, first2.length, second2.length);
        return result2;
    }
}

