/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.commands;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.template.ITemplateManager;
import eu.thesimplecloud.api.template.impl.DefaultTemplate;
import eu.thesimplecloud.base.manager.setup.WrapperSetup;
import eu.thesimplecloud.base.manager.setup.groups.LobbyGroupSetup;
import eu.thesimplecloud.base.manager.setup.groups.ProxyGroupSetup;
import eu.thesimplecloud.base.manager.setup.groups.ServerGroupSetup;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.launcher.console.setup.ISetup;
import eu.thesimplecloud.launcher.console.setup.SetupManager;
import eu.thesimplecloud.launcher.startup.Launcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Command(name="create", commandType=CommandType.CONSOLE, permission="cloud.command.create")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\u0012\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\bH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Leu/thesimplecloud/base/manager/commands/CreateCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "()V", "templateManager", "Leu/thesimplecloud/api/template/ITemplateManager;", "getTemplateManager", "()Leu/thesimplecloud/api/template/ITemplateManager;", "createLobbyGroup", "", "createProxyGroup", "createServerGroup", "createTemplate", "name", "", "createWrapper", "simplecloud-base"})
public final class CreateCommand
implements ICommandHandler {
    @NotNull
    private final ITemplateManager templateManager = CloudAPI.Companion.getInstance().getTemplateManager();

    @NotNull
    public final ITemplateManager getTemplateManager() {
        return this.templateManager;
    }

    @CommandSubPath(path="lobbygroup", description="Creates a lobby group")
    public final void createLobbyGroup() {
        SetupManager.queueSetup$default((SetupManager)Launcher.Companion.getInstance().getSetupManager(), (ISetup)new LobbyGroupSetup(), (boolean)false, (int)2, null);
    }

    @CommandSubPath(path="proxygroup", description="Creates a proxy group")
    public final void createProxyGroup() {
        SetupManager.queueSetup$default((SetupManager)Launcher.Companion.getInstance().getSetupManager(), (ISetup)new ProxyGroupSetup(), (boolean)false, (int)2, null);
    }

    @CommandSubPath(path="servergroup", description="Creates a server group")
    public final void createServerGroup() {
        SetupManager.queueSetup$default((SetupManager)Launcher.Companion.getInstance().getSetupManager(), (ISetup)new ServerGroupSetup(), (boolean)false, (int)2, null);
    }

    @CommandSubPath(path="wrapper", description="Creates a wrapper")
    public final void createWrapper() {
        SetupManager.queueSetup$default((SetupManager)Launcher.Companion.getInstance().getSetupManager(), (ISetup)new WrapperSetup(), (boolean)false, (int)2, null);
    }

    @CommandSubPath(path="template <name>", description="Creates a template")
    public final void createTemplate(@CommandArgument(name="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (name.length() > 16) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.create.template.name-too-long", new String[0]);
        }
        if (this.templateManager.getTemplateByName(name) != null) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.create.template.already-exist", new String[]{name});
            return;
        }
        DefaultTemplate template = new DefaultTemplate(name);
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)this.templateManager), (Object)template, (boolean)false, (boolean)false, (int)6, null);
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.create.template.success", new String[]{name});
    }
}

