/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.commands;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.template.ITemplateManager;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Command(name="delete", commandType=CommandType.CONSOLE, permission="cloud.command.delete")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Leu/thesimplecloud/base/manager/commands/DeleteCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "()V", "templateManager", "Leu/thesimplecloud/api/template/ITemplateManager;", "deleteGroup", "", "name", "", "deleteTemplate", "deleteWrapper", "simplecloud-base"})
public final class DeleteCommand
implements ICommandHandler {
    private final ITemplateManager templateManager = CloudAPI.Companion.getInstance().getTemplateManager();

    @CommandSubPath(path="template <name>", description="Deletes a template")
    public final void deleteTemplate(@CommandArgument(name="name") @NotNull String name) {
        boolean bl;
        block10: {
            ICloudServiceGroup it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block9: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (this.templateManager.getTemplateByName(name) == null) {
                    Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.template.not-exist", new String[]{name});
                    return;
                }
                $this$any$iv = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getAllCachedObjects();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ICloudServiceGroup)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it.getTemplateName(), (String)name, (boolean)true)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.template.in-use.group", new String[]{name});
                return;
            }
            $this$any$iv = CloudAPI.Companion.getInstance().getCloudServiceManager().getAllCachedObjects();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ICloudService)element$iv;
                    boolean bl4 = false;
                    if (!StringsKt.equals((String)it.getTemplateName(), (String)name, (boolean)true)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.template.in-use.service", new String[]{name});
            return;
        }
        this.templateManager.deleteTemplate(name);
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.template.success", new String[]{name});
    }

    @CommandSubPath(path="group <name>", description="Deletes a group")
    public final void deleteGroup(@CommandArgument(name="name") @NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudServiceGroup serviceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(name);
        if (serviceGroup == null) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.group.not-exist", new String[]{name});
            return;
        }
        DeleteCommand deleteCommand = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            DeleteCommand $this$runCatching = deleteCommand;
            boolean bl2 = false;
            ICommunicationPromise iCommunicationPromise = ICacheList.DefaultImpls.delete$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getCloudServiceGroupManager()), (Object)serviceGroup, (boolean)false, (int)2, null);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)iCommunicationPromise);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object result = object;
        if (Result.isFailure-impl((Object)result)) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.group.services-running", new String[]{name});
            return;
        }
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.group.success", new String[]{name});
    }

    @CommandSubPath(path="wrapper <wrapper>", description="Deletes a wrapper")
    public final void deleteWrapper(@CommandArgument(name="wrapper") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IWrapperInfo wrapper = CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByName(name);
        if (wrapper == null) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.wrapper.not-exist", new String[]{name});
            return;
        }
        Collection collection = wrapper.getServicesRunningOnThisWrapper();
        boolean bl = false;
        if (!collection.isEmpty()) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.wrapper.services-running", new String[]{name});
            return;
        }
        collection = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupsByWrapperName(wrapper.getName());
        bl = false;
        if (!collection.isEmpty()) {
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.wrapper.group-must-start", new String[]{name});
            return;
        }
        ICacheList.DefaultImpls.delete$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getWrapperManager()), (Object)wrapper, (boolean)false, (int)2, null);
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.command.delete.group.success", new String[]{name});
    }
}

