/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.commands;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.launcher.console.command.provider.ServiceCommandSuggestionProvider;
import eu.thesimplecloud.launcher.console.command.provider.ServiceGroupCommandSuggestionProvider;
import eu.thesimplecloud.launcher.console.command.provider.WrapperCommandSuggestionProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Command(name="info", commandType=CommandType.CONSOLE, permission="cloud.command.info")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Leu/thesimplecloud/base/manager/commands/InfoCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "()V", "group", "", "commandSender", "Leu/thesimplecloud/api/command/ICommandSender;", "name", "", "handlePlayers", "player", "service", "wrapper", "simplecloud-base"})
public final class InfoCommand
implements ICommandHandler {
    @CommandSubPath(path="wrapper <name>", description="Prints some information about the specified wrapper")
    public final void wrapper(@NotNull ICommandSender commandSender, @CommandArgument(name="name", suggestionProvider=WrapperCommandSuggestionProvider.class) @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IWrapperInfo wrapper = CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByName(name);
        if (wrapper == null) {
            commandSender.sendProperty("manager.command.info.wrapper.not-exist", new String[0]);
            return;
        }
        commandSender.sendMessage(wrapper.toString());
    }

    @CommandSubPath(path="service <name>", description="Prints some information about the specified service")
    public final void service(@NotNull ICommandSender commandSender, @CommandArgument(name="name", suggestionProvider=ServiceCommandSuggestionProvider.class) @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudService service = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(name);
        if (service == null) {
            commandSender.sendProperty("manager.command.info.service.not-exist", new String[0]);
            return;
        }
        commandSender.sendMessage(service.toString());
    }

    @CommandSubPath(path="group <name>", description="Prints some information about the specified group")
    public final void group(@NotNull ICommandSender commandSender, @CommandArgument(name="name", suggestionProvider=ServiceGroupCommandSuggestionProvider.class) @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudServiceGroup group = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(name);
        if (group == null) {
            commandSender.sendProperty("manager.command.info.group.not-exist", new String[0]);
            return;
        }
        commandSender.sendMessage(group.toString());
    }

    @CommandSubPath(path="player <name>", description="Prints some information about the specified player")
    public final void player(@NotNull ICommandSender commandSender, @CommandArgument(name="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudPlayer player = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCachedCloudPlayer(name);
        if (player == null) {
            commandSender.sendProperty("manager.command.info.player.not-exist", new String[0]);
            return;
        }
        commandSender.sendMessage(player.toString());
    }

    @CommandSubPath(path="onlinecount", description="Prints the number of online players")
    public final void handlePlayers(@NotNull ICommandSender commandSender) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        int onlineCount = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects().size();
        commandSender.sendProperty("manager.command.info.onlinecount", new String[]{String.valueOf(onlineCount)});
    }
}

