/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.commands;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.api.extension.ClientManagerExtensionKt;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.wrapper.IMutableWrapperInfo;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.base.core.jvm.JvmArgumentsConfig;
import eu.thesimplecloud.base.manager.commands.ReloadCommand;
import eu.thesimplecloud.base.manager.config.JvmArgumentsConfigLoader;
import eu.thesimplecloud.base.manager.network.packets.PacketOutReloadExistingModules;
import eu.thesimplecloud.base.manager.startup.Manager;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.IClientManager;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.launcher.external.module.LoadedModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Command(name="reload", commandType=CommandType.CONSOLE, permission="cloud.command.reload", aliases={"rl"})
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Leu/thesimplecloud/base/manager/commands/ReloadCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "()V", "handleReload", "", "commandSender", "Leu/thesimplecloud/api/command/ICommandSender;", "handleReloadModule", "moduleName", "", "simplecloud-base"})
public final class ReloadCommand
implements ICommandHandler {
    /*
     * WARNING - void declaration
     */
    @CommandSubPath(path="", description="Reloads the cloud")
    public final void handleReload(@NotNull ICommandSender commandSender) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        boolean $i$f$forEach2;
        Iterable $this$forEach$iv2;
        Iterator $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Manager.Companion.getInstance().getCloudModuleHandler().unloadAllReloadableModules();
        Manager.Companion.getInstance().getAppClassLoader().clearCachedClasses();
        List loadedWrappers = CollectionsKt.toMutableList((Collection)Manager.Companion.getInstance().getWrapperFileHandler().loadAll());
        Iterable $this$filter$iv = loadedWrappers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            IWrapperInfo it = (IWrapperInfo)element$iv$iv;
            boolean bl = false;
            if (!(CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByHost(it.getHost()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknownWrappers = (List)destination$iv$iv;
        $this$filter$iv = unknownWrappers;
        $i$f$filter = false;
        if (!$this$filter$iv.isEmpty()) {
            $this$forEach$iv2 = unknownWrappers;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                IWrapperInfo it = (IWrapperInfo)element$iv;
                boolean bl = false;
                commandSender.sendProperty("manager.command.reload.wrapper-changed", new String[]{it.getName()});
            }
        }
        CollectionsKt.toMutableList((Collection)loadedWrappers).removeAll(unknownWrappers);
        $this$forEach$iv2 = loadedWrappers;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IWrapperInfo it = (IWrapperInfo)element$iv;
            boolean bl = false;
            IWrapperInfo iWrapperInfo = CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByHost(it.getHost());
            if (iWrapperInfo == null) {
                throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.wrapper.IMutableWrapperInfo");
            }
            IMutableWrapperInfo cachedWrapper = (IMutableWrapperInfo)iWrapperInfo;
            cachedWrapper.setMaxSimultaneouslyStartingServices(it.getMaxSimultaneouslyStartingServices());
            cachedWrapper.setMaxMemory(it.getMaxMemory());
            ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getWrapperManager()), (Object)cachedWrapper, (boolean)false, (boolean)false, (int)6, null);
        }
        $this$forEach$iv2 = loadedWrappers;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IWrapperInfo it = (IWrapperInfo)element$iv;
            boolean bl = false;
            commandSender.sendProperty("manager.command.reload.wrapper-success", new String[]{it.getName()});
        }
        JvmArgumentsConfigLoader jvmArgumentsConfigLoader = new JvmArgumentsConfigLoader();
        Manager.Companion.getInstance().setJvmArgumentsConfig((JvmArgumentsConfig)jvmArgumentsConfigLoader.loadConfig());
        List loadedGroups = CollectionsKt.toMutableList((Collection)Manager.Companion.getInstance().getCloudServiceGroupFileHandler().loadAll());
        Iterable $this$filter$iv2 = loadedGroups;
        boolean $i$f$filter2 = false;
        Iterable bl = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudServiceGroup it = (ICloudServiceGroup)element$iv$iv;
            boolean bl2 = false;
            if (!(CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(it.getName()) == null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unknownGroups = (List)destination$iv$iv2;
        $this$filter$iv2 = unknownGroups;
        $i$f$filter2 = false;
        if (!$this$filter$iv2.isEmpty()) {
            $this$forEach$iv = unknownGroups;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ICloudServiceGroup it = (ICloudServiceGroup)element$iv;
                boolean bl3 = false;
                commandSender.sendProperty("manager.command.reload.group-changed", new String[]{it.getName()});
            }
        }
        CollectionsKt.toMutableList((Collection)loadedGroups).removeAll(unknownGroups);
        $this$forEach$iv = loadedGroups;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudServiceGroup it = (ICloudServiceGroup)element$iv;
            boolean bl4 = false;
            ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getCloudServiceGroupManager()), (Object)it, (boolean)false, (boolean)false, (int)6, null);
        }
        $this$forEach$iv = loadedGroups;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudServiceGroup it = (ICloudServiceGroup)element$iv;
            boolean bl5 = false;
            commandSender.sendProperty("manager.command.reload.group-success", new String[]{it.getName()});
        }
        ClientManagerExtensionKt.sendPacketToAllAuthenticatedWrapperClients((IClientManager)Manager.Companion.getInstance().getCommunicationServer().getClientManager(), (IPacket)((IPacket)new PacketOutReloadExistingModules()));
        Manager.Companion.getInstance().getAppClassLoader().clearCachedClasses();
        ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)handleReload.7.INSTANCE, (int)28, null);
    }

    @CommandSubPath(path="module <name>", description="Reloads a specific module")
    public final void handleReloadModule(@NotNull ICommandSender commandSender, @CommandArgument(name="name") @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        LoadedModule module = Manager.Companion.getInstance().getCloudModuleHandler().getLoadedModuleByName(moduleName);
        if (module == null) {
            commandSender.sendProperty("manager.command.reload.module.not-exists", new String[0]);
            return;
        }
        Manager.Companion.getInstance().getCloudModuleHandler().unloadModule(module.getCloudModule());
        Manager.Companion.getInstance().getCloudModuleHandler().loadSingleModuleFromFile(module.getFile());
    }
}

