/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.commands;

import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.base.manager.commands.ScreenCommand;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.launcher.console.command.provider.ServiceCommandSuggestionProvider;
import eu.thesimplecloud.launcher.screens.IScreen;
import eu.thesimplecloud.launcher.screens.session.ScreenSession;
import eu.thesimplecloud.launcher.startup.Launcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Command(name="screen", commandType=CommandType.CONSOLE, permission="cloud.command.screen")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000e"}, d2={"Leu/thesimplecloud/base/manager/commands/ScreenCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "()V", "handleScreenNotExist", "Leu/thesimplecloud/launcher/screens/IScreen;", "commandSender", "Leu/thesimplecloud/api/command/ICommandSender;", "name", "", "listScreens", "", "screenCommand", "screenCommandKeep", "screenCommandReopen", "simplecloud-base"})
public final class ScreenCommand
implements ICommandHandler {
    @CommandSubPath(path="join <name>", description="Joins a screen")
    public final void screenCommand(@NotNull ICommandSender commandSender, @CommandArgument(name="name", suggestionProvider=ServiceCommandSuggestionProvider.class) @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IScreen iScreen = this.handleScreenNotExist(commandSender, name);
        if (iScreen == null) {
            return;
        }
        IScreen screen = iScreen;
        Launcher.Companion.getInstance().getScreenManager().joinScreen(new ScreenSession(screen, ScreenSession.ScreenCloseBehaviour.CLOSE));
    }

    @CommandSubPath(path="join <name> -reopen", description="Joins a screen and reopens the screen every time the service restarts")
    public final void screenCommandReopen(@NotNull ICommandSender commandSender, @CommandArgument(name="name", suggestionProvider=ServiceCommandSuggestionProvider.class) @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IScreen iScreen = this.handleScreenNotExist(commandSender, name);
        if (iScreen == null) {
            return;
        }
        IScreen screen = iScreen;
        Launcher.Companion.getInstance().getScreenManager().joinScreen(new ScreenSession(screen, ScreenSession.ScreenCloseBehaviour.REOPEN));
    }

    @CommandSubPath(path="join <name> -keep", description="Joins a screen and keeps it open after it closes")
    public final void screenCommandKeep(@NotNull ICommandSender commandSender, @CommandArgument(name="name", suggestionProvider=ServiceCommandSuggestionProvider.class) @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IScreen iScreen = this.handleScreenNotExist(commandSender, name);
        if (iScreen == null) {
            return;
        }
        IScreen screen = iScreen;
        Launcher.Companion.getInstance().getScreenManager().joinScreen(new ScreenSession(screen, ScreenSession.ScreenCloseBehaviour.KEEP_OPEN));
    }

    private final IScreen handleScreenNotExist(ICommandSender commandSender, String name) {
        IScreen screen = Launcher.Companion.getInstance().getScreenManager().getScreen(name);
        if (screen == null) {
            commandSender.sendProperty("manager.command.screen.not-exist", new String[0]);
            return null;
        }
        return screen;
    }

    @CommandSubPath(path="list", description="Lists all screens")
    public final void listScreens(@NotNull ICommandSender commandSender) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        commandSender.sendProperty("manager.command.screen.list", new String[0]);
        String screensString2 = CollectionsKt.joinToString$default((Iterable)Launcher.Companion.getInstance().getScreenManager().getAllScreens(), null, null, null, (int)0, null, (Function1)listScreens.screensString.1.INSTANCE, (int)31, null);
        commandSender.sendMessage(screensString2);
    }
}

