/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.database;

import com.mongodb.ConnectionString;
import com.mongodb.Function;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import eu.thesimplecloud.api.player.IOfflineCloudPlayer;
import eu.thesimplecloud.api.player.OfflineCloudPlayer;
import eu.thesimplecloud.api.player.connection.DefaultPlayerAddress;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.base.manager.database.AbstractOfflineCloudPlayerHandler;
import eu.thesimplecloud.base.manager.database.DatabaseConnectionInformation;
import eu.thesimplecloud.jsonlib.JsonLib;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.KMongo;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Leu/thesimplecloud/base/manager/database/MongoOfflineCloudPlayerHandler;", "Leu/thesimplecloud/base/manager/database/AbstractOfflineCloudPlayerHandler;", "databaseConnectionInformation", "Leu/thesimplecloud/base/manager/database/DatabaseConnectionInformation;", "(Leu/thesimplecloud/base/manager/database/DatabaseConnectionInformation;)V", "collection", "Lcom/mongodb/client/MongoCollection;", "Lorg/bson/Document;", "database", "Lcom/mongodb/client/MongoDatabase;", "getDatabase", "()Lcom/mongodb/client/MongoDatabase;", "getDatabaseConnectionInformation", "()Leu/thesimplecloud/base/manager/database/DatabaseConnectionInformation;", "mongoClient", "Lcom/mongodb/MongoClient;", "closeConnection", "", "createMongoClient", "deletePlayer", "playerUniqueId", "Ljava/util/UUID;", "getConnectionString", "Lcom/mongodb/ConnectionString;", "getOfflinePlayer", "Leu/thesimplecloud/api/player/IOfflineCloudPlayer;", "name", "", "getRegisteredPlayerCount", "", "saveCloudPlayer", "offlineCloudPlayer", "Leu/thesimplecloud/api/player/OfflineCloudPlayer;", "simplecloud-base"})
public final class MongoOfflineCloudPlayerHandler
extends AbstractOfflineCloudPlayerHandler {
    private final MongoClient mongoClient;
    @NotNull
    private final MongoDatabase database;
    private final MongoCollection<Document> collection;
    @NotNull
    private final DatabaseConnectionInformation databaseConnectionInformation;

    @NotNull
    public final MongoDatabase getDatabase() {
        return this.database;
    }

    private final ConnectionString getConnectionString() {
        String host = this.databaseConnectionInformation.getHost();
        int port = this.databaseConnectionInformation.getPort();
        String databaseName = this.databaseConnectionInformation.getDatabaseName();
        String userName = this.databaseConnectionInformation.getUserName();
        String password = this.databaseConnectionInformation.getPassword();
        if (StringsKt.isBlank((CharSequence)password) || StringsKt.isBlank((CharSequence)userName)) {
            return new ConnectionString("mongodb://" + host + ':' + port + '/' + databaseName);
        }
        return new ConnectionString("mongodb://" + userName + ':' + password + '@' + host + ':' + port + '/' + databaseName);
    }

    private final MongoClient createMongoClient() {
        return KMongo.INSTANCE.createClient(this.getConnectionString());
    }

    private final void deletePlayer(UUID playerUniqueId) {
        this.collection.deleteOne(Filters.eq((String)"uniqueId", (Object)playerUniqueId.toString()));
    }

    @Override
    @Nullable
    public IOfflineCloudPlayer getOfflinePlayer(@NotNull UUID playerUniqueId) {
        Intrinsics.checkNotNullParameter((Object)playerUniqueId, (String)"playerUniqueId");
        Bson bson = Filters.eq((String)"uniqueId", (Object)playerUniqueId.toString());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"Filters.eq(\"uniqueId\", playerUniqueId.toString())");
        Document document = (Document)MongoCollectionsKt.findOne(this.collection, (Bson)bson);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return (IOfflineCloudPlayer)JsonLib.Companion.fromObject((Object)document2, this.getDatabaseGson()).getObject(OfflineCloudPlayer.class);
    }

    @Override
    @Nullable
    public IOfflineCloudPlayer getOfflinePlayer(@NotNull String name) {
        MongoIterable players2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        FindIterable documents = MongoCollectionsKt.find(this.collection, (String)("{ $text: { $search: \"" + name + "\",$caseSensitive :false } }"));
        MongoIterable mongoIterable = players2 = documents.map((Function)new Function<Document, OfflineCloudPlayer>(this){
            final /* synthetic */ MongoOfflineCloudPlayerHandler this$0;

            public final OfflineCloudPlayer apply(Document it) {
                Document document = it;
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"it");
                return (OfflineCloudPlayer)JsonLib.Companion.fromObject((Object)document, this.this$0.getDatabaseGson()).getObject(OfflineCloudPlayer.class);
            }
            {
                this.this$0 = mongoOfflineCloudPlayerHandler;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"players");
        return this.getPlayerWithLatestLogin(KMongoIterableKt.toList((MongoIterable)mongoIterable));
    }

    @Override
    public synchronized void saveCloudPlayer(@NotNull OfflineCloudPlayer offlineCloudPlayer) {
        Intrinsics.checkNotNullParameter((Object)offlineCloudPlayer, (String)"offlineCloudPlayer");
        Document documentToSave = (Document)JsonLib.Companion.fromObject((Object)offlineCloudPlayer, this.getDatabaseGson()).getObject(Document.class);
        if (Intrinsics.areEqual(offlineCloudPlayer.getClass(), OfflineCloudPlayer.class) ^ true) {
            throw (Throwable)new IllegalStateException("Cannot save player of type " + offlineCloudPlayer.getClass().getSimpleName());
        }
        if (this.getOfflinePlayer(offlineCloudPlayer.getUniqueId()) != null) {
            this.collection.replaceOne(Filters.eq((String)"uniqueId", (Object)offlineCloudPlayer.getUniqueId().toString()), (Object)documentToSave);
        } else {
            this.collection.insertOne((Object)documentToSave);
        }
    }

    @Override
    public int getRegisteredPlayerCount() {
        return (int)this.collection.countDocuments();
    }

    @Override
    public void closeConnection() {
        this.mongoClient.close();
    }

    @NotNull
    public final DatabaseConnectionInformation getDatabaseConnectionInformation() {
        return this.databaseConnectionInformation;
    }

    /*
     * WARNING - void declaration
     */
    public MongoOfflineCloudPlayerHandler(@NotNull DatabaseConnectionInformation databaseConnectionInformation) {
        void $this$getCollection$iv;
        Intrinsics.checkNotNullParameter((Object)databaseConnectionInformation, (String)"databaseConnectionInformation");
        this.databaseConnectionInformation = databaseConnectionInformation;
        this.mongoClient = this.createMongoClient();
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.databaseConnectionInformation.getDatabaseName());
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"this.mongoClient.getData\u2026Information.databaseName)");
        MongoDatabase mongoDatabase2 = this.database = mongoDatabase;
        String collectionName$iv = this.databaseConnectionInformation.getCollectionPrefix() + "players";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, Document.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"getCollection(collectionName, T::class.java)");
        this.collection = mongoCollection;
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ MongoOfflineCloudPlayerHandler this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        MongoOfflineCloudPlayerHandler.access$getCollection$p(this.this$0).createIndex(Indexes.text((String)"name"));
                        v0 = playerUniqueId = UUID.randomUUID();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"playerUniqueId");
                        dummyPlayer = this.this$0.getOfflinePlayer(v0);
                        if (dummyPlayer != null) ** GOTO lbl26
                        playerConnection = new DefaultPlayerConnection(new DefaultPlayerAddress("127.0.0.1", 0), "Test", playerUniqueId, true, 42);
                        this.this$0.saveCloudPlayer(new OfflineCloudPlayer("Test", playerUniqueId, 1L, 1L, 1L, playerConnection, null, 64, null));
                        this.L$0 = playerUniqueId;
                        this.label = 1;
                        v1 = DelayKt.delay((long)100L, (Continuation)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl23
                    }
                    case 1: {
                        playerUniqueId = (UUID)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        v2 = playerUniqueId;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"playerUniqueId");
                        MongoOfflineCloudPlayerHandler.access$deletePlayer(this.this$0, v2);
lbl26:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = mongoOfflineCloudPlayerHandler;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ MongoCollection access$getCollection$p(MongoOfflineCloudPlayerHandler $this) {
        return $this.collection;
    }

    public static final /* synthetic */ void access$deletePlayer(MongoOfflineCloudPlayerHandler $this, UUID playerUniqueId) {
        $this.deletePlayer(playerUniqueId);
    }
}

