/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.database;

import eu.thesimplecloud.api.player.IOfflineCloudPlayer;
import eu.thesimplecloud.api.player.OfflineCloudPlayer;
import eu.thesimplecloud.base.manager.database.AbstractOfflineCloudPlayerHandler;
import eu.thesimplecloud.base.manager.database.DatabaseConnectionInformation;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020\rH\u0002J\b\u0010'\u001a\u00020\rH\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020$H\u0016R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Leu/thesimplecloud/base/manager/database/SQLOfflineCloudPlayerHandler;", "Leu/thesimplecloud/base/manager/database/AbstractOfflineCloudPlayerHandler;", "databaseConnectionInformation", "Leu/thesimplecloud/base/manager/database/DatabaseConnectionInformation;", "(Leu/thesimplecloud/base/manager/database/DatabaseConnectionInformation;)V", "<set-?>", "Ljava/sql/Connection;", "connection", "getConnection", "()Ljava/sql/Connection;", "playerCollectionName", "", "closeConnection", "", "createDatabaseAndIndicesIfNotExist", "createIndex", "columnName", "doesTableExist", "", "exist", "searchValue", "fieldName", "getAllDataStringsFromResultSet", "", "resultSet", "Ljava/sql/ResultSet;", "getOfflinePlayer", "Leu/thesimplecloud/api/player/IOfflineCloudPlayer;", "playerUniqueId", "Ljava/util/UUID;", "name", "getRegisteredPlayerCount", "", "loadPlayer", "value", "loadPlayerFromJsonString", "Leu/thesimplecloud/api/player/OfflineCloudPlayer;", "jsonString", "reconnect", "runReconnectLoop", "saveCloudPlayer", "offlineCloudPlayer", "simplecloud-base"})
public final class SQLOfflineCloudPlayerHandler
extends AbstractOfflineCloudPlayerHandler {
    @Nullable
    private Connection connection;
    private final String playerCollectionName;
    private final DatabaseConnectionInformation databaseConnectionInformation;

    @Nullable
    public final Connection getConnection() {
        return this.connection;
    }

    private final void createDatabaseAndIndicesIfNotExist() {
        if (!this.doesTableExist()) {
            Connection connection = this.connection;
            Intrinsics.checkNotNull((Object)connection);
            PreparedStatement statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.playerCollectionName + "` (`uniqueId` varchar(36), `name` varchar(16), `data` LONGBLOB)");
            statement.executeUpdate();
            this.createIndex("uniqueId");
            this.createIndex("name");
        }
    }

    private final void runReconnectLoop() {
        this.reconnect();
        Launcher.Companion.getInstance().getScheduler().scheduleAtFixedRate(new Runnable(this){
            final /* synthetic */ SQLOfflineCloudPlayerHandler this$0;

            public final void run() {
                SQLOfflineCloudPlayerHandler.access$reconnect(this.this$0);
            }
            {
                this.this$0 = sQLOfflineCloudPlayerHandler;
            }
        }, 1L, 1L, TimeUnit.HOURS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reconnect() {
        SQLOfflineCloudPlayerHandler sQLOfflineCloudPlayerHandler = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sQLOfflineCloudPlayerHandler) {
            boolean bl3 = false;
            this.closeConnection();
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.databaseConnectionInformation.getHost() + ':' + this.databaseConnectionInformation.getPort() + '/' + this.databaseConnectionInformation.getDatabaseName() + "?user=" + this.databaseConnectionInformation.getUserName() + "&password=" + this.databaseConnectionInformation.getPassword() + "&serverTimezone=UTC&autoReconnect=true");
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void createIndex(String columnName) {
        Connection connection = this.connection;
        Intrinsics.checkNotNull((Object)connection);
        PreparedStatement statement = connection.prepareStatement("ALTER TABLE " + this.playerCollectionName + " ADD INDEX (" + columnName + ')');
        statement.executeUpdate();
    }

    @Override
    @Nullable
    public IOfflineCloudPlayer getOfflinePlayer(@NotNull UUID playerUniqueId) {
        Intrinsics.checkNotNullParameter((Object)playerUniqueId, (String)"playerUniqueId");
        String string = playerUniqueId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"playerUniqueId.toString()");
        return this.loadPlayer(string, "uniqueId");
    }

    @Override
    @Nullable
    public IOfflineCloudPlayer getOfflinePlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.loadPlayer(name, "name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IOfflineCloudPlayer loadPlayer(String value, String fieldName) {
        SQLOfflineCloudPlayerHandler sQLOfflineCloudPlayerHandler = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sQLOfflineCloudPlayerHandler) {
            void $this$mapNotNullTo$iv$iv;
            ResultSet resultSet;
            block5: {
                boolean bl3 = false;
                if (this.exist(value, fieldName)) break block5;
                IOfflineCloudPlayer iOfflineCloudPlayer = null;
                return iOfflineCloudPlayer;
            }
            Connection connection = this.connection;
            Intrinsics.checkNotNull((Object)connection);
            PreparedStatement statement = connection.prepareStatement("SELECT `data` FROM `" + this.playerCollectionName + "` WHERE `" + fieldName + "` = ?");
            statement.setString(1, value);
            ResultSet resultSet2 = resultSet = statement.executeQuery();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet2, (String)"resultSet");
            List<String> allDataStrings = this.getAllDataStringsFromResultSet(resultSet2);
            Iterable $this$mapNotNull$iv = allDataStrings;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                OfflineCloudPlayer offlineCloudPlayer;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                if (this.loadPlayerFromJsonString(it) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                OfflineCloudPlayer it$iv$iv = offlineCloudPlayer;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List players2 = (List)destination$iv$iv;
            IOfflineCloudPlayer iOfflineCloudPlayer = this.getPlayerWithLatestLogin(players2);
            return iOfflineCloudPlayer;
        }
    }

    private final List<String> getAllDataStringsFromResultSet(ResultSet resultSet) {
        boolean bl = false;
        List returnList = new ArrayList();
        while (resultSet.next()) {
            try {
                String dataString;
                String string = dataString = resultSet.getString("data");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataString");
                returnList.add(string);
            }
            catch (SQLException sQLException) {}
        }
        return returnList;
    }

    private final OfflineCloudPlayer loadPlayerFromJsonString(String jsonString) {
        return (OfflineCloudPlayer)JsonLib.Companion.fromJsonString(jsonString, this.getDatabaseGson()).getObject(OfflineCloudPlayer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCloudPlayer(@NotNull OfflineCloudPlayer offlineCloudPlayer) {
        Intrinsics.checkNotNullParameter((Object)offlineCloudPlayer, (String)"offlineCloudPlayer");
        SQLOfflineCloudPlayerHandler sQLOfflineCloudPlayerHandler = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sQLOfflineCloudPlayerHandler) {
            boolean bl3 = false;
            String newData = JsonLib.Companion.fromObject((Object)offlineCloudPlayer, this.getDatabaseGson()).getAsJsonString();
            String string = offlineCloudPlayer.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"offlineCloudPlayer.getUniqueId().toString()");
            if (!this.exist(string, "uniqueId")) {
                Connection connection = this.connection;
                Intrinsics.checkNotNull((Object)connection);
                PreparedStatement statement = connection.prepareStatement("INSERT INTO `" + this.playerCollectionName + "` (`uniqueId`, `name`, `data`) VALUES (?, ?, ?)");
                statement.setString(1, offlineCloudPlayer.getUniqueId().toString());
                statement.setString(2, offlineCloudPlayer.getName());
                statement.setString(3, newData);
                statement.executeUpdate();
            } else {
                Connection connection = this.connection;
                Intrinsics.checkNotNull((Object)connection);
                PreparedStatement statement = connection.prepareStatement("UPDATE `" + this.playerCollectionName + "` SET `data` = ?, `name` = ? WHERE `uniqueId` = ?");
                statement.setString(1, newData);
                statement.setString(2, offlineCloudPlayer.getName());
                statement.setString(3, offlineCloudPlayer.getUniqueId().toString());
                statement.executeUpdate();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public int getRegisteredPlayerCount() {
        Connection connection = this.connection;
        Intrinsics.checkNotNull((Object)connection);
        PreparedStatement statement = connection.prepareStatement("SELECT COUNT(*) FROM `" + this.playerCollectionName + '`');
        ResultSet resultSet = statement.executeQuery();
        return !resultSet.next() ? 0 : resultSet.getInt(1);
    }

    @Override
    public void closeConnection() {
        block0: {
            Connection connection = this.connection;
            if (connection == null) break block0;
            connection.close();
        }
    }

    private final boolean exist(String searchValue, String fieldName) {
        Connection connection = this.connection;
        Intrinsics.checkNotNull((Object)connection);
        PreparedStatement prepareStatement = connection.prepareStatement("SELECT `data` FROM `" + this.playerCollectionName + "` WHERE `" + fieldName + "` = ?");
        prepareStatement.setString(1, searchValue);
        ResultSet resultSet = prepareStatement.executeQuery();
        return resultSet.next();
    }

    private final boolean doesTableExist() {
        Connection connection = this.connection;
        Intrinsics.checkNotNull((Object)connection);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"connection!!.metaData");
        DatabaseMetaData meta = databaseMetaData;
        ResultSet res = meta.getTables(null, null, this.playerCollectionName, new String[]{"TABLE"});
        return res.next();
    }

    public SQLOfflineCloudPlayerHandler(@NotNull DatabaseConnectionInformation databaseConnectionInformation) {
        Intrinsics.checkNotNullParameter((Object)databaseConnectionInformation, (String)"databaseConnectionInformation");
        this.databaseConnectionInformation = databaseConnectionInformation;
        this.playerCollectionName = this.databaseConnectionInformation.getCollectionPrefix() + "players";
        this.runReconnectLoop();
        this.createDatabaseAndIndicesIfNotExist();
    }

    public static final /* synthetic */ void access$reconnect(SQLOfflineCloudPlayerHandler $this) {
        $this.reconnect();
    }
}

