/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.filehandler;

import eu.thesimplecloud.api.config.IFileHandler;
import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.impl.DefaultLobbyGroup;
import eu.thesimplecloud.api.servicegroup.impl.DefaultProxyGroup;
import eu.thesimplecloud.api.servicegroup.impl.DefaultServerGroup;
import eu.thesimplecloud.base.manager.filehandler.CloudServiceGroupFileHandler$WhenMappings;
import eu.thesimplecloud.jsonlib.JsonLib;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/base/manager/filehandler/CloudServiceGroupFileHandler;", "Leu/thesimplecloud/api/config/IFileHandler;", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "()V", "delete", "", "value", "getAllFilesInDirectoryParsedAs", "", "T", "", "directory", "Ljava/io/File;", "clazz", "Ljava/lang/Class;", "getJsonFileForGroup", "cloudServiceGroup", "loadAll", "", "save", "simplecloud-base"})
public final class CloudServiceGroupFileHandler
implements IFileHandler<ICloudServiceGroup> {
    public void save(@NotNull ICloudServiceGroup value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        File file = this.getJsonFileForGroup(value);
        JsonLib.Companion.fromObject((Object)value).saveAsFile(file);
    }

    public void delete(@NotNull ICloudServiceGroup value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getJsonFileForGroup(value).delete();
    }

    @NotNull
    public Set<ICloudServiceGroup> loadAll() {
        List<DefaultProxyGroup> proxyGroups = this.getAllFilesInDirectoryParsedAs(new File(DirectoryPaths.Companion.getPaths().getProxyGroupsPath()), DefaultProxyGroup.class);
        List<DefaultLobbyGroup> lobbyGroups = this.getAllFilesInDirectoryParsedAs(new File(DirectoryPaths.Companion.getPaths().getLobbyGroupsPath()), DefaultLobbyGroup.class);
        List<DefaultServerGroup> serverGroups = this.getAllFilesInDirectoryParsedAs(new File(DirectoryPaths.Companion.getPaths().getServerGroupsPath()), DefaultServerGroup.class);
        return CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)proxyGroups, (Iterable)lobbyGroups), (Iterable)serverGroups);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> getAllFilesInDirectoryParsedAs(File directory, Class<T> clazz) {
        List list;
        File[] fileArray = directory.listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var9_8 = $this$mapTo$iv$iv;
            int n = ((void)var9_8).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_12 = item$iv$iv = var9_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)v1, null, (int)2, null);
                Object object = jsonLib != null ? jsonLib.getObjectOrNull(clazz) : null;
                collection.add(object);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List list2 = list;
        return CollectionsKt.filterNotNull((Iterable)list2);
    }

    private final File getJsonFileForGroup(ICloudServiceGroup cloudServiceGroup) {
        File file;
        switch (CloudServiceGroupFileHandler$WhenMappings.$EnumSwitchMapping$0[cloudServiceGroup.getServiceType().ordinal()]) {
            case 1: {
                file = new File(DirectoryPaths.Companion.getPaths().getProxyGroupsPath(), cloudServiceGroup.getName() + ".json");
                break;
            }
            case 2: {
                file = new File(DirectoryPaths.Companion.getPaths().getLobbyGroupsPath(), cloudServiceGroup.getName() + ".json");
                break;
            }
            case 3: {
                file = new File(DirectoryPaths.Companion.getPaths().getServerGroupsPath(), cloudServiceGroup.getName() + ".json");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return file;
    }
}

