/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.impl;

import com.google.common.collect.Maps;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.event.player.CloudPlayerServerConnectedEvent;
import eu.thesimplecloud.api.exception.NoSuchPlayerException;
import eu.thesimplecloud.api.exception.NoSuchServiceException;
import eu.thesimplecloud.api.exception.UnreachableComponentException;
import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOCloudPlayerForceCommandExecution;
import eu.thesimplecloud.api.network.packets.player.PacketIOConnectCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOGetPlayerLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOKickCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOPlayerHasPermission;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendActionbarToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendMessageToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendPlayerToLobby;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTablistToPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTitleToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOTeleportPlayer;
import eu.thesimplecloud.api.network.packets.sync.cachelist.PacketIOUpdateCacheObject;
import eu.thesimplecloud.api.player.AbstractCloudPlayerManager;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.IOfflineCloudPlayer;
import eu.thesimplecloud.api.player.OfflineCloudPlayer;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.base.manager.impl.CloudPlayerManagerImpl;
import eu.thesimplecloud.base.manager.startup.Manager;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromiseExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClient;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClientValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\nH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\nH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u001c\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\nH\u0016J\u0016\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010+\u001a\u00020\bH\u0016J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010-\u001a\u00020\bH\u0016J\u000e\u0010.\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\bJ\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u00100\u001a\u00020%H\u0016J\u0018\u00101\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u00102\u001a\u00020\bH\u0016J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u000205H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\f\u001a\u00020\rH\u0016J1\u00107\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\b092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\b09H\u0016\u00a2\u0006\u0002\u0010;J8\u0010<\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u00020#H\u0016J \u0010B\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010E\u001a\u00020!H\u0016J\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010E\u001a\u00020FH\u0016J&\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010G\u001a\u00020\u0014H\u0016Rf\u0010\u0003\u001aZ\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0007 \u0006*,\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Leu/thesimplecloud/base/manager/impl/CloudPlayerManagerImpl;", "Leu/thesimplecloud/api/player/AbstractCloudPlayerManager;", "()V", "playerUpdates", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "", "", "connectPlayer", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "cloudPlayer", "Leu/thesimplecloud/api/player/ICloudPlayer;", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "delete", "", "value", "fromPacket", "", "forcePlayerCommandExecution", "command", "getAllOnlinePlayers", "", "Leu/thesimplecloud/api/player/SimpleCloudPlayer;", "getCloudClientByServiceName", "Leu/thesimplecloud/clientserverapi/server/client/connectedclient/IConnectedClient;", "serviceName", "getCloudPlayer", "uniqueId", "name", "getLocationOfPlayer", "Leu/thesimplecloud/api/location/ServiceLocation;", "getNetworkOnlinePlayerCount", "", "getOfflineCloudPlayer", "Leu/thesimplecloud/api/player/IOfflineCloudPlayer;", "getPlayersConnectedToService", "getProxyClientOfCloudPlayer", "getRegisteredPlayerCount", "getServerClientOfPlayer", "hasPermission", "permission", "kickPlayer", "message", "resetPlayerUpdates", "savePlayerToDatabase", "offlinePlayer", "sendActionbar", "actionbar", "sendMessageToPlayer", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "sendPlayerToLobby", "sendTablist", "headers", "", "footers", "(Leu/thesimplecloud/api/player/ICloudPlayer;[Ljava/lang/String;[Ljava/lang/String;)V", "sendTitle", "title", "subTitle", "fadeIn", "stay", "fadeOut", "setUpdates", "update", "teleportPlayer", "location", "Leu/thesimplecloud/api/location/SimpleLocation;", "isCalledFromDelete", "simplecloud-base"})
public final class CloudPlayerManagerImpl
extends AbstractCloudPlayerManager {
    private final ConcurrentMap<UUID, List<String>> playerUpdates = Maps.newConcurrentMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<Unit> update(@NotNull ICloudPlayer value, boolean fromPacket, boolean isCalledFromDelete) {
        List requestedPlayerUpdatesServices;
        IConnectedClient iConnectedClient;
        IConnectedClient iConnectedClient2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.update((Object)value, fromPacket, isCalledFromDelete);
        ICloudService iCloudService = value.getConnectedProxy();
        if (iCloudService != null) {
            ICloudService iCloudService2 = iCloudService;
            boolean bl2 = false;
            bl = false;
            ICloudService it = iCloudService2;
            boolean bl3 = false;
            iConnectedClient2 = Manager.Companion.getInstance().getCommunicationServer().getClientManager().getClientByClientValue((IConnectedClientValue)it);
        } else {
            iConnectedClient2 = null;
        }
        IConnectedClient proxyClient = iConnectedClient2;
        ICloudService iCloudService3 = value.getConnectedServer();
        if (iCloudService3 != null) {
            ICloudService iCloudService4 = iCloudService3;
            bl = false;
            boolean it = false;
            ICloudService it2 = iCloudService4;
            boolean bl4 = false;
            iConnectedClient = Manager.Companion.getInstance().getCommunicationServer().getClientManager().getClientByClientValue((IConnectedClientValue)it2);
        } else {
            iConnectedClient = null;
        }
        IConnectedClient serverClient = iConnectedClient;
        PacketIOUpdateCacheObject playerUpdatePacket = new PacketIOUpdateCacheObject(this.getUpdater().getIdentificationName(), (Object)value, PacketIOUpdateCacheObject.Action.UPDATE);
        IConnectedClient iConnectedClient3 = proxyClient;
        if (iConnectedClient3 != null) {
            if (iConnectedClient3.isOpen()) {
                IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)proxyClient), (IPacket)((IPacket)playerUpdatePacket), (long)0L, (int)2, null);
            }
        }
        IConnectedClient iConnectedClient4 = serverClient;
        if (iConnectedClient4 != null) {
            if (iConnectedClient4.isOpen()) {
                IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)serverClient), (IPacket)((IPacket)playerUpdatePacket), (long)0L, (int)2, null);
            }
        }
        List list = requestedPlayerUpdatesServices = (List)this.playerUpdates.get(value.getUniqueId());
        if (list != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable bl4 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IConnectedClient<?> iConnectedClient5;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                if (this.getCloudClientByServiceName(it) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                IConnectedClient<?> it$iv$iv = iConnectedClient5;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                IConnectedClient it = (IConnectedClient)element$iv;
                boolean bl10 = false;
                IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)it), (IPacket)((IPacket)playerUpdatePacket), (long)0L, (int)2, null);
            }
        }
        return CommunicationPromise.Companion.getUNIT_PROMISE();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<Unit> delete(@NotNull ICloudPlayer value, boolean fromPacket) {
        List requestedPlayerUpdatesServices;
        IConnectedClient iConnectedClient;
        IConnectedClient iConnectedClient2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.delete(value, fromPacket);
        ICloudService iCloudService = value.getConnectedProxy();
        if (iCloudService != null) {
            ICloudService iCloudService2 = iCloudService;
            boolean bl2 = false;
            bl = false;
            ICloudService it = iCloudService2;
            boolean bl3 = false;
            iConnectedClient2 = Manager.Companion.getInstance().getCommunicationServer().getClientManager().getClientByClientValue((IConnectedClientValue)it);
        } else {
            iConnectedClient2 = null;
        }
        IConnectedClient proxyClient = iConnectedClient2;
        ICloudService iCloudService3 = value.getConnectedServer();
        if (iCloudService3 != null) {
            ICloudService iCloudService4 = iCloudService3;
            bl = false;
            boolean it = false;
            ICloudService it2 = iCloudService4;
            boolean bl4 = false;
            iConnectedClient = Manager.Companion.getInstance().getCommunicationServer().getClientManager().getClientByClientValue((IConnectedClientValue)it2);
        } else {
            iConnectedClient = null;
        }
        IConnectedClient serverClient = iConnectedClient;
        PacketIOUpdateCacheObject playerRemovePacket = new PacketIOUpdateCacheObject(this.getUpdater().getIdentificationName(), (Object)value, PacketIOUpdateCacheObject.Action.DELETE);
        IConnectedClient iConnectedClient3 = proxyClient;
        if (iConnectedClient3 != null) {
            IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iConnectedClient3), (IPacket)((IPacket)playerRemovePacket), (long)0L, (int)2, null);
        }
        IConnectedClient iConnectedClient4 = serverClient;
        if (iConnectedClient4 != null) {
            IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iConnectedClient4), (IPacket)((IPacket)playerRemovePacket), (long)0L, (int)2, null);
        }
        List list = requestedPlayerUpdatesServices = (List)this.playerUpdates.get(value.getUniqueId());
        if (list != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable bl4 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IConnectedClient<?> iConnectedClient5;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                if (this.getCloudClientByServiceName(it) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                IConnectedClient<?> it$iv$iv = iConnectedClient5;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                IConnectedClient it = (IConnectedClient)element$iv;
                boolean bl10 = false;
                IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)it), (IPacket)((IPacket)playerRemovePacket), (long)0L, (int)2, null);
            }
        }
        this.playerUpdates.remove(value.getUniqueId());
        IOfflineCloudPlayer iOfflineCloudPlayer = value.toOfflinePlayer();
        if (iOfflineCloudPlayer == null) {
            throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.player.OfflineCloudPlayer");
        }
        Manager.Companion.getInstance().getOfflineCloudPlayerHandler().saveCloudPlayer((OfflineCloudPlayer)iOfflineCloudPlayer);
        return CommunicationPromise.Companion.getUNIT_PROMISE();
    }

    @NotNull
    public ICommunicationPromise<ICloudPlayer> getCloudPlayer(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        return this.promiseOfNullablePlayer(this.getCachedCloudPlayer(uniqueId));
    }

    @NotNull
    public ICommunicationPromise<ICloudPlayer> getCloudPlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.promiseOfNullablePlayer(this.getCachedCloudPlayer(name));
    }

    @NotNull
    public ICommunicationPromise<Unit> sendMessageToPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull CloudText cloudText) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)cloudText, (String)"cloudText");
        ICommunicationPromise proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
        ICommunicationPromise iCommunicationPromise = proxyClient;
        if (iCommunicationPromise == null || (iCommunicationPromise = IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iCommunicationPromise), (IPacket)((IPacket)new PacketIOSendMessageToCloudPlayer(cloudPlayer, cloudText)), (long)0L, (int)2, null)) == null) {
            iCommunicationPromise = CommunicationPromise.Companion.failed((Throwable)new UnreachableComponentException("Proxy service is unreachable"));
        }
        return iCommunicationPromise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<ConnectionResponse> connectPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ICloudService cloudService) {
        void packet$iv;
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        if (cloudService.getServiceType() == ServiceType.PROXY) {
            return CommunicationPromise.Companion.failed((Throwable)new IllegalArgumentException("Cannot send player to a proxy service"));
        }
        if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedServerName(), (Object)cloudService.getName())) {
            return CommunicationPromise.Companion.of((Object)new ConnectionResponse(cloudPlayer.getUniqueId(), true));
        }
        IConnectedClient<?> proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
        if (proxyClient == null) {
            return CommunicationPromise.Companion.failed((Throwable)new UnreachableComponentException("Proxy service is unreachable"));
        }
        IPacketSender iPacketSender = (IPacketSender)proxyClient;
        IPacket iPacket = (IPacket)new PacketIOConnectCloudPlayer(cloudPlayer, cloudService);
        long timeout$iv = 500L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, ConnectionResponse.class, timeout$iv);
    }

    @NotNull
    public ICommunicationPromise<Unit> kickPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ICommunicationPromise proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
        ICommunicationPromise iCommunicationPromise = proxyClient;
        if (iCommunicationPromise == null || (iCommunicationPromise = IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iCommunicationPromise), (IPacket)((IPacket)new PacketIOKickCloudPlayer(cloudPlayer, message)), (long)0L, (int)2, null)) == null) {
            iCommunicationPromise = CommunicationPromise.Companion.of((Object)Unit.INSTANCE);
        }
        return iCommunicationPromise;
    }

    public void sendTitle(@NotNull ICloudPlayer cloudPlayer, @NotNull String title, @NotNull String subTitle, int fadeIn, int stay, int fadeOut) {
        block0: {
            IConnectedClient<?> proxyClient;
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)subTitle, (String)"subTitle");
            IConnectedClient<?> iConnectedClient = proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
            if (iConnectedClient == null) break block0;
            IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iConnectedClient), (IPacket)((IPacket)new PacketIOSendTitleToCloudPlayer(cloudPlayer, title, subTitle, fadeIn, stay, fadeOut)), (long)0L, (int)2, null);
        }
    }

    public void forcePlayerCommandExecution(@NotNull ICloudPlayer cloudPlayer, @NotNull String command) {
        block0: {
            IConnectedClient<?> proxyClient;
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            IConnectedClient<?> iConnectedClient = proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
            if (iConnectedClient == null) break block0;
            IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iConnectedClient), (IPacket)((IPacket)new PacketIOCloudPlayerForceCommandExecution(cloudPlayer, command)), (long)0L, (int)2, null);
        }
    }

    public void sendActionbar(@NotNull ICloudPlayer cloudPlayer, @NotNull String actionbar) {
        block0: {
            IConnectedClient<?> proxyClient;
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)actionbar, (String)"actionbar");
            IConnectedClient<?> iConnectedClient = proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
            if (iConnectedClient == null) break block0;
            IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iConnectedClient), (IPacket)((IPacket)new PacketIOSendActionbarToCloudPlayer(cloudPlayer, actionbar)), (long)0L, (int)2, null);
        }
    }

    public void sendTablist(@NotNull ICloudPlayer cloudPlayer, @NotNull String[] headers, @NotNull String[] footers) {
        block0: {
            IConnectedClient<?> proxyClient;
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)footers, (String)"footers");
            IConnectedClient<?> iConnectedClient = proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
            if (iConnectedClient == null) break block0;
            IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)iConnectedClient), (IPacket)((IPacket)new PacketIOSendTablistToPlayer(cloudPlayer.getUniqueId(), headers, footers)), (long)0L, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUpdates(@NotNull ICloudPlayer cloudPlayer, boolean update2, @NotNull String serviceName) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        super.setUpdates(cloudPlayer, update2, serviceName);
        if (!update2 && !this.playerUpdates.containsKey(cloudPlayer.getUniqueId())) {
            return;
        }
        ConcurrentMap<UUID, List<String>> concurrentMap = this.playerUpdates;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"this.playerUpdates");
        ConcurrentMap<UUID, List<String>> concurrentMap2 = concurrentMap;
        UUID key$iv = cloudPlayer.getUniqueId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List default$iv = list;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        List list = (List)object;
        if (update2) {
            list.add(serviceName);
        } else {
            list.remove(serviceName);
        }
    }

    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull SimpleLocation location) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        IConnectedClient<?> serverClient = this.getServerClientOfPlayer(cloudPlayer);
        if (serverClient == null) {
            return CommunicationPromise.Companion.failed((Throwable)new UnreachableComponentException("The server the player is connected to is not reachable"));
        }
        return IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)serverClient), (IPacket)((IPacket)new PacketIOTeleportPlayer(cloudPlayer, location)), (long)0L, (int)2, null);
    }

    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ServiceLocation location) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ICloudService iCloudService = location.getService();
        if (iCloudService == null) {
            return CommunicationPromise.Companion.failed((Throwable)new NoSuchServiceException("Service to connect the player to cannot be found"));
        }
        ICloudService service = iCloudService;
        return Intrinsics.areEqual((Object)service.getName(), (Object)cloudPlayer.getConnectedServerName()) ? cloudPlayer.teleport((SimpleLocation)location).addFailureListener((Function1)new Function1<Throwable, Unit>(cloudPlayer){
            final /* synthetic */ ICloudPlayer $cloudPlayer;

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$cloudPlayer.sendMessage("\u00a7cTeleportation failed: " + it.getMessage());
            }
            {
                this.$cloudPlayer = iCloudPlayer;
                super(1);
            }
        }) : CommunicationPromiseExtensionKt.flatten$default((ICommunicationPromise)CommunicationPromiseExtensionKt.flatten$default((ICommunicationPromise)cloudPlayer.connect(service).then((Function1)teleportPlayer.2.INSTANCE), (long)3000L, (boolean)false, (int)2, null).then((Function1)new Function1<CloudPlayerServerConnectedEvent, ICommunicationPromise<? extends Unit>>(cloudPlayer, location){
            final /* synthetic */ ICloudPlayer $cloudPlayer;
            final /* synthetic */ ServiceLocation $location;

            @Nullable
            public final ICommunicationPromise<Unit> invoke(@NotNull CloudPlayerServerConnectedEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ServiceLocation serviceLocation = this.$location;
                if (serviceLocation == null) {
                    throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.location.SimpleLocation");
                }
                return this.$cloudPlayer.teleport((SimpleLocation)serviceLocation);
            }
            {
                this.$cloudPlayer = iCloudPlayer;
                this.$location = serviceLocation;
                super(1);
            }
        }), (long)1500L, (boolean)false, (int)2, null).addFailureListener((Function1)new Function1<Throwable, Unit>(cloudPlayer){
            final /* synthetic */ ICloudPlayer $cloudPlayer;

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$cloudPlayer.sendMessage("\u00a7cTeleportation failed: " + it.getMessage());
            }
            {
                this.$cloudPlayer = iCloudPlayer;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull ICloudPlayer cloudPlayer, @NotNull String permission) {
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        IConnectedClient<?> proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
        if (proxyClient == null) {
            return CommunicationPromise.Companion.failed((Throwable)new UnreachableComponentException("The proxy the player is connected to is not reachable"));
        }
        IPacketSender iPacketSender = (IPacketSender)proxyClient;
        IPacket packet$iv = (IPacket)new PacketIOPlayerHasPermission(cloudPlayer.getUniqueId(), permission);
        long timeout$iv = 200L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery(packet$iv, Boolean.class, timeout$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocationOfPlayer(@NotNull ICloudPlayer cloudPlayer) {
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        IConnectedClient<?> serverClient = this.getServerClientOfPlayer(cloudPlayer);
        if (serverClient == null) {
            return CommunicationPromise.Companion.failed((Throwable)new UnreachableComponentException("The server the player is connected to is not reachable"));
        }
        IPacketSender iPacketSender = (IPacketSender)serverClient;
        IPacket packet$iv = (IPacket)new PacketIOGetPlayerLocation(cloudPlayer);
        long timeout$iv = 200L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery(packet$iv, ServiceLocation.class, timeout$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<Unit> sendPlayerToLobby(@NotNull ICloudPlayer cloudPlayer) {
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        IConnectedClient<?> proxyClient = this.getProxyClientOfCloudPlayer(cloudPlayer);
        if (proxyClient == null) {
            return CommunicationPromise.Companion.failed((Throwable)new UnreachableComponentException("The proxy the player is connected to is not reachable"));
        }
        IPacketSender iPacketSender = (IPacketSender)proxyClient;
        IPacket packet$iv = (IPacket)new PacketIOSendPlayerToLobby(cloudPlayer.getUniqueId());
        long timeout$iv = 200L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery(packet$iv, Unit.class, timeout$iv);
    }

    @NotNull
    public ICommunicationPromise<IOfflineCloudPlayer> getOfflineCloudPlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudPlayer onlineCloudPlayer = this.getCachedCloudPlayer(name);
        if (onlineCloudPlayer != null) {
            return CommunicationPromise.Companion.of((Object)onlineCloudPlayer);
        }
        IOfflineCloudPlayer offlinePlayer = Manager.Companion.getInstance().getOfflineCloudPlayerHandler().getOfflinePlayer(name);
        return CommunicationPromise.Companion.ofNullable((Object)offlinePlayer, (Throwable)new NoSuchPlayerException("Player not found"));
    }

    @NotNull
    public ICommunicationPromise<IOfflineCloudPlayer> getOfflineCloudPlayer(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        ICloudPlayer onlineCloudPlayer = this.getCachedCloudPlayer(uniqueId);
        if (onlineCloudPlayer != null) {
            return CommunicationPromise.Companion.of((Object)onlineCloudPlayer);
        }
        IOfflineCloudPlayer offlinePlayer = Manager.Companion.getInstance().getOfflineCloudPlayerHandler().getOfflinePlayer(uniqueId);
        return CommunicationPromise.Companion.ofNullable((Object)offlinePlayer, (Throwable)new NoSuchPlayerException("Player not found"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<List<SimpleCloudPlayer>> getAllOnlinePlayers() {
        Collection<SimpleCloudPlayer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getAllCachedObjects();
        CommunicationPromise.Companion companion = CommunicationPromise.Companion;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ICloudPlayer iCloudPlayer = (ICloudPlayer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            SimpleCloudPlayer simpleCloudPlayer = it.toSimplePlayer();
            collection.add(simpleCloudPlayer);
        }
        collection = (List)destination$iv$iv;
        return companion.of((Object)collection);
    }

    @NotNull
    public ICommunicationPromise<Integer> getNetworkOnlinePlayerCount() {
        return CommunicationPromise.Companion.of((Object)CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects().size());
    }

    @NotNull
    public ICommunicationPromise<Integer> getRegisteredPlayerCount() {
        return CommunicationPromise.Companion.of((Object)Manager.Companion.getInstance().getOfflineCloudPlayerHandler().getRegisteredPlayerCount());
    }

    @NotNull
    public ICommunicationPromise<Unit> savePlayerToDatabase(@NotNull IOfflineCloudPlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        return CommunicationPromise.Companion.runAsync((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(offlinePlayer, null){
            int label;
            final /* synthetic */ IOfflineCloudPlayer $offlinePlayer;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        IOfflineCloudPlayer iOfflineCloudPlayer = this.$offlinePlayer.toOfflinePlayer();
                        if (iOfflineCloudPlayer == null) {
                            throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.player.OfflineCloudPlayer");
                        }
                        Manager.Companion.getInstance().getOfflineCloudPlayerHandler().saveCloudPlayer((OfflineCloudPlayer)iOfflineCloudPlayer);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$offlinePlayer = iOfflineCloudPlayer;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ICommunicationPromise<List<SimpleCloudPlayer>> getPlayersConnectedToService(@NotNull ICloudService cloudService) {
        Collection<SimpleCloudPlayer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ICloudPlayer it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        Iterable $this$filter$iv = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ICloudPlayer)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getConnectedProxyName(), (Object)cloudService.getName()) || Intrinsics.areEqual((Object)it.getConnectedServerName(), (Object)cloudService.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playersOnService = (List)destination$iv$iv;
        $this$filter$iv = playersOnService;
        CommunicationPromise.Companion companion = CommunicationPromise.Companion;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ICloudPlayer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            SimpleCloudPlayer simpleCloudPlayer = it.toSimplePlayer();
            collection.add(simpleCloudPlayer);
        }
        collection = (List)destination$iv$iv;
        return companion.of((Object)collection);
    }

    private final IConnectedClient<?> getProxyClientOfCloudPlayer(ICloudPlayer cloudPlayer) {
        return this.getCloudClientByServiceName(cloudPlayer.getConnectedProxyName());
    }

    private final IConnectedClient<?> getServerClientOfPlayer(ICloudPlayer cloudPlayer) {
        IConnectedClient<?> iConnectedClient;
        String string = cloudPlayer.getConnectedServerName();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            iConnectedClient = this.getCloudClientByServiceName(it);
        } else {
            iConnectedClient = null;
        }
        return iConnectedClient;
    }

    private final IConnectedClient<?> getCloudClientByServiceName(String serviceName) {
        IConnectedClient iConnectedClient;
        ICloudService cloudService;
        ICloudService iCloudService = cloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serviceName);
        if (iCloudService != null) {
            ICloudService iCloudService2 = iCloudService;
            boolean bl = false;
            boolean bl2 = false;
            ICloudService it = iCloudService2;
            boolean bl3 = false;
            iConnectedClient = Manager.Companion.getInstance().getCommunicationServer().getClientManager().getClientByClientValue((IConnectedClientValue)it);
        } else {
            iConnectedClient = null;
        }
        return iConnectedClient;
    }

    public final void resetPlayerUpdates(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Iterable $this$forEach$iv = this.playerUpdates.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            it.remove(serviceName);
        }
    }
}

